/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.location;

import com.bbn.openmap.layer.location.LocationHandler;
import com.bbn.openmap.layer.location.LocationLayer;
import com.bbn.openmap.layer.location.LocationPopupMenu;
import com.bbn.openmap.util.ColorFactory;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractLocationHandler
implements LocationHandler {
    protected LocationLayer zLayer;
    private boolean showNames = false;
    protected Color nameColor;
    private boolean showLocations = true;
    protected Color locationColor;
    private boolean forceGlobal = true;
    protected String propertyPrefix = null;

    protected AbstractLocationHandler() {
        try {
            this.nameColor = ColorFactory.parseColor("FF339159", true);
            this.locationColor = ColorFactory.parseColor("FFCE4F3F", true);
        }
        catch (NumberFormatException nfe) {
            this.nameColor = Color.black;
            this.locationColor = Color.black;
        }
    }

    public void fillLocationPopUpMenu(LocationPopupMenu lpm) {
    }

    public void setLayer(LocationLayer l) {
        this.zLayer = l;
    }

    public LocationLayer getLayer() {
        return this.zLayer;
    }

    public boolean isShowNames() {
        return this.showNames;
    }

    public void setShowNames(boolean set) {
        this.showNames = set;
    }

    public boolean isShowLocations() {
        return this.showLocations;
    }

    public void setShowLocations(boolean set) {
        this.showLocations = set;
    }

    public boolean isForceGlobal() {
        return this.forceGlobal;
    }

    public void setForceGlobal(boolean set) {
        this.forceGlobal = set;
    }

    public void setNameColor(Color nColor) {
        this.nameColor = nColor;
    }

    public Color getNameColor() {
        return this.nameColor;
    }

    public void setLocationColor(Color lColor) {
        this.locationColor = lColor;
    }

    public Color getLocationColor() {
        return this.locationColor;
    }

    public Component getGUI() {
        JPanel jp = new JPanel();
        jp.add(new JLabel("No Palette"));
        return jp;
    }

    public void removed(Container cont) {
    }

    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    public void setProperties(String prefix, Properties properties) {
        this.propertyPrefix = prefix;
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.showLocations = PropUtils.booleanFromProperties(properties, prefix + "showLocations", this.showLocations);
        this.locationColor = PropUtils.parseColorFromProperties(properties, prefix + "locationColor", "FFCE4F3F");
        this.showNames = PropUtils.booleanFromProperties(properties, prefix + "showNames", this.showNames);
        this.nameColor = PropUtils.parseColorFromProperties(properties, prefix + "nameColor", "FF339159");
        this.forceGlobal = PropUtils.booleanFromProperties(properties, prefix + "override", this.forceGlobal);
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + "showNames", new Boolean(this.showNames).toString());
        props.put(prefix + "nameColor", Integer.toHexString(this.nameColor.getRGB()));
        props.put(prefix + "showLocations", new Boolean(this.showLocations).toString());
        props.put(prefix + "locationColor", Integer.toHexString(this.locationColor.getRGB()));
        props.put(prefix + "override", new Boolean(this.forceGlobal).toString());
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        list.put("showNames", "Display all the location name labels");
        list.put("showNames.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        list.put("nameColor", "Color of name label");
        list.put("nameColor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        list.put("showLocations", "Display all the location markers");
        list.put("showLocations.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        list.put("locationColor", "Color of location marker");
        list.put("locationColor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        list.put("override", "Layer settings override map object settings");
        list.put("override.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        return list;
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }
}

