/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.layer.link.LinkPropertiesConstants;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.ListIterator;

public class LinkOMGraphicList
extends OMGraphicList
implements LinkPropertiesConstants {
    private HashMap hash = new HashMap(541);
    protected Projection currentProjection = null;

    public LinkOMGraphicList() {
        super(10);
    }

    public LinkOMGraphicList(int initialCapacity) {
        super(initialCapacity);
    }

    public void setProjection(Projection proj) {
        this.currentProjection = proj;
    }

    public Projection getProjection() {
        return this.currentProjection;
    }

    public boolean getNeedToRegenerate(Projection proj) {
        return super.getNeedToRegenerate() || this.currentProjection != proj;
    }

    public synchronized void _add(OMGeometry g) {
        super._add(g);
        String id = ((LinkProperties)g.getAppObject()).getProperty("graphicID");
        if (Debug.debugging("linkdetail")) {
            Debug.output("LinkOMGraphicList: Adding graphic, id(" + id + ")");
        }
        if (id != null) {
            this.hash.put(id.intern(), g);
        }
    }

    protected synchronized Object _remove(int location) {
        String id;
        Object ret = super._remove(location);
        if (ret != null && (id = ((LinkProperties)((OMGeometry)ret).getAppObject()).getProperty("graphicID")) != null) {
            this.hash.remove(id.intern());
            if (Debug.debugging("link")) {
                Debug.output("LinkOMGraphicList: Removing graphic " + id);
            }
        }
        return ret;
    }

    protected synchronized boolean _remove(OMGeometry geometry) {
        boolean ret = super._remove(geometry);
        if (ret) {
            String id = ((LinkProperties)geometry.getAppObject()).getProperty("graphicID");
            this.hash.remove(id.intern());
            if (Debug.debugging("link")) {
                Debug.output("LinkOMGraphicList: Removing graphic " + id);
            }
        }
        return ret;
    }

    public synchronized void setOMGraphicAt(OMGraphic graphic, int index) {
        LinkProperties linkp = null;
        try {
            linkp = (LinkProperties)graphic.getAppObject();
            String id = null;
            if (linkp != null) {
                id = linkp.getProperty("graphicID");
                if (Debug.debugging("link")) {
                    Debug.output("LinkOMGraphicList.setOMGraphicAt(): Updating graphic " + id + " at " + index);
                }
                if (id != null) {
                    this.hash.put(id.intern(), graphic);
                }
            }
        }
        catch (ClassCastException cce) {
            Debug.error("LinkOMGraphicList.setOMGraphicAt(): Updated graphic doesn't have id");
        }
        super.setOMGraphicAt(graphic, index);
    }

    public OMGraphic getOMGraphicWithId(String gid) {
        return (OMGraphic)this.hash.get(gid.intern());
    }

    public int getOMGraphicIndexWithId(String gid) {
        OMGraphic graphic = this.getOMGraphicWithId(gid);
        if (graphic != null) {
            return super._indexOf(graphic);
        }
        return -1;
    }

    public synchronized void clear() {
        super.clear();
        this.hash.clear();
    }

    public synchronized void render(Graphics gr) {
        if (this.traverseMode == 1) {
            ListIterator iterator = this.graphics.listIterator(this.graphics.size());
            while (iterator.hasPrevious()) {
                OMGraphic graphic = (OMGraphic)iterator.previous();
                if (!graphic.isVisible()) continue;
                Object obj = graphic.getAppObject();
                if (Debug.debugging("linkdetail") && obj instanceof LinkProperties) {
                    String id = ((LinkProperties)obj).getProperty("graphicID");
                    Debug.output("LinkOMGraphicList: Rendering graphic " + id);
                }
                graphic.render(gr);
            }
        } else {
            ListIterator iterator = this.graphics.listIterator();
            while (iterator.hasNext()) {
                OMGraphic graphic = (OMGraphic)iterator.next();
                if (!graphic.isVisible()) continue;
                Object obj = graphic.getAppObject();
                if (Debug.debugging("linkdetail") && obj instanceof LinkProperties) {
                    String id = ((LinkProperties)obj).getProperty("graphicID");
                    Debug.output("LinkOMGraphicList: Rendering graphic " + id);
                }
                graphic.render(gr);
            }
        }
    }
}

