/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.dted;

import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.dted.DTEDFrameUtil;
import com.bbn.openmap.util.Debug;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DTEDFrameUHL {
    public int abs_vert_acc = -1;
    public float lat_origin;
    public int lat_post_interval;
    public float lon_origin;
    public int lon_post_interval;
    public int num_lat_points;
    public int num_lon_lines;
    public String sec_code;
    public String u_ref;

    public DTEDFrameUHL(BinaryFile binFile) {
        try {
            binFile.seek(0L);
            String checkUHL = binFile.readFixedLengthString(3);
            binFile.skipBytes(1L);
            this.lon_origin = DTEDFrameUtil.stringToLon(binFile.readFixedLengthString(8));
            this.lat_origin = DTEDFrameUtil.stringToLat(binFile.readFixedLengthString(8));
            try {
                this.lon_post_interval = Integer.parseInt(binFile.readFixedLengthString(4), 10);
            }
            catch (NumberFormatException pExp) {
                Debug.message("dted", "DTEDFrameUHL: lon_post_interval number bad, using 0");
                this.lon_post_interval = 0;
            }
            try {
                this.lat_post_interval = Integer.parseInt(binFile.readFixedLengthString(4), 10);
            }
            catch (NumberFormatException pExp) {
                Debug.message("dted", "DTEDFrameUHL: lat_post_interval number bad, using 0");
                this.lat_post_interval = 0;
            }
            String s_abs_vert_acc = binFile.readFixedLengthString(4);
            try {
                if (s_abs_vert_acc.indexOf("NA") == -1 && s_abs_vert_acc.indexOf("N/A") == -1) {
                    this.abs_vert_acc = Integer.parseInt(s_abs_vert_acc, 10);
                }
            }
            catch (NumberFormatException pExp) {
                Debug.message("dted", "DTEDFrameUHL: abs_vert_acc number bad, using 0");
                this.abs_vert_acc = 0;
            }
            this.sec_code = binFile.readFixedLengthString(3);
            this.u_ref = binFile.readFixedLengthString(12);
            try {
                this.num_lon_lines = Integer.parseInt(binFile.readFixedLengthString(4), 10);
            }
            catch (NumberFormatException pExp) {
                Debug.message("dted", "DTEDFrameUHL: num_lon_lines number bad, using 0");
                this.num_lon_lines = 0;
            }
            try {
                this.num_lat_points = Integer.parseInt(binFile.readFixedLengthString(4), 10);
            }
            catch (NumberFormatException pExp) {
                Debug.message("dted", "DTEDFrameUHL: num_lat_points number bad, using 0");
                this.num_lat_points = 0;
            }
        }
        catch (IOException e) {
            Debug.error("DTEDFrameUHL: File IO Error!\n" + e.toString());
        }
        catch (FormatException f) {
            Debug.error("DTEDFrameUHL: File IO Format error!\n" + f.toString());
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("***UHL***\n");
        s.append("  lon_origin: " + this.lon_origin + "\n");
        s.append("  lat_origin: " + this.lat_origin + "\n");
        s.append("  lon_post_interval: " + this.lon_post_interval + "\n");
        s.append("  lat_post_interval: " + this.lat_post_interval + "\n");
        s.append("  abs_vert_acc: " + this.abs_vert_acc + "\n");
        s.append("  sec_code: " + this.sec_code + "\n");
        s.append("  u_ref: " + this.u_ref + "\n");
        s.append("  num_lon_lines: " + this.num_lon_lines + "\n");
        s.append("  num_lat_points: " + this.num_lat_points + "\n");
        return s.toString();
    }

    public static void main(String[] args) {
        Debug.init();
        if (args.length < 1) {
            Debug.output("dtedframe_uhl:  Need a path/filename");
            System.exit(0);
        }
        Debug.output("DTEDFrameUHL: using frame " + args[0]);
        File file = new File(args[0]);
        try {
            BinaryBufferedFile binFile = new BinaryBufferedFile(file);
            DTEDFrameUHL dfu = new DTEDFrameUHL(binFile);
            Debug.output(dfu.toString());
        }
        catch (FileNotFoundException e) {
            Debug.error("DTEDFrameUHL: file " + args[0] + " not found");
            System.exit(-1);
        }
        catch (IOException e) {
            Debug.error("DTEDFrameUHL: File IO Error!\n" + e.toString());
        }
    }
}

