/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.dted;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.layer.dted.DTEDFrame;
import com.bbn.openmap.layer.dted.DTEDFrameCache;
import com.bbn.openmap.layer.dted.DTEDFrameColorTable;
import com.bbn.openmap.layer.dted.DTEDFrameSubframeInfo;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.proj.EqualArc;
import com.bbn.openmap.util.Debug;

public class DTEDCacheHandler {
    public static final int FRAME_CACHE_SIZE = 20;
    public static final int SF_PIXEL_HW = 200;
    protected String[] paths;
    protected String[] paths2;
    protected DTEDFrameCache frameCache;
    protected int frameCacheSize = -1;
    protected DTEDFrameColorTable colortable;
    protected LatLonPoint ulCoords;
    protected LatLonPoint lrCoords;
    protected double frameUp;
    protected double frameDown;
    protected double frameLeft;
    protected double frameRight;
    protected double xPixInterval;
    protected double yPixInterval;
    protected int numXSubframes;
    protected int numYSubframes;
    protected int lastSubframeWidth;
    protected int lastSubframeHeight;
    protected int currentFrameCacheSize = -10;
    protected boolean firstImageReturned = true;
    protected double frameLon = 0.0;
    protected double frameLat = 0.0;
    protected int subx = 0;
    protected int suby = 0;
    protected boolean newframe = false;
    protected DTEDFrame frame = null;
    protected DTEDFrameSubframeInfo dfsi = new DTEDFrameSubframeInfo(0, 25, 0, 3);

    public DTEDCacheHandler() {
        this(null, 216, 255, 20);
    }

    public DTEDCacheHandler(String[] dataPaths, int numColors, int opaque) {
        this(dataPaths, null, numColors, opaque, -1);
    }

    public DTEDCacheHandler(String[] dataPaths, String[] data2Paths, int numColors, int opaque) {
        this(dataPaths, data2Paths, numColors, opaque, -1);
    }

    public DTEDCacheHandler(String[] dataPaths, int numColors, int opaqueness, int subframe_cache_size) {
        this(dataPaths, null, numColors, opaqueness, subframe_cache_size);
    }

    public DTEDCacheHandler(String[] dataPaths, String[] data2Paths, int numColors, int opaqueness, int subframe_cache_size) {
        this.colortable = new DTEDFrameColorTable(numColors, opaqueness, true);
        this.setFrameCacheSize(subframe_cache_size);
        this.paths = dataPaths;
        this.paths2 = data2Paths;
        this.frameCache = new DTEDFrameCache(dataPaths, data2Paths, this.frameCacheSize);
        if (Debug.debugging("dted")) {
            Debug.output("DTEDCacheHandler: Created with cache size of " + this.frameCacheSize);
        }
    }

    public void setFrameCacheSize(int size) {
        this.frameCacheSize = size <= 0 ? 20 : size;
    }

    public int getFrameCacheSize() {
        return this.frameCacheSize;
    }

    public int getElevation(float lat, float lon) {
        return this.frameCache.getElevation(lat, lon);
    }

    public void setSubframeInfo(DTEDFrameSubframeInfo new_dfsi) {
        this.dfsi = new_dfsi;
        if (this.dfsi.viewType == 5) {
            this.colortable.setGreyScale(false);
        } else {
            this.colortable.setGreyScale(true);
        }
    }

    public void setProjection(EqualArc proj) {
        this.setProjection(proj, proj.getUpperLeft().getLatitude(), proj.getUpperLeft().getLongitude(), proj.getLowerRight().getLatitude(), proj.getLowerRight().getLongitude());
    }

    public void setProjection(EqualArc proj, float lat1, float lon1, float lat2, float lon2) {
        int numFramesNeeded;
        this.ulCoords = new LatLonPoint(lat1, lon1);
        this.lrCoords = new LatLonPoint(lat2, lon2);
        double xpi = 360.0 / proj.getXPixConstant();
        double ypi = 90.0 / proj.getYPixConstant();
        this.firstImageReturned = true;
        this.frameUp = Math.floor(lat1);
        this.frameDown = Math.floor(lat2);
        this.frameLeft = Math.floor(lon1);
        this.frameRight = Math.ceil(lon2);
        if (Debug.debugging("dted")) {
            Debug.output("frameUp = " + this.frameUp + ", frameDown = " + this.frameDown + ", frameLeft = " + this.frameLeft + ", frameRight = " + this.frameRight);
        }
        if (this.frameCacheSize > 0) {
            numFramesNeeded = this.frameCacheSize;
            if (Debug.debugging("dteddetail")) {
                Debug.output("DTEDCacheHandler: frameCacheSize remains at: " + numFramesNeeded);
            }
        } else {
            numFramesNeeded = (int)(Math.abs(this.frameUp - this.frameDown) * Math.abs(this.frameRight - this.frameLeft) * 2.0);
        }
        if (this.xPixInterval != xpi || this.yPixInterval != ypi) {
            this.xPixInterval = xpi;
            this.yPixInterval = ypi;
            this.dfsi.xPixInterval = this.xPixInterval;
            this.dfsi.yPixInterval = this.yPixInterval;
            if (xpi == 0.0 || ypi == 0.0) {
                this.numXSubframes = 0;
                this.numYSubframes = 0;
                return;
            }
            int frame_width = (int)Math.ceil(1.0 / xpi);
            int frame_height = (int)Math.ceil(1.0 / ypi);
            this.numXSubframes = frame_width / 200;
            this.lastSubframeWidth = 200;
            this.numYSubframes = frame_height / 200;
            this.lastSubframeHeight = 200;
            if (frame_width % 200 != 0) {
                this.lastSubframeWidth = frame_width - this.numXSubframes * 200;
                ++this.numXSubframes;
            }
            if (frame_height % 200 != 0) {
                this.lastSubframeHeight = frame_height - this.numYSubframes * 200;
                ++this.numYSubframes;
            }
            this.currentFrameCacheSize = numFramesNeeded;
            this.frameCache.resizeCache(numFramesNeeded, this.numXSubframes, this.numYSubframes);
            if (Debug.debugging("dteddetail")) {
                Debug.output("DTEDCacheHandler: frameCacheSize set to: " + numFramesNeeded);
            }
            if (Debug.debugging("dted")) {
                Debug.output("***** Screen Parameters Changed! \n Frame width (pix) = " + frame_width + "\n" + " Frame height (pix) = " + frame_height + "\n" + " Num x subframes = " + this.numXSubframes + "\n" + " Num y subframes = " + this.numYSubframes + "\n" + " last sf width = " + this.lastSubframeWidth + "\n" + " last sf height = " + this.lastSubframeHeight + "\n" + " X pix interval = " + xpi + "\n" + " Y pix interval = " + ypi + "\n");
            }
        } else if (Math.abs(numFramesNeeded - this.currentFrameCacheSize) > numFramesNeeded / 2) {
            this.currentFrameCacheSize = numFramesNeeded;
            this.frameCache.resizeCache(numFramesNeeded);
            if (Debug.debugging("dteddetail")) {
                Debug.output("DTEDCacheHandler: frameCacheSize set to: " + numFramesNeeded);
            }
        }
    }

    public OMRaster getNextImage() {
        OMRaster subframe = null;
        long sf_width = 200L;
        long sf_height = 200L;
        if (Debug.debugging("dted")) {
            Debug.output("--- DTEDCacheHandler: getNextImage:");
        }
        while (true) {
            if (this.firstImageReturned) {
                this.frameLon = this.frameLeft;
                this.frameLat = this.frameDown;
                this.subx = 0;
                this.suby = 0;
                this.newframe = true;
                this.firstImageReturned = false;
            } else if (this.frame != null && this.subx < this.numXSubframes) {
                if (this.suby < this.numYSubframes - 1) {
                    ++this.suby;
                } else {
                    this.suby = 0;
                    ++this.subx;
                }
            } else if (this.frameLon < this.frameRight) {
                this.subx = 0;
                this.suby = 0;
                if (this.frameLat < this.frameUp) {
                    this.frameLat += 1.0;
                } else {
                    this.frameLat = this.frameDown;
                    this.frameLon += 1.0;
                }
                this.newframe = true;
            } else {
                return null;
            }
            if (this.newframe && this.frameLon < this.frameRight) {
                if (Debug.debugging("dted")) {
                    Debug.output(" gni: Getting new frame Lat = " + this.frameLat + " Lon = " + this.frameLon);
                }
                this.frame = this.frameCache.get(this.frameLat, this.frameLon, this.dfsi.dtedLevel);
            }
            if (this.frame != null) {
                this.newframe = false;
                if (this.subx == this.numXSubframes - 1) {
                    sf_width = this.lastSubframeWidth;
                }
                if (this.suby == this.numYSubframes - 1) {
                    sf_height = this.lastSubframeHeight;
                }
                double sf_width_degrees = (double)sf_width * this.xPixInterval;
                double sf_height_degrees = (double)sf_height * this.yPixInterval;
                double width_degrees = 200.0 * this.xPixInterval;
                double height_degrees = 200.0 * this.yPixInterval;
                double sf_ullat = this.frameLat + 1.0 - (double)this.suby * height_degrees;
                double sf_ullon = this.frameLon + (double)this.subx * width_degrees;
                double sf_lrlat = this.frameLat + 1.0 - (double)this.suby * height_degrees - sf_height_degrees;
                double sf_lrlon = this.frameLon + (double)this.subx * width_degrees + sf_width_degrees;
                if ((double)this.ulCoords.getLatitude() > sf_lrlat && (double)this.lrCoords.getLatitude() < sf_ullat && (double)this.ulCoords.getLongitude() < sf_lrlon && (double)this.lrCoords.getLongitude() > sf_ullon && this.subx < this.numXSubframes) {
                    this.dfsi.height = (int)sf_height;
                    this.dfsi.width = (int)sf_width;
                    this.dfsi.lon = (float)sf_ullon;
                    this.dfsi.lat = (float)sf_ullat;
                    this.dfsi.subx = this.subx;
                    this.dfsi.suby = this.suby;
                    if (Debug.debugging("dteddetail")) {
                        Debug.output(" gni: Looking for Subframe " + this.subx + ", " + this.suby);
                    }
                    if ((subframe = this.frame.getSubframeOMRaster(this.dfsi, this.colortable)) != null) {
                        if (Debug.debugging("dted")) {
                            Debug.output(" gni: Subframe " + this.subx + ", " + this.suby + " found :)");
                        }
                        return subframe;
                    }
                } else if (Debug.debugging("dteddetail")) {
                    Debug.output(" gni: Subframe " + this.subx + ", " + this.suby + " didn't meet screen criteria");
                }
            }
            sf_width = 200L;
            sf_height = 200L;
        }
    }
}

