/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.Layer;
import com.bbn.openmap.event.OverviewMapStatusListener;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.Cylindrical;
import com.bbn.openmap.proj.Projection;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Properties;

public class OverviewMapAreaLayer
extends Layer
implements OverviewMapStatusListener {
    OMRect rectangle;
    float sourceScale;
    float overviewScale;
    LatLonPoint ul;
    LatLonPoint lr;
    DrawingAttributes boxAttributes = DrawingAttributes.getDefaultClone();

    public void projectionChanged(ProjectionEvent pEvent) {
        Projection proj = pEvent.getProjection();
        if (this.rectangle == null) {
            this.rectangle = new OMRect();
            this.boxAttributes.setTo(this.rectangle);
        }
        if (this.ul != null || this.lr != null) {
            if (proj instanceof Cylindrical) {
                Point ulp = proj.forward(this.ul);
                Point lrp = proj.forward(this.lr);
                this.rectangle.setLocation(ulp.x, ulp.y, lrp.x, lrp.y);
                this.rectangle.setLineType(1);
            } else {
                this.rectangle.setLocation(this.ul.getLatitude(), this.ul.getLongitude(), this.lr.getLatitude(), this.lr.getLongitude(), 2);
            }
            this.rectangle.generate(proj);
        }
        this.overviewScale = proj.getScale();
    }

    public void setSourceMapProjection(Projection proj) {
        this.ul = proj.getUpperLeft();
        this.lr = proj.getLowerRight();
        this.sourceScale = proj.getScale();
    }

    public OMRect getOverviewMapArea() {
        return this.rectangle;
    }

    public void paint(Graphics g) {
        if (this.rectangle != null && this.overviewScale > this.sourceScale) {
            this.rectangle.render(g);
        }
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        this.boxAttributes.setProperties(prefix, props);
        this.rectangle = null;
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        this.boxAttributes.getProperties(props);
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        this.boxAttributes.getPropertyInfo(props);
        return props;
    }
}

