/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer;

import com.bbn.openmap.dataAccess.shape.EsriShapeExport;
import com.bbn.openmap.event.MapMouseEvent;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.event.MapMouseInterpreter;
import com.bbn.openmap.tools.drawing.DrawingTool;
import com.bbn.openmap.tools.drawing.DrawingToolRequestor;
import com.bbn.openmap.tools.drawing.OMDrawingTool;
import com.bbn.openmap.tools.drawing.OMDrawingToolMouseMode;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JPanel;

public class DrawingToolLayer
extends OMGraphicHandlerLayer
implements DrawingToolRequestor {
    protected OMDrawingTool drawingTool;
    protected boolean showHints = true;
    public static final String ShowHintsProperty = "showHints";
    protected boolean DTL_DEBUG = false;
    protected MapMouseMode proxyMMM = null;

    public DrawingToolLayer() {
        this.setList(new OMGraphicList());
        this.setAddToBeanContext(true);
        this.DTL_DEBUG = Debug.debugging("dtl");
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.showHints = PropUtils.booleanFromProperties(props, realPrefix + ShowHintsProperty, this.showHints);
        if (this.getMouseModeIDsForEvents() == null) {
            this.setMouseModeIDsForEvents(new String[]{SelectMouseMode.modeID});
        }
    }

    public OMDrawingTool getDrawingTool() {
        return this.drawingTool;
    }

    public void setDrawingTool(OMDrawingTool dt) {
        this.drawingTool = dt;
    }

    public void drawingComplete(OMGraphic omg, OMAction action) {
        if (this.DTL_DEBUG) {
            String cname = omg.getClass().getName();
            int lastPeriod = cname.lastIndexOf(46);
            if (lastPeriod != -1) {
                cname = cname.substring(lastPeriod + 1);
            }
            Debug.output("DrawingToolLayer: DrawingTool complete for " + cname + " > " + action);
        }
        this.releaseProxyMouseMode();
        OMGraphicList omgl = new OMGraphicList();
        omgl.add(omg);
        this.deselect(omgl);
        OMGraphicList list = this.getList();
        if (list != null) {
            this.doAction(omg, action);
            this.repaint();
        } else {
            Debug.error("Layer " + this.getName() + " received " + omg + " and " + action + " with no list ready");
        }
    }

    public void releaseProxyMouseMode() {
        MapMouseMode pmmm = this.getProxyMouseMode();
        OMDrawingTool dt = this.getDrawingTool();
        if (pmmm != null && dt != null) {
            if (pmmm.isProxyFor(dt.getMouseMode())) {
                if (this.DTL_DEBUG) {
                    Debug.output("DTL: releasing proxy on " + pmmm.getID());
                }
                pmmm.releaseProxy();
                this.setProxyMouseMode(null);
                this.fireRequestInfoLine("");
            }
            if (dt.isActivated()) {
                dt.deactivate();
            }
        }
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof OMDrawingTool) {
            Debug.message("dtl", "DrawingToolLayer: found a drawing tool");
            this.setDrawingTool((OMDrawingTool)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof DrawingTool && this.getDrawingTool() == someObj) {
            this.setDrawingTool(null);
        }
    }

    protected synchronized void setProxyMouseMode(MapMouseMode mmm) {
        this.proxyMMM = mmm;
    }

    protected synchronized MapMouseMode getProxyMouseMode() {
        return this.proxyMMM;
    }

    public boolean shouldEdit(OMGraphic omgr) {
        return true;
    }

    public Component getGUI() {
        JPanel box = PaletteHelper.createVerticalPanel("Save Layer Graphics");
        box.setLayout(new GridLayout(0, 1));
        JButton button = new JButton("Save As Shape File");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                OMGraphicList list = DrawingToolLayer.this.getList();
                if (list != null) {
                    EsriShapeExport ese = new EsriShapeExport(list, DrawingToolLayer.this.getProjection(), null);
                    ese.export();
                } else {
                    DrawingToolLayer.this.fireRequestMessage("There's nothing on the map for this layer to save.");
                }
            }
        });
        box.add(button);
        return box;
    }

    public void setShowHints(boolean show) {
        this.showHints = show;
    }

    public boolean getShowHints() {
        return this.showHints;
    }

    public boolean isHighlightable(OMGraphic omg) {
        return this.showHints;
    }

    public boolean isSelectable(OMGraphic omg) {
        OMDrawingTool dt = this.getDrawingTool();
        return this.shouldEdit(omg) && dt != null && dt.canEdit(omg.getClass());
    }

    public String getInfoText(OMGraphic omg) {
        OMDrawingTool dt = this.getDrawingTool();
        if (dt != null && dt.canEdit(omg.getClass())) {
            return "Click to edit.";
        }
        return null;
    }

    public String getToolTipTextFor(OMGraphic omgr) {
        OMDrawingTool dt = this.getDrawingTool();
        if (this.shouldEdit(omgr) && dt.canEdit(omgr.getClass()) && !dt.isActivated()) {
            return "Click to Edit";
        }
        return null;
    }

    public void select(OMGraphicList omgl) {
        super.select(omgl);
        if (omgl != null && omgl.size() > 0) {
            if (omgl.size() == 1) {
                this.edit(omgl.getOMGraphicAt(0));
            } else {
                this.edit(omgl);
            }
        }
    }

    public void edit(OMGraphic omg) {
        OMDrawingTool dt = this.getDrawingTool();
        if (dt != null && dt.canEdit(omg.getClass())) {
            dt.resetBehaviorMask();
            OMDrawingToolMouseMode omdtmm = dt.getMouseMode();
            if (!omdtmm.isVisible()) {
                dt.setMask(16);
            }
            MapMouseInterpreter mmi = (MapMouseInterpreter)this.getMapMouseListener();
            MouseEvent mevent = null;
            if (mmi != null) {
                mevent = mmi.getCurrentMouseEvent();
            }
            if (omg.isSelected()) {
                omg.deselect();
            }
            if (dt.select(omg, this, mevent)) {
                if (this.DTL_DEBUG) {
                    Debug.output("DTL: starting edit of OMGraphic...");
                }
                if (!omdtmm.isVisible() && mevent instanceof MapMouseEvent) {
                    MapMouseMode mmm = ((MapMouseEvent)mevent).getMapMouseMode();
                    if (mmm.actAsProxyFor(omdtmm, 0)) {
                        if (this.DTL_DEBUG) {
                            Debug.output("DTL: Setting " + mmm.getID() + " as proxy for drawing tool");
                        }
                        this.setProxyMouseMode(mmm);
                    } else {
                        if (this.DTL_DEBUG) {
                            Debug.output("DTL: couldn't get proxy lock on " + mmm.getID() + " deactivating internal drawing tool");
                        }
                        dt.deactivate();
                    }
                } else if (this.DTL_DEBUG) {
                    Debug.output("DTL: MouseMode wants to be visible(" + omdtmm.isVisible() + "), or MouseEvent is not a MapMouseEvent(" + !(mevent instanceof MapMouseEvent) + ")");
                }
            } else if (this.DTL_DEBUG) {
                Debug.output("DTL.edit: dt.select returns false, avoiding modification over " + omg.getClass().getName());
            }
        }
    }
}

