/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.io;

import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.io.InputReader;
import com.bbn.openmap.util.Debug;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileInputReader
implements InputReader {
    protected RandomAccessFile inputFile = null;
    protected String name = null;

    public FileInputReader(File f) throws IOException {
        if (Debug.debugging("binaryfile")) {
            Debug.output("FileInputReader created from " + f.getAbsolutePath());
        }
        this.init(f);
    }

    public FileInputReader(String f) throws IOException {
        if (Debug.debugging("binaryfile")) {
            Debug.output("FileInputReader created from " + f);
        }
        this.init(new File(f));
    }

    public String getName() {
        return this.name;
    }

    protected void init(File f) throws IOException {
        try {
            this.name = f.getName();
            this.inputFile = new RandomAccessFile(f, "r");
        }
        catch (IOException i) {
            if (i instanceof FileNotFoundException) {
                throw i;
            }
            if (f.canRead()) {
                BinaryFile.closeClosable();
                this.inputFile = new RandomAccessFile(f, "r");
            }
            throw i;
        }
    }

    public RandomAccessFile getInputFile() {
        return this.inputFile;
    }

    public long skipBytes(long n) throws IOException {
        return this.inputFile.skipBytes((int)n);
    }

    public long getFilePointer() throws IOException {
        return this.inputFile.getFilePointer();
    }

    public void seek(long pos) throws IOException {
        this.inputFile.seek(pos);
    }

    public long length() throws IOException {
        return this.inputFile.length();
    }

    public long available() throws IOException {
        return this.length() - this.getFilePointer();
    }

    public void close() throws IOException {
        if (Debug.debugging("binaryfile")) {
            Debug.output("FileInputReader.close()");
        }
        try {
            if (this.inputFile != null) {
                this.inputFile.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.inputFile = null;
    }

    public int read() throws IOException {
        return this.inputFile.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.inputFile.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.inputFile.read(b);
    }

    public byte[] readBytes(int howmany, boolean allowless) throws EOFException, FormatException {
        byte[] foo = new byte[howmany];
        int gotsofar = 0;
        int err = 0;
        try {
            while (gotsofar < howmany) {
                err = this.inputFile.read(foo, gotsofar, howmany - gotsofar);
                if (err == -1) {
                    if (allowless) {
                        byte[] retval = new byte[gotsofar];
                        System.arraycopy(foo, 0, retval, 0, gotsofar);
                        return retval;
                    }
                    if (gotsofar > 0) {
                        throw new FormatException("EOF while reading data");
                    }
                    throw new EOFException();
                }
                gotsofar += err;
            }
        }
        catch (IOException i) {
            throw new FormatException("FileInputReader: readBytes IOException: " + i.getMessage());
        }
        return foo;
    }
}

