/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.time;

import com.bbn.openmap.gui.time.RealTimeHandler;
import com.bbn.openmap.gui.time.TimeConstants;
import com.bbn.openmap.util.Debug;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TimeSliderSupport
implements TimeConstants,
ChangeListener {
    protected JSlider timeSlider;
    protected RealTimeHandler rtHandler;
    protected long startTime;
    protected long endTime;

    public TimeSliderSupport(JSlider slider, RealTimeHandler rth, long startingTime, long endingTime) {
        this.timeSlider = slider;
        this.rtHandler = rth;
        this.startTime = startingTime;
        this.endTime = endingTime;
        if (Debug.debugging("timedetail")) {
            Debug.output("TimeSliderSupport: initialized to:" + this.startTime + ", " + this.endTime);
        }
        this.timeSlider.addChangeListener(this);
    }

    public void update(long time) {
        if (this.timeSlider != null) {
            int minimum = this.timeSlider.getMinimum();
            int maximum = this.timeSlider.getMaximum();
            if (time <= this.startTime) {
                this.timeSlider.setValue(minimum);
            } else if (time >= this.endTime) {
                this.timeSlider.setValue(maximum);
            } else {
                double diff = this.endTime - this.startTime;
                if (diff == 0.0) {
                    diff = 1.0;
                }
                double val = minimum;
                if (diff != 0.0) {
                    val = (double)(time - this.startTime) / diff * (double)(maximum - minimum);
                }
                if (Math.abs(val - (double)this.timeSlider.getValue()) > 1.0) {
                    if (Debug.debugging("timedetail")) {
                        Debug.output("TimeSliderSupport: Setting time slider to : " + val);
                    }
                    this.timeSlider.setValue((int)val);
                }
            }
        }
    }

    public void stateChanged(ChangeEvent ce) {
        if (ce.getSource() == this.timeSlider) {
            this.rtHandler.setTime(this.getTime());
        }
    }

    protected long getTime() {
        int maximum = this.timeSlider.getMaximum();
        int minimum = this.timeSlider.getMinimum();
        int value = this.timeSlider.getValue();
        try {
            return this.startTime + (this.endTime - this.startTime) * (long)value / (long)(maximum - minimum);
        }
        catch (ArithmeticException ae) {
            Debug.error("TimeSliderSupport.getTime(): " + ae.getMessage());
            if (Debug.debugging("timedetail")) {
                ae.printStackTrace();
            }
            return this.startTime;
        }
    }

    public void setTimeSlider(JSlider jslider) {
        this.timeSlider = jslider;
    }

    public JSlider setTimeSlider() {
        return this.timeSlider;
    }

    public void setHandler(RealTimeHandler rth) {
        this.rtHandler = rth;
    }

    public RealTimeHandler getHandler() {
        return this.rtHandler;
    }

    public void setStartTime(long time) {
        this.startTime = time;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setEndTime(long time) {
        this.endTime = time;
    }

    public long getEndTime() {
        return this.endTime;
    }
}

