/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.menu;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.event.ProjectionSupport;
import com.bbn.openmap.gui.AbstractOpenMapMenu;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionException;
import com.bbn.openmap.proj.ProjectionFactory;
import com.bbn.openmap.proj.ProjectionLoader;
import com.bbn.openmap.util.Debug;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class ProjectionMenu
extends AbstractOpenMapMenu
implements ActionListener,
ProjectionListener,
PropertyChangeListener {
    public static final String defaultText = "Projection";
    protected transient ProjectionSupport projectionSupport = new ProjectionSupport(this);
    protected transient Projection projection;
    protected transient Component projComponent;
    public static final transient String projCmd = "setProj";

    public ProjectionMenu() {
        this.setText(this.i18n.get(this, "projectionMenu", defaultText));
    }

    public void configure(Vector loaders) {
        this.removeAll();
        ButtonGroup group = new ButtonGroup();
        Iterator it = loaders.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof ProjectionLoader)) continue;
            ProjectionLoader pl = (ProjectionLoader)obj;
            JRadioButtonMenuItem rb = new JRadioButtonMenuItem(pl.getPrettyName());
            rb.setActionCommand(projCmd);
            String plclassname = pl.getProjectionClass().getName();
            rb.setName(plclassname);
            rb.setToolTipText(pl.getDescription());
            rb.addActionListener(this);
            group.add(rb);
            this.add(rb);
        }
        this.setProjection(this.projection);
    }

    public void actionPerformed(ActionEvent ae) {
        block2: {
            String command = ae.getActionCommand();
            Debug.message("projectionmenu", "ProjectionMenu.actionPerformed(): " + command);
            if (command != projCmd) break block2;
            JRadioButtonMenuItem rb = (JRadioButtonMenuItem)ae.getSource();
            String projclassname = rb.getName();
            Debug.message("projectionmenu", "ProjectionMenu new proj name: " + projclassname);
            try {
                Projection newProj = ProjectionFactory.makeProjection(projclassname, this.projection);
                this.fireProjectionChanged(newProj);
            }
            catch (ProjectionException pe) {
                rb.setEnabled(false);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName() == "AvailableProjections") {
            this.configure((Vector)pce.getNewValue());
        }
    }

    public void projectionChanged(ProjectionEvent e) {
        if (Debug.debugging("projectionmenu")) {
            System.out.println("ProjectionMenu.projectionChanged()");
        }
        Projection newProj = e.getProjection();
        if (this.projection == null || !this.projection.equals(newProj)) {
            this.setProjection(newProj.makeClone());
            Object source = e.getSource();
            if (source instanceof Component) {
                this.projComponent = (Component)source;
            }
        }
    }

    protected synchronized void setProjection(Projection aProjection) {
        this.projection = aProjection;
        if (this.projection == null) {
            return;
        }
        String newProjClassName = this.projection.getClass().getName();
        int i = 0;
        while (i < this.getItemCount()) {
            JMenuItem item = this.getItem(i);
            if (newProjClassName.equals(item.getName())) {
                if (Debug.debugging("projectionmenu")) {
                    Debug.output("ProjectionMenu | setting " + item.getName() + " as active");
                }
                item.setSelected(true);
                return;
            }
            ++i;
        }
    }

    public void setupListeners(MapBean map) {
        Debug.message("projectionmenu", "ProjectionMenu | setupListeners");
        this.addProjectionListener(map);
        map.addProjectionListener(this);
    }

    public void undoListeners(MapBean map) {
        this.removeProjectionListener(map);
        map.removeProjectionListener(this);
    }

    protected synchronized void addProjectionListener(ProjectionListener l) {
        this.projectionSupport.addProjectionListener(l);
    }

    protected synchronized void removeProjectionListener(ProjectionListener l) {
        this.projectionSupport.removeProjectionListener(l);
    }

    public void fireProjectionChanged(Projection p) {
        this.projectionSupport.fireProjectionChanged(p);
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof MapBean) {
            this.setupListeners((MapBean)someObj);
        }
        if (someObj instanceof ProjectionFactory) {
            ((ProjectionFactory)someObj).addPropertyChangeListener(this);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof MapBean) {
            this.undoListeners((MapBean)someObj);
        }
        if (someObj instanceof ProjectionFactory) {
            ((ProjectionFactory)someObj).removePropertyChangeListener(this);
        }
    }
}

