/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.event.ZoomListener;
import com.bbn.openmap.event.ZoomSupport;
import com.bbn.openmap.gui.OMToolComponent;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JTextField;

public class ScaleTextPanel
extends OMToolComponent
implements Serializable,
ActionListener,
ProjectionListener {
    public static final String defaultKey = "scaletext";
    public static final transient String setScaleCmd = "setScale";
    protected String key = "scaletext";
    protected transient JTextField scaleField = null;
    protected transient ZoomSupport zoomDelegate = null;
    protected Projection projection;
    protected transient DecimalFormat df = new DecimalFormat("###,###,###");
    static /* synthetic */ Class class$com$bbn$openmap$gui$ScaleTextPanel;

    public ScaleTextPanel() {
        this.setKey(defaultKey);
        this.zoomDelegate = new ZoomSupport(this);
        String entry = "";
        String info = "Scale";
        String command = setScaleCmd;
        this.scaleField = new JTextField(entry, 10);
        this.scaleField.setToolTipText(this.i18n.get(class$com$bbn$openmap$gui$ScaleTextPanel == null ? (class$com$bbn$openmap$gui$ScaleTextPanel = ScaleTextPanel.class$("com.bbn.openmap.gui.ScaleTextPanel")) : class$com$bbn$openmap$gui$ScaleTextPanel, command, 3, info));
        this.scaleField.setMargin(new Insets(0, 0, 0, 0));
        this.scaleField.setActionCommand(command);
        this.scaleField.addActionListener(this);
        this.scaleField.setHorizontalAlignment(4);
        this.gridbag.setConstraints(this.scaleField, this.c);
        this.add(this.scaleField);
    }

    public synchronized void setProjection(Projection aProjection) {
        String newScale;
        String oldScale;
        this.projection = aProjection;
        if (Debug.debugging("scaletextpanel")) {
            System.out.println("ScaleTextPanel.setProjection(): scale is " + this.projection.getScale() + " \"" + String.valueOf(this.projection.getScale()) + "\"");
        }
        if (!(oldScale = this.scaleField.getText()).equals(newScale = this.df.format(this.projection.getScale()))) {
            this.scaleField.setText("1:" + newScale);
        }
    }

    public synchronized void addZoomListener(ZoomListener listener) {
        this.zoomDelegate.addZoomListener(listener);
    }

    public synchronized void removeZoomListener(ZoomListener listener) {
        this.zoomDelegate.removeZoomListener(listener);
    }

    public void setupListeners(MapBean aMap) {
        if (aMap != null) {
            this.addZoomListener(aMap);
            aMap.addProjectionListener(this);
            this.scaleField.setText("1:" + String.valueOf(aMap.getScale()));
        }
    }

    public void removeFromAllListeners(MapBean mapBean) {
        if (mapBean != null) {
            this.removeZoomListener(mapBean);
            mapBean.removeProjectionListener(this);
            this.scaleField.setText("----");
        }
    }

    public JTextField getScaleField() {
        return this.scaleField;
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (Debug.debugging("scaletextpanel")) {
            Debug.output("ScaleTextPanel.actionPerformed(): " + command);
        }
        if (command.equals(setScaleCmd)) {
            this.setScale(this.scaleField.getText());
        }
    }

    protected void fireScaleChange(float scale) {
        if (Debug.debugging("scaletextpanel")) {
            Debug.output("ScaleTextPanel setting scale to " + scale);
        }
        this.zoomDelegate.fireZoom(302, scale);
    }

    private void setScale(String strscale) {
        block12: {
            int colon = strscale.indexOf(58);
            if (colon > -1) {
                strscale = strscale.substring(colon + 1);
            }
            try {
                if (strscale.toLowerCase().endsWith("m")) {
                    float scale = this.df.parse(strscale = strscale.substring(0, strscale.length() - 1)).floatValue() * 1000000.0f;
                    if (scale < 1.0f) {
                        System.err.println("ScaleTextPanel.applyScale(): problem");
                    } else {
                        this.fireScaleChange(scale);
                    }
                    break block12;
                }
                if (strscale.toLowerCase().endsWith("k")) {
                    float scale = this.df.parse(strscale = strscale.substring(0, strscale.length() - 1)).floatValue() * 1000.0f;
                    if (scale < 1.0f) {
                        System.err.println("ScaleTextPanel.applyScale(): problem");
                    } else {
                        this.fireScaleChange(scale);
                    }
                    break block12;
                }
                if (strscale.trim().equals("")) {
                    return;
                }
                float scale = this.df.parse(strscale).floatValue();
                if (scale < 1.0f) {
                    System.err.println("ScaleTextPanel.applyScale(): problem");
                    break block12;
                }
                this.fireScaleChange(scale);
            }
            catch (ParseException e) {
                System.err.println("ScaleTextPanel.setScale(): invalid scale: " + strscale);
            }
            catch (NumberFormatException e) {
                System.err.println("ScaleTextPanel.setScale(): invalid scale: " + strscale);
            }
        }
    }

    public void projectionChanged(ProjectionEvent e) {
        if (Debug.debugging("scaletextpanel")) {
            System.out.println("ScaleTextPanel.projectionChanged()");
        }
        Projection newProj = e.getProjection();
        if (this.projection == null || !this.projection.equals(newProj)) {
            this.setProjection(newProj.makeClone());
        }
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof MapBean) {
            this.setupListeners((MapBean)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof MapBean) {
            this.removeFromAllListeners((MapBean)someObj);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

