/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.event.ProgressEvent;
import com.bbn.openmap.event.ProgressListener;
import com.bbn.openmap.gui.WindowSupport;
import com.bbn.openmap.util.Debug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressListenerGauge
extends JPanel
implements ProgressListener {
    protected JLabel message;
    protected JProgressBar jpb;
    protected boolean createWindowsForDisplay = false;
    protected String title;
    protected WindowSupport windowSupport = null;

    public ProgressListenerGauge() {
        this.init();
    }

    public ProgressListenerGauge(String windowTitle) {
        this.createWindowsForDisplay = true;
        this.title = windowTitle;
        this.init();
    }

    protected synchronized void manageWindow(boolean visible) {
        if (visible) {
            if (this.windowSupport == null) {
                this.windowSupport = new WindowSupport(this, this.title);
            }
            this.windowSupport.displayInWindow();
        } else if (this.windowSupport != null) {
            this.windowSupport.killWindow();
        }
    }

    protected synchronized void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel("     "), "East");
        this.add((Component)new JLabel("     "), "West");
        this.add((Component)new JLabel("      "), "North");
        this.add((Component)new JLabel("      "), "South");
        this.message = new JLabel("");
        this.jpb = new JProgressBar(0, 100);
        JPanel cpanel = new JPanel();
        cpanel.setLayout(new GridLayout(0, 1));
        cpanel.add(this.jpb);
        cpanel.add(this.message);
        this.add((Component)cpanel, "Center");
        this.setPreferredSize(new Dimension(300, 75));
    }

    public synchronized void setVisible(boolean set) {
        if (this.createWindowsForDisplay) {
            this.manageWindow(set);
        } else {
            super.setVisible(set);
        }
    }

    public synchronized void updateProgress(ProgressEvent evt) {
        int type = evt.getType();
        if (type == 0 || type == 1) {
            this.setVisible(true);
            this.message.setText(evt.getTaskDescription());
            this.jpb.setValue(evt.getPercentComplete());
        } else {
            this.setVisible(false);
        }
    }

    protected synchronized void setPosition(Component comp) {
        int w = comp.getWidth();
        int h = comp.getHeight();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Debug.message("basic", "Screen dimensions are " + d);
        int x = d.width / 2 - w / 2;
        int y = d.height / 2 - h / 2;
        if (Debug.debugging("basic")) {
            Debug.output("Setting PLG frame X and Y from properties to " + x + " " + y);
        }
        comp.setBounds(x, y, w, h);
    }
}

