/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.graphicLoader;

import com.bbn.openmap.Environment;
import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.util.Assert;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyVetoException;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class GLPoint
extends OMPoint
implements ActionListener,
FocusListener {
    public static Color CONNECTED_COLOR = Color.green;
    public static Color DISCONNECTED_COLOR = Color.red;
    protected boolean stationary = true;
    protected String name;
    protected int height = 0;
    protected transient Container palette = null;
    JCheckBox movementButton = null;
    JTextField heightField = null;
    public static final String MoveCmd = "MoveCommand";

    public GLPoint(float lat, float lon, int radius, boolean isOval) {
        super(lat, lon, radius);
        this.setOval(isOval);
    }

    public void resetConnected() {
        this.setFillPaint(DISCONNECTED_COLOR);
    }

    public void connected(boolean connected) {
        if (connected) {
            this.setFillPaint(CONNECTED_COLOR);
        }
    }

    protected void moveRandomly(float factor) {
        double hor = Math.random() - 0.5;
        double vert = Math.random() - 0.5;
        this.setLat(this.getLat() + (float)vert * factor);
        this.setLon(this.getLon() + (float)hor * factor);
    }

    public void move(float factor) {
        if (!this.stationary) {
            this.moveRandomly(factor);
        }
    }

    public void move(int distance, Length units, float Az) {
        LatLonPoint newLocation = GreatCircle.spherical_between(ProjMath.degToRad(this.getLat()), ProjMath.degToRad(this.getLon()), units.toRadians(distance), Az);
        this.setLat(newLocation.getLatitude());
        this.setLon(newLocation.getLongitude());
    }

    public void setStationary(boolean set) {
        this.stationary = set;
        if (this.movementButton != null) {
            this.movementButton.setSelected(set);
        }
    }

    public boolean getStationary() {
        return this.stationary;
    }

    public void setName(String set) {
        this.name = set;
    }

    public String getName() {
        return this.name;
    }

    public void setHeight(int h) {
        this.height = h;
        if (this.heightField != null) {
            this.heightField.setText(Integer.toString(h));
        }
        if (Debug.debugging("graphicloader")) {
            Debug.output("GLPoint: " + this.getName() + " setting height to : " + h);
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void showPalette() {
        if (Environment.getBoolean("openmap.UseInternalFrames")) {
            final JLayeredPane desktop = Environment.getInternalFrameDesktop();
            this.palette = PaletteHelper.getPaletteInternalWindow(this.getGUI(), this.getName(), new InternalFrameAdapter(){

                public void internalFrameClosed(InternalFrameEvent e) {
                    if (desktop != null) {
                        desktop.remove((JInternalFrame)GLPoint.this.palette);
                        desktop.repaint();
                    }
                    GLPoint.this.palette = null;
                }
            });
            if (desktop != null) {
                desktop.add(this.palette);
                this.palette.setVisible(true);
            }
        } else {
            if (this.palette == null) {
                this.palette = PaletteHelper.getPaletteWindow(this.getGUI(), this.getName(), new ComponentAdapter(){

                    public void componentHidden(ComponentEvent e) {
                    }
                });
            }
            this.palette.setVisible(true);
            ((JFrame)this.palette).setState(0);
        }
    }

    public void hidePalette() {
        if (this.palette == null) {
            return;
        }
        if (Environment.getBoolean("openmap.UseInternalFrames")) {
            try {
                ((JInternalFrame)this.palette).setClosed(true);
            }
            catch (PropertyVetoException evt) {
                Assert.assertExp(false, "GLPoint.hidePalette(): internal error!");
            }
        } else {
            this.palette.setVisible(false);
        }
    }

    public Component getGUI() {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        if (this.movementButton == null) {
            this.movementButton = new JCheckBox("Stationary", this.getStationary());
            this.movementButton.addActionListener(this);
            this.movementButton.setActionCommand(MoveCmd);
        }
        panel.add(this.movementButton);
        JPanel heightPanel = new JPanel(new GridLayout(0, 3));
        heightPanel.add(new JLabel("Object height: "));
        if (this.heightField == null) {
            this.heightField = new JTextField(Integer.toString(this.height), 10);
            this.heightField.setHorizontalAlignment(4);
            this.heightField.addActionListener(this);
            this.heightField.addFocusListener(this);
        }
        heightPanel.add(this.heightField);
        heightPanel.add(new JLabel(" meters"));
        panel.add(heightPanel);
        return panel;
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd == MoveCmd) {
            JCheckBox check = (JCheckBox)ae.getSource();
            this.setStationary(check.isSelected());
        } else {
            try {
                this.setHeight(Integer.parseInt(cmd));
            }
            catch (NumberFormatException nfe) {
                this.setHeight(this.getHeight());
            }
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        try {
            this.setHeight(Integer.parseInt(((JTextField)e.getSource()).getText()));
        }
        catch (NumberFormatException nfe) {
            this.setHeight(0);
        }
    }
}

