/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape.output;

import com.bbn.openmap.dataAccess.shape.DbfTableModel;
import com.bbn.openmap.dataAccess.shape.output.LittleEndianOutputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;

public class DbfOutputStream {
    private LittleEndianOutputStream _leos;

    public DbfOutputStream(OutputStream os) {
        BufferedOutputStream bos = new BufferedOutputStream(os);
        this._leos = new LittleEndianOutputStream(bos);
    }

    public void writeModel(DbfTableModel model) throws IOException {
        int rowCount = model.getRowCount();
        short headerLength = this.calcHeaderLength(model);
        short recordLength = this.calcRecordLength(model);
        this.writeHeader(rowCount, headerLength, recordLength);
        this.writeFieldDescriptors(model);
        this.writeRecords(model);
        this.close();
    }

    public short calcRecordLength(DbfTableModel model) {
        int length = 0;
        int columnCount = model.getColumnCount();
        int i = 0;
        while (i <= columnCount - 1) {
            length += model.getLength(i);
            ++i;
        }
        Integer integer = new Integer(++length);
        return integer.shortValue();
    }

    public short calcHeaderLength(DbfTableModel model) {
        int length = 0;
        length += model.getColumnCount() * 32;
        length += 32;
        Integer integer = new Integer(++length);
        return integer.shortValue();
    }

    private void writeHeader(int rowCount, short headerLength, short recordLength) throws IOException {
        this._leos.writeByte(3);
        this._leos.writeByte(96);
        this._leos.writeByte(4);
        this._leos.writeByte(30);
        this._leos.writeLEInt(rowCount);
        this._leos.writeLEShort(headerLength);
        this._leos.writeLEShort(recordLength);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
    }

    private void writeFieldDescriptors(DbfTableModel model) throws IOException {
        int columnCount = model.getColumnCount();
        int i = 0;
        while (i <= columnCount - 1) {
            String name = model.getColumnName(i);
            int length = model.getLength(i);
            byte decimalCount = model.getDecimalCount(i);
            byte type = model.getType(i);
            this.writeFieldDescriptor(name, type, length, decimalCount);
            ++i;
        }
        this._leos.writeByte(13);
    }

    private void writeFieldDescriptor(String name, byte type, int length, byte decimalPlaces) throws IOException {
        this._leos.writeString(name, 11);
        this._leos.writeByte(type);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(length);
        this._leos.writeByte(decimalPlaces);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
    }

    public void writeRecords(DbfTableModel model) throws IOException {
        DecimalFormat df = new DecimalFormat();
        int rowCount = model.getRowCount();
        int columnCount = model.getColumnCount();
        int r = 0;
        while (r <= rowCount - 1) {
            this._leos.writeByte(32);
            int c = 0;
            while (c <= columnCount - 1) {
                Object obj;
                byte type = model.getType(c);
                String value = null;
                value = type == 78 ? ((obj = model.getValueAt(r, c)) instanceof Double ? "" + df.format((Double)obj) : "") : (String)model.getValueAt(r, c);
                int length = model.getLength(c);
                this._leos.writeString(value, length);
                ++c;
            }
            ++r;
        }
    }

    public void close() throws IOException {
        this._leos.writeByte(26);
        this._leos.flush();
        this._leos.close();
    }
}

