/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.Environment;
import com.bbn.openmap.InformationDelegator;
import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.MapHandlerChild;
import com.bbn.openmap.MultipleSoloMapComponentException;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.SoloMapComponent;
import com.bbn.openmap.event.ProgressListener;
import com.bbn.openmap.event.ProgressSupport;
import com.bbn.openmap.gui.ProgressListenerGauge;
import com.bbn.openmap.plugin.PlugIn;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjectionFactory;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class PropertyHandler
extends MapHandlerChild
implements SoloMapComponent {
    public static final String propsFileName = "openmap.properties";
    public static final String configDirProperty = "openmap.configDir";
    public static final String componentProperty = "openmap.components";
    public static final String includeProperty = "openmap.include";
    public static final String localizedProperty = "openmap.localized";
    protected Properties properties = new Properties();
    protected Set usedPrefixes = Collections.synchronizedSet(new HashSet());
    protected ProgressSupport progressSupport;
    protected boolean updateProgress = false;
    protected Hashtable prefixLibrarian = new Hashtable();
    protected boolean DEBUG = Debug.debugging("properties");

    public PropertyHandler() {
        this(false);
    }

    public PropertyHandler(boolean provideProgressUpdates) {
        this.updateProgress = provideProgressUpdates;
        this.searchForAndLoadProperties();
    }

    public PropertyHandler(String urlString) throws MalformedURLException, IOException {
        this(PropUtils.getResourceOrFileOrURL(urlString));
    }

    public PropertyHandler(URL url) throws IOException {
        InputStream is = null;
        if (url != null) {
            is = url.openStream();
        }
        Properties tmpProperties = new Properties();
        if (is != null) {
            tmpProperties.load(is);
        }
        this.init(tmpProperties, "URL");
        Environment.init(this.getProperties());
    }

    public PropertyHandler(Properties props) {
        this.init(props, null);
        Environment.init(this.getProperties());
    }

    protected void searchForAndLoadProperties() {
        Properties systemProperties;
        InputStream propsIn;
        Properties tmpProperties = new Properties();
        boolean foundProperties = false;
        boolean showDebugMessages = false;
        if (Debug.debugging("locale")) {
            Locale.setDefault(new Locale("pl", "PL"));
        }
        if (this.DEBUG) {
            showDebugMessages = true;
        }
        if (Debug.debugging("showprogress")) {
            this.updateProgress = true;
        }
        if (showDebugMessages) {
            Debug.output("***** Searching for properties ****");
        }
        if (showDebugMessages) {
            Debug.output("PropertyHandler: Looking for openmap.properties in Resources");
        }
        if ((propsIn = this.getClass().getResourceAsStream(propsFileName)) == null && Environment.isApplet()) {
            URL[] cba = new URL[]{Environment.getApplet().getCodeBase()};
            URLClassLoader ucl = URLClassLoader.newInstance(cba);
            propsIn = ucl.getResourceAsStream(propsFileName);
        }
        if (propsIn == null) {
            propsIn = ClassLoader.getSystemResourceAsStream(propsFileName);
            if (propsIn != null && showDebugMessages) {
                Debug.output("Loading properties from System Resources: openmap.properties");
            }
        } else if (showDebugMessages) {
            Debug.output("Loading properties from file openmap.properties from package of class " + this.getClass());
        }
        if (propsIn != null) {
            foundProperties = PropUtils.loadProperties(tmpProperties, propsIn);
            this.init(tmpProperties, "resources");
            tmpProperties.clear();
        }
        if (!foundProperties && (Environment.isApplet() || showDebugMessages)) {
            Debug.output("PropertyHandler: Unable to locate as resource: openmap.properties");
        }
        if (Environment.isApplet()) {
            Environment.init(this.getProperties());
            return;
        }
        try {
            systemProperties = System.getProperties();
        }
        catch (AccessControlException ace) {
            systemProperties = new Properties();
        }
        String openmapConfigDirectory = systemProperties.getProperty(configDirProperty);
        if (openmapConfigDirectory == null) {
            Vector cps = Environment.getClasspathDirs();
            String defaultExtraDir = "share";
            int searchCount = 0;
            while (searchCount < cps.size()) {
                File shareDir = new File((String)cps.elementAt(searchCount), defaultExtraDir);
                if (shareDir.exists()) {
                    openmapConfigDirectory = shareDir.getPath();
                    break;
                }
                ++searchCount;
            }
        }
        Environment.addPathToClasspaths(openmapConfigDirectory);
        if (showDebugMessages) {
            Debug.output("PropertyHandler: Looking for openmap.properties in configuration directory: " + (openmapConfigDirectory == null ? "not set" : openmapConfigDirectory));
        }
        foundProperties |= PropUtils.loadProperties(tmpProperties, openmapConfigDirectory, propsFileName);
        Properties includeProperties = this.getIncludeProperties(tmpProperties.getProperty(includeProperty), tmpProperties);
        this.merge(includeProperties, "include file properties", openmapConfigDirectory);
        this.merge(tmpProperties, propsFileName, openmapConfigDirectory);
        tmpProperties.clear();
        this.merge(systemProperties, "system properties", "system");
        String userHomeDirectory = systemProperties.getProperty("user.home");
        if (showDebugMessages) {
            Debug.output("PropertyHandler: Looking for openmap.properties in user's home directory: " + userHomeDirectory);
        }
        foundProperties |= PropUtils.loadProperties(tmpProperties, userHomeDirectory, propsFileName);
        if (showDebugMessages) {
            Debug.output("***** Done with property search ****");
        }
        if (!foundProperties && !Environment.isApplet()) {
            PropUtils.copyProperties(PropUtils.promptUserForProperties(), this.properties);
        }
        includeProperties = this.getIncludeProperties(tmpProperties.getProperty(includeProperty), tmpProperties);
        this.merge(includeProperties, "include file properties", userHomeDirectory);
        this.merge(tmpProperties, propsFileName, userHomeDirectory);
        Properties localizedProperties = this.getLocalizedProperties(tmpProperties.getProperty(localizedProperty), userHomeDirectory);
        this.merge(localizedProperties, "localized properties", null);
        Environment.init(this.getProperties());
    }

    protected Properties getLocalizedProperties(String localizedPropertyFile, String userHomeDirectory) {
        Properties props = null;
        if (localizedPropertyFile == null) {
            Locale loc = Locale.getDefault();
            localizedPropertyFile = "openmap_" + loc.toString() + ".properties";
        }
        boolean tryHomeDirectory = false;
        if (this.DEBUG) {
            Debug.output("PropertyHandler: Looking for localized file: " + localizedPropertyFile);
        }
        try {
            URL propsURL = PropUtils.getResourceOrFileOrURL(localizedPropertyFile);
            if (propsURL == null) {
                tryHomeDirectory = true;
            } else {
                if (this.DEBUG) {
                    Debug.output("Found localized properties in classpath");
                }
                props = PropertyHandler.fetchProperties(propsURL);
            }
        }
        catch (MalformedURLException murle) {
            Debug.error("PropertyHandler can't find localized property file: " + localizedPropertyFile);
            tryHomeDirectory = true;
        }
        if (tryHomeDirectory) {
            props = new Properties();
            if (!PropUtils.loadProperties(props, userHomeDirectory, localizedPropertyFile)) {
                props = null;
            } else if (this.DEBUG) {
                Debug.output("Found localized properties in home directory");
            }
        }
        if (props == null) {
            props = new Properties();
        }
        return props;
    }

    protected void init(Properties props, String howString) {
        Properties includeProperties = this.getIncludeProperties(props.getProperty(includeProperty), props);
        this.merge(includeProperties, "include file properties", howString);
        if (!Environment.isApplet()) {
            Properties systemProperties = System.getProperties();
            this.merge(systemProperties, props);
        }
        this.merge(props, "loaded", howString);
        if (this.DEBUG) {
            Debug.output("PropertyHandler: loaded properties");
        }
    }

    protected Properties getIncludeProperties(String markerList, Properties props) {
        Properties newProps = new Properties();
        Properties tmpProps = new Properties();
        Vector includes = PropUtils.parseSpacedMarkers(markerList);
        int size = includes.size();
        if (size > 0) {
            if (Debug.debugging("propertiesdetail")) {
                Debug.output("PropertyHandler: handling include files: " + includes);
            }
            int i = 0;
            while (i < size) {
                String includeName = (String)includes.elementAt(i);
                String includeProperty = includeName + ".URL";
                String include = props.getProperty(includeProperty);
                if (include == null) {
                    Debug.error("PropertyHandler.getIncludeProperties(): Failed to locate include file \"" + includeName + "\" with URL \"" + includeProperty + "\"\n  Skipping include file \"" + include + "\"");
                } else {
                    try {
                        tmpProps.clear();
                        URL tmpInclude = PropUtils.getResourceOrFileOrURL(null, include);
                        if (tmpInclude != null) {
                            InputStream is = tmpInclude.openStream();
                            tmpProps.load(is);
                            if (this.DEBUG) {
                                Debug.output("PropertyHandler.getIncludeProperties(): located include properties file URL: " + include);
                            }
                            Properties includeProperties = this.getIncludeProperties(tmpProps.getProperty(includeProperty), tmpProps);
                            this.merge(includeProperties, newProps, "include file properties", "within " + include);
                            this.merge(tmpProps, newProps, "include file properties", include);
                        }
                    }
                    catch (MalformedURLException e) {
                        Debug.error("PropertyHandler: malformed URL for include file: |" + include + "| for " + includeName);
                    }
                    catch (IOException ioe) {
                        Debug.error("PropertyHandler: IOException processing " + include + "| for " + includeName);
                    }
                }
                ++i;
            }
        } else {
            Debug.message("properties", "PropertyHandler.getIncludeProperties(): no include files found.");
        }
        return newProps;
    }

    protected void merge(Properties from) {
        this.merge(from, this.getProperties(), null, null);
    }

    protected void merge(Properties from, Properties to) {
        this.merge(from, to, null, null);
    }

    protected void merge(Properties from, String what, String where) {
        this.merge(from, this.getProperties(), what, where);
    }

    protected void merge(Properties from, Properties to, String what, String where) {
        if (from.size() > 0) {
            if (to == null) {
                to = this.getProperties();
            }
            PropUtils.copyProperties(from, to);
        } else if (what != null && this.DEBUG) {
            Debug.output("PropertyHandler.merge(): no " + what + " found" + (where == null ? "." : " in " + where));
        }
    }

    public void setProperties(Properties props) {
        this.init(props, null);
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public Object get(String markername) {
        return this.prefixLibrarian.get(markername.intern());
    }

    public Properties getProperties(String prefix) {
        Properties prefixProperties = new Properties();
        Properties props = this.getProperties();
        if (prefix != null) {
            String scopedPrefix = prefix + ".";
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith(scopedPrefix)) continue;
                prefixProperties.put(key, props.get(key));
            }
        }
        return prefixProperties;
    }

    public void put(String markername, Object obj) {
        this.prefixLibrarian.put(markername.intern(), obj);
    }

    public Object remove(String markername) {
        return this.prefixLibrarian.remove(markername);
    }

    public Hashtable getPrefixLibrarian() {
        return this.prefixLibrarian;
    }

    public void createComponents(MapHandler mapHandler) {
        ProgressListenerGauge plg;
        if (mapHandler == null) {
            Debug.message("properties", "PropertyHandler.createComponents(): null handler.");
            return;
        }
        try {
            plg = new ProgressListenerGauge("OpenMap Setup");
            this.addProgressListener(plg);
        }
        catch (Exception e) {
            plg = null;
        }
        Vector debugList = PropUtils.parseSpacedMarkers(this.properties.getProperty("openmap.Debug"));
        int size = debugList.size();
        int i = 0;
        while (i < size) {
            String debugMarker = (String)debugList.elementAt(i);
            Debug.put(debugMarker);
            if (this.DEBUG) {
                Debug.output("PropertyHandler: adding " + debugMarker + " to Debug list.");
            }
            ++i;
        }
        Vector componentList = PropUtils.parseSpacedMarkers(this.properties.getProperty(componentProperty));
        if (Debug.debugging("propertiesdetail")) {
            Debug.output("PropertyHandler: creating components from " + componentList);
        }
        this.fireProgressUpdate(0, "OpenMap - Creating Components", 0, 100);
        Vector components = ComponentFactory.create(componentList, this.properties, this.updateProgress ? this.getProgressSupport() : null, true);
        size = components.size();
        i = 0;
        while (i < size) {
            Object obj = components.elementAt(i);
            try {
                if (obj instanceof String) {
                    Debug.error("PropertyHandler finding out that the " + obj + " wasn't created");
                } else {
                    mapHandler.add(obj);
                    String markerName = ((String)componentList.elementAt(i)).intern();
                    this.prefixLibrarian.put(markerName, obj);
                    this.addUsedPrefix(markerName);
                }
            }
            catch (MultipleSoloMapComponentException msmce) {
                Debug.error("PropertyHandler.createComponents(): tried to add multiple components of the same type when only one is allowed! - " + msmce);
            }
            ++i;
        }
        this.fireProgressUpdate(2, "Created all components, ready...", size, size);
        this.removeProgressListener(plg);
    }

    public static Properties createOpenMapProperties(MapHandler mapHandler, PrintStream ps) {
        Properties createdProperties = new Properties();
        if (mapHandler == null) {
            Debug.error("PropertyHandler.createOpenMapProperties: can't create properties with null MapHandler");
            return null;
        }
        Iterator<Object> it = mapHandler.iterator();
        Debug.message("properties", "PropertyHandler: Looking for Objects in mapHandler");
        MapBean mapBean = null;
        LayerHandler layerHandler = null;
        PropertyHandler propertyHandler = null;
        InformationDelegator infoDelegator = null;
        Vector<Object> otherComponents = new Vector<Object>();
        while (it.hasNext()) {
            Object someObj = it.next();
            Debug.message("properties", "PropertyHandler found " + someObj.getClass().getName());
            if (someObj instanceof MapBean) {
                mapBean = (MapBean)someObj;
                continue;
            }
            if (someObj instanceof LayerHandler) {
                layerHandler = (LayerHandler)someObj;
                continue;
            }
            if (someObj instanceof Layer || someObj instanceof PlugIn) continue;
            if (someObj instanceof PropertyHandler) {
                propertyHandler = (PropertyHandler)someObj;
                if (infoDelegator == null) continue;
                propertyHandler.addProgressListener(infoDelegator);
                continue;
            }
            if (someObj instanceof InformationDelegator) {
                infoDelegator = (InformationDelegator)someObj;
                if (propertyHandler == null) continue;
                propertyHandler.addProgressListener((ProgressListener)someObj);
                continue;
            }
            otherComponents.add(someObj);
        }
        if (mapBean == null || layerHandler == null) {
            Debug.error("PropertyHandler: no MapBean(" + mapBean + ") or LayerHandler(" + layerHandler + ") to use to write properties");
            return null;
        }
        ps.println("######  OpenMap properties file ######");
        ps.println("## Refer to original openmap.properties file\n## for instructions on how to modify this file.");
        ps.println("######################################");
        PropertyHandler.printMapProperties(mapBean, ps, createdProperties);
        PropertyHandler.printComponentProperties(otherComponents, propertyHandler, ps, createdProperties);
        PropertyHandler.printLayerProperties(layerHandler, propertyHandler, ps, createdProperties);
        if (Debug.debugging("properties") && createdProperties != null) {
            System.out.println(createdProperties);
        }
        return createdProperties;
    }

    protected static void printProperties(String key, String value, PrintStream ps, Properties createdProperties) {
        if (ps != null) {
            ps.println(key + "=" + value);
        }
        if (createdProperties != null) {
            createdProperties.put(key, value);
        }
    }

    protected static void printMapProperties(MapBean mapBean, PrintStream ps, Properties createdProperties) {
        Proj proj = mapBean.projection;
        ps.println("\n### OpenMap initial Map Settings ###");
        LatLonPoint llp = proj.getCenter();
        PropertyHandler.printProperties("openmap.Latitude", Float.toString(llp.getLatitude()), ps, createdProperties);
        PropertyHandler.printProperties("openmap.Longitude", Float.toString(llp.getLongitude()), ps, createdProperties);
        PropertyHandler.printProperties("openmap.Scale", Float.toString(proj.getScale()), ps, createdProperties);
        PropertyHandler.printProperties("openmap.Projection", proj.getName(), ps, createdProperties);
        PropertyHandler.printProperties("openmap.BackgroundColor", Integer.toHexString(mapBean.getBackground().getRGB()), ps, createdProperties);
    }

    protected static void printComponentProperties(Vector components, PropertyHandler ph, PrintStream ps, Properties createdProperties) {
        boolean buildConfiguredApplication = true;
        boolean componentListBuilt = false;
        int numComponents = 0;
        StringBuffer componentMarkerString = new StringBuffer("openmap.components=");
        StringBuffer componentPropsString = new StringBuffer();
        if (ph != null && buildConfiguredApplication) {
            Properties phProps = ph.getProperties();
            componentMarkerString.append(phProps.getProperty(componentProperty));
            Vector componentList = PropUtils.parseSpacedMarkers(phProps.getProperty(componentProperty));
            int i = 0;
            while (i < componentList.size()) {
                String markerNameClass = (String)componentList.elementAt(i) + ".class";
                componentPropsString.append(markerNameClass + "=" + phProps.get(markerNameClass) + "\n");
                if (createdProperties != null) {
                    createdProperties.put(markerNameClass, phProps.get(markerNameClass));
                }
                ++i;
            }
            componentListBuilt = true;
        }
        Properties componentProperties = new Properties();
        Enumeration comps = components.elements();
        while (comps.hasMoreElements()) {
            String markerName;
            Object someObj = comps.nextElement();
            if (someObj instanceof PropertyConsumer) {
                Debug.message("properties", "Getting Property Info for" + someObj.getClass().getName());
                PropertyConsumer pc = (PropertyConsumer)someObj;
                componentProperties.clear();
                markerName = pc.getPropertyPrefix();
                if (ph != null && markerName != null && !markerName.equals("openmap")) {
                    componentProperties = ph.getProperties(markerName);
                } else {
                    componentProperties.clear();
                }
                if (!componentListBuilt) {
                    if (markerName != null) {
                        componentMarkerString.append(" " + markerName);
                    } else {
                        markerName = "component" + numComponents++;
                        componentMarkerString.append(" " + markerName);
                        pc.setPropertyPrefix(markerName);
                    }
                    componentPropsString.append(markerName + ".class=" + someObj.getClass().getName() + "\n");
                    if (createdProperties != null) {
                        createdProperties.put(markerName, someObj.getClass().getName());
                    }
                }
                pc.getProperties(componentProperties);
                TreeMap<Object, Object> orderedProperties = new TreeMap<Object, Object>(componentProperties);
                if (componentProperties.size() <= 0) continue;
                componentPropsString.append("####\n");
                Iterator<Object> keys = orderedProperties.keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String value = componentProperties.getProperty(key);
                    if (value != null) {
                        componentPropsString.append(key + "=" + value + "\n");
                    }
                    if (createdProperties == null || value == null) continue;
                    createdProperties.put(key, value);
                }
                continue;
            }
            if (componentListBuilt) continue;
            markerName = "component" + numComponents++;
            componentMarkerString.append(" " + markerName);
            componentPropsString.append(markerName + ".class=" + someObj.getClass().getName() + "\n");
            if (createdProperties == null) continue;
            createdProperties.put(markerName, someObj.getClass().getName());
        }
        if (ps != null) {
            ps.println("\n\n### OpenMap Components ###");
            ps.println(componentMarkerString.toString());
            ps.println("\n### OpenMap Component Properties ###");
            ps.println(componentPropsString.toString());
            ps.println("### End Component Properties ###");
        }
        if (createdProperties != null) {
            createdProperties.put(componentProperty, componentMarkerString.substring(componentProperty.length() + 1));
        }
    }

    protected static void printLayerProperties(LayerHandler layerHandler, PropertyHandler ph, PrintStream ps, Properties createdProperties) {
        String layerMarkerStringKey = "openmap.layers";
        StringBuffer layerMarkerString = new StringBuffer(layerMarkerStringKey + "=");
        String startUpLayerMarkerStringKey = "openmap.startUpLayers";
        StringBuffer startUpLayerMarkerString = new StringBuffer(startUpLayerMarkerStringKey + "=");
        StringBuffer layerPropertiesString = new StringBuffer();
        Properties layerProperties = new Properties();
        Layer[] layers = layerHandler.getLayers();
        int numLayers = 0;
        int i = 0;
        while (i < layers.length) {
            String markerName = layers[i].getPropertyPrefix();
            if (markerName == null) {
                markerName = "layer" + numLayers++;
                layers[i].setPropertyPrefix(markerName);
            }
            if (ph != null) {
                layerProperties = ph.getProperties(markerName);
            } else {
                layerProperties.clear();
            }
            layerMarkerString.append(" " + markerName);
            if (layers[i].isVisible()) {
                startUpLayerMarkerString.append(" " + markerName);
            }
            layers[i].getProperties(layerProperties);
            layerPropertiesString.append("### -" + markerName + "- layer properties\n");
            TreeMap<Object, Object> orderedProperties = new TreeMap<Object, Object>(layerProperties);
            Iterator<Object> keys = orderedProperties.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = layerProperties.getProperty(key);
                if (value != null) {
                    layerPropertiesString.append(key + "=" + value + "\n");
                }
                if (createdProperties == null || value == null) continue;
                createdProperties.put(key, value);
            }
            layerPropertiesString.append("### end of -" + markerName + "- properties\n\n");
            ++i;
        }
        if (ps != null) {
            ps.println("\n### OpenMap Layers ###");
            ps.println(layerMarkerString.toString());
            ps.println(startUpLayerMarkerString.toString());
            ps.println(layerPropertiesString.toString());
        }
        if (createdProperties != null) {
            createdProperties.put(layerMarkerStringKey, layerMarkerString.substring(layerMarkerStringKey.length() + 1));
            createdProperties.put(startUpLayerMarkerStringKey, startUpLayerMarkerString.substring(startUpLayerMarkerStringKey.length() + 1));
        }
    }

    public void loadProjectionAndLayers(MapHandler mapHandler, Properties props) {
        MapBean mapBean = (MapBean)mapHandler.get("com.bbn.openmap.MapBean");
        LayerHandler layerHandler = (LayerHandler)mapHandler.get("com.bbn.openmap.LayerHandler");
        InformationDelegator id = (InformationDelegator)mapHandler.get("com.bbn.openmap.InformationDelegator");
        if (layerHandler != null) {
            layerHandler.removeAll();
            layerHandler.init("openmap", props);
        } else {
            Debug.error("Can't load new layers - can't find LayerHandler");
        }
        if (mapBean != null) {
            mapBean.setProjection(ProjectionFactory.getDefaultProjectionFromEnvironment(mapBean.getWidth(), mapBean.getHeight()));
        } else {
            Debug.error("Can't load new projection - can't find MapBean");
        }
    }

    public String getUniquePrefix(String prefix) {
        if (!this.addUsedPrefix(prefix = prefix.replace(' ', '_'))) {
            int count = 2;
            String nextTry = prefix + count;
            while (!this.addUsedPrefix(nextTry)) {
                nextTry = prefix + ++count;
            }
            return nextTry;
        }
        return prefix;
    }

    public boolean addUsedPrefix(String prefix) {
        prefix = prefix.replace(' ', '_');
        return this.usedPrefixes.add(prefix.intern());
    }

    public boolean removeUsedPrefix(String prefix) {
        prefix = prefix.replace(' ', '_');
        return this.usedPrefixes.remove(prefix.intern());
    }

    public void addProgressListener(ProgressListener list) {
        this.getProgressSupport().addProgressListener(list);
    }

    public void removeProgressListener(ProgressListener list) {
        this.getProgressSupport().removeProgressListener(list);
    }

    public void clearProgressListeners() {
        this.getProgressSupport().removeAll();
    }

    protected ProgressSupport getProgressSupport() {
        if (this.progressSupport == null) {
            this.progressSupport = new ProgressSupport(this);
        }
        return this.progressSupport;
    }

    protected void fireProgressUpdate(int type, String task, int frameNumber, int totalFrames) {
        if (this.updateProgress) {
            this.getProgressSupport().fireUpdate(type, task, totalFrames, frameNumber);
        } else if (type == 2) {
            this.getProgressSupport().fireUpdate(2, task, totalFrames, frameNumber);
        }
    }

    public void setUpdateProgress(boolean set) {
        this.updateProgress = set;
    }

    public boolean getUpdateProgress() {
        return this.updateProgress;
    }

    public boolean removeProperty(String property) {
        return this.getProperties().remove(property) != null;
    }

    public void addProperty(String property, String value) {
        this.getProperties().setProperty(property, value);
    }

    public void addProperties(URL urlToProperties) {
        this.addProperties(PropertyHandler.fetchProperties(urlToProperties));
    }

    public void addProperties(String propFile) throws MalformedURLException {
        this.addProperties(PropertyHandler.fetchProperties(PropUtils.getResourceOrFileOrURL(propFile)));
    }

    public void addProperties(Properties p) {
        String[] specialProps = new String[]{"openmap.layers", "openmap.startUpLayers", componentProperty};
        Properties tmp = new Properties();
        tmp.putAll((Map<?, ?>)p);
        int i = 0;
        while (i < specialProps.length) {
            this.prependProperty(specialProps[i], tmp);
            tmp.remove(specialProps[i]);
            ++i;
        }
        this.getProperties().putAll((Map<?, ?>)tmp);
    }

    public void removeMarker(String property, String marker) {
        String propertyString = this.getProperties().getProperty(property, "");
        int idx = propertyString.indexOf(marker);
        if (idx != -1) {
            StringBuffer sb = new StringBuffer(propertyString);
            sb.delete(idx, idx + marker.length());
            this.getProperties().setProperty(property, sb.toString());
        }
    }

    public void appendProperty(String property, Properties src) {
        this.appendProperty(property, src.getProperty(property, ""));
    }

    public void appendProperty(String property, String value) {
        String curVal = this.getProperties().getProperty(property, "");
        this.getProperties().setProperty(property, curVal + " " + value);
    }

    public void prependProperty(String property, Properties src) {
        this.prependProperty(property, src.getProperty(property, ""));
    }

    public void prependProperty(String property, String value) {
        String curVal = this.getProperties().getProperty(property, "");
        this.getProperties().setProperty(property, value + " " + curVal);
    }

    public static Properties fetchProperties(URL propsURL) {
        Properties p;
        block3: {
            if (Debug.debugging("properties")) {
                Debug.output("PropertyHandler.getProperties(" + propsURL + ")");
            }
            p = new Properties();
            if (propsURL == null) break block3;
            try {
                InputStream is = propsURL.openStream();
                p.load(is);
                is.close();
            }
            catch (IOException e) {
                Debug.error("PropertyHandler.getProperties(): Exception reading map properties at " + propsURL + ": " + e);
            }
        }
        return p;
    }

    public void findAndInit(Object obj) {
        String prefix;
        if (obj instanceof PropertyConsumer && (prefix = ((PropertyConsumer)obj).getPropertyPrefix()) != null) {
            this.getPrefixLibrarian().put(prefix, obj);
        }
    }

    public void findAndUndo(Object obj) {
        String prefix;
        if (obj instanceof PropertyConsumer && (prefix = ((PropertyConsumer)obj).getPropertyPrefix()) != null) {
            this.getPrefixLibrarian().remove(prefix);
        }
    }
}

