/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.helpers;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.NanoTimer;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Perf;

public final class Utils {
    private static final NanoTimer nanoTimer;
    private static final String providerProp = "edu.emory.mathcs.backport.java.util.concurrent.NanoTimerProvider";

    private Utils() {
    }

    public static long nanoTime() {
        return nanoTimer.nanoTime();
    }

    public static long awaitNanos(Condition condition, long l) throws InterruptedException {
        if (l <= 0L) {
            return l;
        }
        long l2 = Utils.nanoTime();
        condition.await(l, TimeUnit.NANOSECONDS);
        return l - (Utils.nanoTime() - l2);
    }

    private static long gcd(long l, long l2) {
        while (l2 > 0L) {
            long l3 = l % l2;
            l = l2;
            l2 = l3;
        }
        return l;
    }

    static {
        NanoTimer nanoTimer = null;
        try {
            String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(Utils.providerProp);
                }
            });
            if (string != null) {
                Class<?> clazz = Class.forName(string);
                nanoTimer = (NanoTimer)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            System.err.println("WARNING: unable to load Perf provider; switching to a default");
            exception.printStackTrace();
        }
        if (nanoTimer == null) {
            try {
                nanoTimer = new SunPerfProvider();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (nanoTimer == null) {
            nanoTimer = new MillisProvider();
        }
        Utils.nanoTimer = nanoTimer;
    }

    private static final class MillisProvider
    implements NanoTimer {
        MillisProvider() {
        }

        public long nanoTime() {
            return System.currentTimeMillis() * 1000000L;
        }
    }

    private static final class SunPerfProvider
    implements NanoTimer {
        final Perf perf = (Perf)AccessController.doPrivileged(new PrivilegedAction(this){
            private final /* synthetic */ SunPerfProvider this$0;
            {
                this.this$0 = sunPerfProvider;
            }

            public Object run() {
                return Perf.getPerf();
            }
        });
        final long multiplier;
        final long divisor;

        SunPerfProvider() {
            long l = 1000000000L;
            long l2 = this.perf.highResFrequency();
            long l3 = Utils.gcd(l, l2);
            this.multiplier = l / l3;
            this.divisor = l2 / l3;
        }

        public long nanoTime() {
            long l = this.perf.highResCounter();
            return l / this.divisor * this.multiplier + l % this.divisor * this.multiplier / this.divisor;
        }
    }
}

