/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.xml;

import edu.iris.Fissures.FlinnEngdahlRegion;
import edu.iris.Fissures.FlinnEngdahlType;
import edu.iris.Fissures.model.FlinnEngdahlRegionImpl;
import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLFlinnEngdahlRegion {
    public static void insert(XMLStreamWriter writer, FlinnEngdahlRegion region) throws XMLStreamException {
        if (region == null) {
            XMLUtil.writeTextElement(writer, "type", "SEISMIC_REGION");
            XMLUtil.writeTextElement(writer, "number", "0");
        } else {
            if (region.type.equals(FlinnEngdahlType.SEISMIC_REGION)) {
                XMLUtil.writeTextElement(writer, "type", "SEISMIC_REGION");
            } else {
                XMLUtil.writeTextElement(writer, "type", "GEOGRAPHIC_REGION");
            }
            XMLUtil.writeTextElement(writer, "number", "" + region.number);
        }
    }

    public static void insert(Element element, FlinnEngdahlRegion region) {
        Document doc = element.getOwnerDocument();
        if (region == null) {
            element.appendChild(XMLUtil.createTextElement(doc, "type", "SEISMIC_REGION"));
            element.appendChild(XMLUtil.createTextElement(doc, "number", "0"));
        } else {
            if (region.type.equals(FlinnEngdahlType.SEISMIC_REGION)) {
                element.appendChild(XMLUtil.createTextElement(doc, "type", "SEISMIC_REGION"));
            } else {
                element.appendChild(XMLUtil.createTextElement(doc, "type", "GEOGRAPHIC_REGION"));
            }
            element.appendChild(XMLUtil.createTextElement(doc, "number", "" + region.number));
        }
    }

    public static FlinnEngdahlRegion getRegion(Element base) {
        String type = XMLUtil.getText(XMLUtil.getElement(base, "type"));
        int value = Integer.parseInt(XMLUtil.getText(XMLUtil.getElement(base, "number")));
        FlinnEngdahlRegionImpl flinnEngdahlRegion = null;
        if (type.equals("SEISMIC_REGION")) {
            flinnEngdahlRegion = new FlinnEngdahlRegionImpl(FlinnEngdahlType.SEISMIC_REGION, value);
        } else if (type.equals("GEOGRAPHIC_REGION")) {
            flinnEngdahlRegion = new FlinnEngdahlRegionImpl(FlinnEngdahlType.GEOGRAPHIC_REGION, value);
        }
        return flinnEngdahlRegion;
    }

    public static FlinnEngdahlRegion getRegion(XMLStreamReader parser) throws XMLStreamException {
        XMLUtil.gotoNextStartElement(parser, "type");
        String type = parser.getElementText();
        XMLUtil.gotoNextStartElement(parser, "number");
        int number = Integer.parseInt(parser.getElementText());
        FlinnEngdahlRegionImpl flinnEngdahlRegion = null;
        if (type.equals("SEISMIC_REGION")) {
            flinnEngdahlRegion = new FlinnEngdahlRegionImpl(FlinnEngdahlType.SEISMIC_REGION, number);
        } else if (type.equals("GEOGRAPHIC_REGION")) {
            flinnEngdahlRegion = new FlinnEngdahlRegionImpl(FlinnEngdahlType.GEOGRAPHIC_REGION, number);
        }
        return flinnEngdahlRegion;
    }
}

