/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.xml;

import edu.sc.seis.fissuresUtil.xml.StAXFileWriter;
import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import java.io.File;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLFileAppender {
    private String rootElementLocalName = null;
    private boolean holdOn = false;
    private boolean writeNewLines;
    private StAXFileWriter writer;
    private XMLStreamReader reader;
    private static final Logger logger = LoggerFactory.getLogger(XMLFileAppender.class);

    public XMLFileAppender(File file) throws IOException, XMLStreamException {
        this(file, false);
    }

    public XMLFileAppender(File file, boolean writeNewlines) throws IOException, XMLStreamException {
        logger.debug("creating XMLFileAppender for file " + file);
        this.writer = new StAXFileWriter(file);
        this.reader = XMLUtil.getXMLStreamReader(file);
        this.writeNewLines = writeNewlines;
        this.beforeNextStartElement();
        this.rootElementLocalName = this.reader.getLocalName();
    }

    public void beforeNextStartElement() throws XMLStreamException {
        this.beforeNextStartElement(null);
    }

    public void beforeNextStartElement(String localName) throws XMLStreamException {
        this.translateUntilFound(1, localName, false, false);
    }

    public void afterNextStartElement() throws XMLStreamException {
        this.afterNextStartElement(null);
    }

    public void afterNextStartElement(String localName) throws XMLStreamException {
        this.translateUntilFound(1, localName, false, true);
    }

    public void beforeNextEndElement() throws XMLStreamException {
        this.beforeNextStartElement(null);
    }

    public void beforeNextEndElement(String localName) throws XMLStreamException {
        this.translateUntilFound(2, localName, false, false);
    }

    public void afterNextEndElement() throws XMLStreamException {
        this.afterNextStartElement(null);
    }

    public void afterNextEndElement(String localName) throws XMLStreamException {
        this.translateUntilFound(2, localName, false, true);
    }

    public void finishTranslating() throws XMLStreamException {
        this.afterNextEndElement(this.rootElementLocalName);
    }

    protected void translateUntilFound(int xmlStreamConstant, String localName, boolean includeCurrentEvent, boolean includeDesiredEvent) throws XMLStreamException {
        logger.debug("translateUntilFound(" + xmlStreamConstant + ", " + localName + ", " + includeCurrentEvent + ", " + includeDesiredEvent + ")");
        int event = -1;
        while (this.reader.hasNext()) {
            boolean found;
            event = !this.holdOnToCurrentReaderEvent() ? this.reader.next() : this.getCurrentReaderEvent();
            boolean bl = found = event == xmlStreamConstant && (localName == null || this.reader.getLocalName().equals(localName));
            if (found && !includeDesiredEvent) break;
            XMLUtil.translateAndWrite(this.reader, this.writer.getStreamWriter(), this.writeNewLines);
            if (!found || !includeDesiredEvent) continue;
            break;
        }
        this.holdOn = !includeDesiredEvent;
    }

    private boolean holdOnToCurrentReaderEvent() {
        boolean curHoldOnValue = this.holdOn;
        if (curHoldOnValue) {
            this.holdOn = false;
        }
        return curHoldOnValue;
    }

    public int getCurrentReaderEvent() {
        return this.reader.getEventType();
    }

    public XMLStreamWriter getWriter() {
        return this.writer.getStreamWriter();
    }

    public void abort() throws XMLStreamException, IOException {
        this.writer.abort();
    }

    public void close() throws XMLStreamException, IOException {
        this.close(true);
    }

    public void close(boolean finishTranslating) throws XMLStreamException, IOException {
        if (finishTranslating) {
            this.finishTranslating();
        }
        this.writer.close();
    }
}

