/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.stationxml;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.Clock;
import edu.iris.Fissures.IfNetwork.CoefficientErrored;
import edu.iris.Fissures.IfNetwork.CoefficientFilter;
import edu.iris.Fissures.IfNetwork.ComplexNumberErrored;
import edu.iris.Fissures.IfNetwork.DataAcqSys;
import edu.iris.Fissures.IfNetwork.Decimation;
import edu.iris.Fissures.IfNetwork.Filter;
import edu.iris.Fissures.IfNetwork.Gain;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.Normalization;
import edu.iris.Fissures.IfNetwork.PoleZeroFilter;
import edu.iris.Fissures.IfNetwork.RecordingStyle;
import edu.iris.Fissures.IfNetwork.Response;
import edu.iris.Fissures.IfNetwork.Sensitivity;
import edu.iris.Fissures.IfNetwork.Sensor;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.SiteId;
import edu.iris.Fissures.IfNetwork.Stage;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.IfNetwork.TransferType;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.LocationType;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.ClockImpl;
import edu.iris.Fissures.network.DataAcqSysImpl;
import edu.iris.Fissures.network.InstrumentationImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.SensorImpl;
import edu.iris.Fissures.network.SiteImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.stationxml.ChannelSensitivityBundle;
import edu.sc.seis.fissuresUtil.stationxml.StationChannelBundle;
import edu.sc.seis.seisFile.stationxml.AbstractResponseType;
import edu.sc.seis.seisFile.stationxml.Coefficients;
import edu.sc.seis.seisFile.stationxml.Epoch;
import edu.sc.seis.seisFile.stationxml.FIR;
import edu.sc.seis.seisFile.stationxml.InstrumentSensitivity;
import edu.sc.seis.seisFile.stationxml.Network;
import edu.sc.seis.seisFile.stationxml.Pole;
import edu.sc.seis.seisFile.stationxml.PoleZero;
import edu.sc.seis.seisFile.stationxml.PolesZeros;
import edu.sc.seis.seisFile.stationxml.ResponseList;
import edu.sc.seis.seisFile.stationxml.Station;
import edu.sc.seis.seisFile.stationxml.StationEpoch;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.Zero;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StationXMLToFissures {
    public static final Filter UNITY_POLE_ZERO = new Filter();
    public static final Filter UNITY_COEFFICENT_FILTER = new Filter();
    public static final String UNKNOWN = "";
    public static final TimeInterval ONE_SECOND;
    private static final Logger logger;

    public static NetworkAttrImpl convert(Network net) {
        return new NetworkAttrImpl(new NetworkId(net.getNetCode(), StationXMLToFissures.convertTime(net.getStartDate())), UNKNOWN, net.getDescription(), UNKNOWN, new TimeRange(StationXMLToFissures.convertTime(net.getStartDate()), StationXMLToFissures.convertTime(net.getEndDate())));
    }

    public static StationImpl convert(StationEpoch xml, NetworkAttrImpl netAttr, String staCode) {
        TimeRange effectiveTime = new TimeRange(new Time(xml.getStartDate(), -1), new Time(xml.getEndDate(), -1));
        String name = xml.getSite().getName();
        if (name == null) {
            name = (xml.getSite().getTown() != null ? xml.getSite().getTown() + " " : UNKNOWN) + (xml.getSite().getState() != null ? xml.getSite().getState() + " " : UNKNOWN) + (xml.getSite().getCountry() != null ? xml.getSite().getCountry() : UNKNOWN);
            name = name.trim();
        }
        if (UNKNOWN.equals(name)) {
            name = xml.getSite().getDescription();
        }
        if (null == name || UNKNOWN.equals(name)) {
            name = UNKNOWN;
        }
        return new StationImpl(new StationId(netAttr.getId(), staCode, effectiveTime.start_time), name, new Location(xml.getLat(), xml.getLon(), (Quantity)new QuantityImpl((double)xml.getElevation(), (Unit)UnitImpl.METER), (Quantity)new QuantityImpl(0.0, (Unit)UnitImpl.METER), LocationType.GEOGRAPHIC), effectiveTime, UNKNOWN, UNKNOWN, UNKNOWN, (NetworkAttr)netAttr);
    }

    public static List<StationImpl> convert(Station xml) throws StationXMLException {
        StationEpoch firstEpoch = (StationEpoch)xml.getStationEpochs().get(0);
        MicroSecondDate staBegin = new MicroSecondDate(firstEpoch.getStartDate());
        NetworkAttrImpl attr = new NetworkAttrImpl(new NetworkId(xml.getNetCode(), staBegin.getFissuresTime()), UNKNOWN, UNKNOWN, UNKNOWN);
        ArrayList<NetworkAttrImpl> nets = new ArrayList<NetworkAttrImpl>();
        nets.add(attr);
        List<StationChannelBundle> bundles = StationXMLToFissures.convert(xml, nets, false);
        ArrayList<StationImpl> out = new ArrayList<StationImpl>();
        for (StationChannelBundle b : bundles) {
            out.add(b.getStation());
        }
        return out;
    }

    public static List<StationChannelBundle> convert(Station xml, List<NetworkAttrImpl> knownNets, boolean extractChannels) throws StationXMLException {
        NetworkAttrImpl attr = null;
        for (NetworkAttrImpl net : knownNets) {
            MicroSecondDate netBegin;
            if (!xml.getNetCode().equals(net.get_code())) continue;
            if (!NetworkIdUtil.isTemporary((NetworkId)net.get_id())) {
                attr = net;
                break;
            }
            StationEpoch firstEpoch = (StationEpoch)xml.getStationEpochs().get(0);
            MicroSecondDate staBegin = new MicroSecondDate(firstEpoch.getStartDate());
            if (!staBegin.after((Date)(netBegin = new MicroSecondDate(net.getBeginTime()))) || !staBegin.before((Date)netBegin.add(new TimeInterval(2.0, UnitImpl.GREGORIAN_YEAR)))) continue;
            attr = net;
            break;
        }
        if (attr == null) {
            throw new StationXMLException("Can't find network for " + xml.getNetCode());
        }
        return StationXMLToFissures.convert(xml, attr, extractChannels);
    }

    public static List<StationChannelBundle> convert(Station xml, Network net, boolean extractChannels) throws StationXMLException {
        return StationXMLToFissures.convert(xml, StationXMLToFissures.convert(net), extractChannels);
    }

    public static List<StationChannelBundle> convert(Station xml, NetworkAttrImpl attr, boolean extractChannels) throws StationXMLException {
        ArrayList<StationChannelBundle> out = new ArrayList<StationChannelBundle>();
        for (StationEpoch staEpoch : xml.getStationEpochs()) {
            StationImpl sta = StationXMLToFissures.convert(staEpoch, attr, xml.getStaCode());
            StationChannelBundle bundle = new StationChannelBundle(sta);
            out.add(bundle);
            if (!extractChannels) continue;
            for (edu.sc.seis.seisFile.stationxml.Channel xmlChan : staEpoch.getChannelList()) {
                List<ChannelSensitivityBundle> chans = StationXMLToFissures.convert(xmlChan, sta);
                bundle.getChanList().addAll(chans);
                if (chans.get(0).getChan().getStationImpl().getNetworkAttrImpl().get_code().equals(xml.getNetCode()) && chans.get(0).getChan().getStationImpl().get_code().equals(xml.getStaCode())) continue;
                throw new StationXMLException("Chan doesn't match station or net: " + ChannelIdUtil.toStringNoDates((Channel)chans.get(0).getChan()) + "  " + xml.getNetCode() + "." + xml.getStaCode() + "  attr:" + NetworkIdUtil.toStringNoDates((NetworkAttr)attr));
            }
        }
        return out;
    }

    public static ChannelSensitivityBundle convertChannel(Epoch chanEpoch, edu.sc.seis.seisFile.stationxml.Channel parentChannel, StationImpl station) {
        SamplingImpl samp = Math.abs((float)Math.round(chanEpoch.getSampleRate()) - chanEpoch.getSampleRate()) < 1.0E-4f ? new SamplingImpl(Math.round(chanEpoch.getSampleRate()), ONE_SECOND) : new SamplingImpl(1, new TimeInterval((double)(1.0f / chanEpoch.getSampleRate()), UnitImpl.SECOND));
        TimeRange chanTimeRange = new TimeRange(StationXMLToFissures.convertTime(chanEpoch.getStartDate()), StationXMLToFissures.convertTime(chanEpoch.getEndDate()));
        ChannelImpl chan = new ChannelImpl(new ChannelId(station.getId().network_id, station.get_code(), parentChannel.getLocCode(), parentChannel.getChanCode(), StationXMLToFissures.convertTime(chanEpoch.getStartDate())), UNKNOWN, new Orientation(chanEpoch.getAzimuth(), chanEpoch.getDip()), (Sampling)samp, chanTimeRange, (Site)new SiteImpl(new SiteId(station.getId().network_id, station.get_code(), parentChannel.getLocCode(), StationXMLToFissures.convertTime(chanEpoch.getEndDate())), new Location(chanEpoch.getLat(), chanEpoch.getLon(), (Quantity)new QuantityImpl((double)chanEpoch.getElevation(), (Unit)UnitImpl.METER), (Quantity)new QuantityImpl((double)chanEpoch.getDepth(), (Unit)UnitImpl.METER), LocationType.GEOGRAPHIC), chanTimeRange, (edu.iris.Fissures.IfNetwork.Station)station, UNKNOWN));
        QuantityImpl sensitivity = null;
        if (chanEpoch.getInstrumentSensitivity() != null && chanEpoch.getInstrumentSensitivity().getSensitivityUnits().trim().length() != 0) {
            try {
                sensitivity = new QuantityImpl((double)chanEpoch.getInstrumentSensitivity().getSensitivityValue(), (Unit)StationXMLToFissures.convertUnit(chanEpoch.getInstrumentSensitivity().getSensitivityUnits()));
            }
            catch (StationXMLException e) {
                logger.warn("Unable to extract unit: " + ChannelIdUtil.toStringFormatDates((ChannelId)chan.getId()), (Throwable)e);
            }
        } else {
            logger.warn("No sensitivity for " + ChannelIdUtil.toStringFormatDates((ChannelId)chan.getId()));
        }
        return new ChannelSensitivityBundle(chan, sensitivity);
    }

    public static List<ChannelSensitivityBundle> convert(edu.sc.seis.seisFile.stationxml.Channel xml, StationImpl station) throws StationXMLException {
        ArrayList<ChannelSensitivityBundle> out = new ArrayList<ChannelSensitivityBundle>();
        for (Epoch chanEpoch : xml.getChanEpochList()) {
            out.add(StationXMLToFissures.convertChannel(chanEpoch, xml, station));
        }
        return out;
    }

    public static InstrumentationImpl convertInstrumentation(Epoch xmlChan) throws StationXMLException {
        ClockImpl clock = new ClockImpl(0, "unknown", "unknown", "unknown", "unknown");
        SensorImpl sensor = new SensorImpl(0, "unknown", "unknown", "unknown", 0.0f, 0.0f);
        if (xmlChan.getSensor() != null) {
            sensor = new SensorImpl(0, StationXMLToFissures.makeNoNull(xmlChan.getSensor().getManufacturer()), StationXMLToFissures.makeNoNull(xmlChan.getSensor().getSerialNumber()), StationXMLToFissures.makeNoNull(xmlChan.getSensor().getModel()), 0.0f, 0.0f);
        }
        DataAcqSysImpl dataLogger = new DataAcqSysImpl(0, "unknown", "unknown", "unknown", RecordingStyle.UNKNOWN);
        if (xmlChan.getDataLogger() != null) {
            dataLogger = new DataAcqSysImpl(0, StationXMLToFissures.makeNoNull(xmlChan.getDataLogger().getManufacturer()), StationXMLToFissures.makeNoNull(xmlChan.getDataLogger().getSerialNumber()), StationXMLToFissures.makeNoNull(xmlChan.getDataLogger().getModel()), RecordingStyle.UNKNOWN);
        }
        TimeRange chanTimeRange = new TimeRange(StationXMLToFissures.convertTime(xmlChan.getStartDate()), StationXMLToFissures.convertTime(xmlChan.getEndDate()));
        InstrumentationImpl out = new InstrumentationImpl(StationXMLToFissures.convert(xmlChan.getResponseList(), xmlChan.getInstrumentSensitivity()), chanTimeRange, (Clock)clock, (Sensor)sensor, (DataAcqSys)dataLogger);
        return out;
    }

    public static Response convert(List<edu.sc.seis.seisFile.stationxml.Response> respList, InstrumentSensitivity overallGain) throws StationXMLException {
        Sensitivity sense = null;
        if (overallGain != null) {
            sense = new Sensitivity(overallGain.getSensitivityValue(), overallGain.getFrequency());
        } else {
            for (edu.sc.seis.seisFile.stationxml.Response response : respList) {
                if (response.getStage() != 0) continue;
                sense = new Sensitivity(response.getStageSensitivity().getSensitivityValue(), response.getStageSensitivity().getFrequency());
                break;
            }
        }
        ArrayList<Stage> stages = new ArrayList<Stage>();
        for (edu.sc.seis.seisFile.stationxml.Response response : respList) {
            Filter[] filt;
            UnitImpl outputUnits;
            UnitImpl inputUnits;
            if (response.getStage() == 0) continue;
            Decimation[] dec = new Decimation[]{};
            if (response.getDecimation() != null) {
                dec = new Decimation[]{StationXMLToFissures.convertDecimation(response.getDecimation())};
            }
            Normalization[] norm = new Normalization[]{};
            if (response.getResponseItem() == null) {
                outputUnits = inputUnits = (UnitImpl)((Stage)stages.get((int)(stages.size() - 1))).output_units;
                filt = response.getDecimation() != null ? new Filter[]{UNITY_COEFFICENT_FILTER} : new Filter[]{UNITY_POLE_ZERO};
            } else {
                filt = new Filter[]{StationXMLToFissures.convertFilter(response.getResponseItem())};
                inputUnits = StationXMLToFissures.convertUnit(response.getResponseItem().getInputUnits());
                outputUnits = StationXMLToFissures.convertUnit(response.getResponseItem().getOutputUnits());
                if (response.getResponseItem() instanceof PolesZeros) {
                    norm = new Normalization[]{StationXMLToFissures.convertNormalization((PolesZeros)response.getResponseItem())};
                }
            }
            stages.add(new Stage(StationXMLToFissures.getTransferType(response), (Unit)inputUnits, (Unit)outputUnits, norm, new Gain(response.getStageSensitivity().getSensitivityValue(), response.getStageSensitivity().getFrequency()), dec, filt));
        }
        return new Response(sense, stages.toArray(new Stage[0]));
    }

    public static Decimation convertDecimation(edu.sc.seis.seisFile.stationxml.Decimation dec) {
        return new Decimation((Sampling)new SamplingImpl(1, new TimeInterval((double)(1.0f / dec.getInputSampleRate()), UnitImpl.SECOND)), dec.getFactor(), dec.getOffset(), (Quantity)new TimeInterval((double)dec.getDelay(), UnitImpl.SECOND), (Quantity)new TimeInterval((double)dec.getCorrection(), UnitImpl.SECOND));
    }

    public static Filter convertFilter(AbstractResponseType resp) throws StationXMLException {
        Filter out = new Filter();
        if (resp instanceof PolesZeros) {
            PolesZeros pz = (PolesZeros)resp;
            ComplexNumberErrored[] poles = new ComplexNumberErrored[pz.getPoleList().size()];
            int i = 0;
            for (Pole p : pz.getPoleList()) {
                poles[i++] = StationXMLToFissures.convertComplex((PoleZero)p);
            }
            ComplexNumberErrored[] zeros = new ComplexNumberErrored[pz.getZeroList().size()];
            i = 0;
            for (Zero p : pz.getZeroList()) {
                zeros[i++] = StationXMLToFissures.convertComplex((PoleZero)p);
            }
            out.pole_zero_filter(new PoleZeroFilter(poles, zeros));
        } else if (resp instanceof Coefficients) {
            Coefficients coef = (Coefficients)resp;
            CoefficientErrored[] num = new CoefficientErrored[coef.getNumeratorList().size()];
            int i = 0;
            for (Float p : coef.getNumeratorList()) {
                num[i++] = new CoefficientErrored(p.floatValue(), 0.0f);
            }
            CoefficientErrored[] denom = new CoefficientErrored[coef.getDenominatorList().size()];
            i = 0;
            for (Float p : coef.getDenominatorList()) {
                denom[i++] = new CoefficientErrored(p.floatValue(), 0.0f);
            }
            out.coeff_filter(new CoefficientFilter(num, denom));
        } else {
            if (resp instanceof ResponseList) {
                throw new StationXMLException("Can only handle PolesZeros or FIR response types. " + resp.getClass());
            }
            throw new StationXMLException("Can only handle PolesZeros or FIR response types. " + resp.getClass());
        }
        return out;
    }

    public static Normalization convertNormalization(PolesZeros poleZero) {
        return new Normalization(poleZero.getNormalizationFactor(), poleZero.getNormalizationFreq());
    }

    public static ComplexNumberErrored convertComplex(PoleZero pz) {
        return new ComplexNumberErrored((float)pz.getReal(), 0.0f, (float)pz.getImaginary(), 0.0f);
    }

    public static TransferType getTransferType(edu.sc.seis.seisFile.stationxml.Response response) throws StationXMLException {
        if (response.getResponseItem() instanceof PolesZeros) {
            return TransferType.ANALOG;
        }
        if (response.getResponseItem() instanceof Coefficients) {
            return TransferType.ANALOG;
        }
        if (response.getResponseItem() instanceof FIR) {
            return TransferType.DIGITAL;
        }
        if (response.getResponseItem() == null) {
            if (response.getDecimation() != null) {
                return TransferType.DIGITAL;
            }
            return TransferType.ANALOG;
        }
        throw new StationXMLException("Can only handle PolesZeros, Coefficients or FIR response types. " + response.getResponseItem().getClass());
    }

    public static UnitImpl convertUnit(String xml) throws StationXMLException {
        String unitString = xml.indexOf(" - ") != -1 ? xml.substring(0, xml.indexOf(" - ")).trim() : xml.trim();
        if (unitString.length() == 0) {
            // empty if block
        }
        if (unitString.equalsIgnoreCase("M")) {
            return UnitImpl.METER;
        }
        if (unitString.equalsIgnoreCase("M/S")) {
            return UnitImpl.METER_PER_SECOND;
        }
        if (unitString.equalsIgnoreCase("NM/S")) {
            return UnitImpl.NANOMETER_PER_SECOND;
        }
        if (unitString.equalsIgnoreCase("M/S/S") || unitString.equalsIgnoreCase("M/S**2")) {
            return UnitImpl.METER_PER_SECOND_PER_SECOND;
        }
        if (unitString.equalsIgnoreCase("V")) {
            return UnitImpl.VOLT;
        }
        if (unitString.equalsIgnoreCase("COUNTS")) {
            return UnitImpl.COUNT;
        }
        try {
            return UnitImpl.getUnitFromString((String)unitString);
        }
        catch (NoSuchFieldException e) {
            throw new StationXMLException("Unknown unit: '" + xml + "'");
        }
    }

    public static Time convertTime(String xml) {
        return new MicroSecondDate(xml).getFissuresTime();
    }

    public static String makeNoNull(String s) {
        if (s == null) {
            return UNKNOWN;
        }
        return s;
    }

    static {
        UNITY_POLE_ZERO.pole_zero_filter(new PoleZeroFilter(new ComplexNumberErrored[]{new ComplexNumberErrored(0.0f, 0.0f, 0.0f, 0.0f)}, new ComplexNumberErrored[]{new ComplexNumberErrored(0.0f, 0.0f, 0.0f, 0.0f)}));
        UNITY_COEFFICENT_FILTER.coeff_filter(new CoefficientFilter(new CoefficientErrored[]{new CoefficientErrored(1.0f, 0.0f)}, new CoefficientErrored[0]));
        ONE_SECOND = new TimeInterval(1.0, UnitImpl.SECOND);
        logger = LoggerFactory.getLogger(StationXMLToFissures.class);
    }
}

