/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.simple;

import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.NetworkAccessHelper;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import edu.sc.seis.fissuresUtil.simple.SimpleNetworkClient;
import edu.sc.seis.fissuresUtil.simple.Tester;
import java.util.Properties;
import org.apache.log4j.BasicConfigurator;
import org.omg.CORBA.Object;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadedNetworkClient
extends SimpleNetworkClient {
    private static Logger logger = LoggerFactory.getLogger(ThreadedNetworkClient.class);

    public ThreadedNetworkClient() {
    }

    public ThreadedNetworkClient(String networkCode, String serverDNS, String serverName) {
        super(networkCode, serverDNS, serverName);
    }

    @Override
    public void exercise() {
        super.exercise();
        try {
            Tester.runAll(this.createRunnables());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public Runnable[] createRunnables() {
        Runnable[] runnables = new Runnable[]{new RetrieveForStation(), new RetrieveStations(), new GetAttributes(), new IORConverter(), new NetworkAccessNarrow(), new RetrieveChannel(), new LocateChannel()};
        return runnables;
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        Initializer.init(args);
        Properties props = Initializer.getProps();
        try {
            ThreadedNetworkClient client = props.containsKey("serverName") && props.containsKey("serverDNS") ? new ThreadedNetworkClient(props.getProperty("netCode", "II"), props.getProperty("serverDNS"), props.getProperty("serverName")) : new ThreadedNetworkClient();
            Tester.runAll(client.createRunnables());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private class LocateChannel
    implements Runnable {
        private LocateChannel() {
        }

        @Override
        public void run() {
            try {
                ThreadedNetworkClient.this.explorer_locate_channels(true);
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.exit(1);
            }
        }

        public String toString() {
            return "explorer_locate_chanels";
        }
    }

    private class RetrieveChannel
    implements Runnable {
        private RetrieveChannel() {
        }

        @Override
        public void run() {
            try {
                ThreadedNetworkClient.this.net.retrieve_channel(ThreadedNetworkClient.this.testChannel.get_id());
            }
            catch (ChannelNotFound e) {
                System.err.println("This channel should always be found");
                e.printStackTrace();
                System.exit(1);
            }
        }

        public String toString() {
            return "retrieve_channel";
        }
    }

    private class RetrieveStations
    implements Runnable {
        private RetrieveStations() {
        }

        @Override
        public void run() {
            ThreadedNetworkClient.this.retrieve_stations(false);
        }

        public String toString() {
            return "retrieve_stations";
        }
    }

    private class IORConverter
    implements Runnable {
        private IORConverter() {
        }

        @Override
        public void run() {
            String ior = Initializer.getORB().object_to_string((Object)ThreadedNetworkClient.this.net);
            Object obj = Initializer.getORB().string_to_object(ior);
            NetworkAccessHelper.narrow((java.lang.Object)obj);
        }

        public String toString() {
            return "IORConverter";
        }
    }

    private class GetAttributes
    implements Runnable {
        private GetAttributes() {
        }

        @Override
        public void run() {
            ThreadedNetworkClient.this.get_attributes(false);
        }

        public String toString() {
            return "get_attributes";
        }
    }

    private class RetrieveForStation
    implements Runnable {
        private RetrieveForStation() {
        }

        @Override
        public void run() {
            ThreadedNetworkClient.this.net.retrieve_for_station(ThreadedNetworkClient.this.testStation.get_id());
        }

        public String toString() {
            return "retrieve_for_station";
        }
    }

    private class NetworkAccessNarrow
    implements Runnable {
        private NetworkAccessNarrow() {
        }

        @Override
        public void run() {
            String ior = Initializer.getORB().object_to_string((Object)ThreadedNetworkClient.this.net);
            Object obj = Initializer.getORB().string_to_object(ior);
            NetworkAccessHelper.narrow((java.lang.Object)obj);
        }

        public String toString() {
            return "NetworkAccess narrow";
        }
    }
}

