/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.sac;

import edu.iris.Fissures.AuditInfo;
import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.sac.SacToFissures;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetToXML;
import edu.sc.seis.fissuresUtil.xml.MemoryDataSet;
import edu.sc.seis.fissuresUtil.xml.MemoryDataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.SeismogramFileTypes;
import edu.sc.seis.fissuresUtil.xml.StdDataSetParamNames;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.varia.NullAppender;
import org.w3c.dom.Element;

public class SacDirToDataSet
implements StdDataSetParamNames {
    String userName = System.getProperty("user.name");
    URL base;
    URL dirURL;
    File directory;
    String dsName;
    DataSet dataset;
    List excludes;
    Map paramRefs;
    static DataSetToXML dataSetToXML = new DataSetToXML();

    public SacDirToDataSet(URL base, File directory, String dsName, List excludes, Map paramRefs) {
        this.base = base;
        this.directory = directory;
        this.dsName = dsName;
        this.excludes = excludes;
        this.paramRefs = paramRefs;
    }

    void process() throws ParserConfigurationException, MalformedURLException, IOException {
        this.dirURL = this.base;
        System.out.println(" dirURL is " + this.dirURL.toString());
        System.out.println(" directory name is " + this.directory.getName());
        this.dirURL = new URL(this.dirURL.toString() + "/" + this.directory.getName() + "/");
        System.out.println("updated dirURL is " + this.dirURL.toString());
        AuditInfo[] audit = new AuditInfo[]{new AuditInfo(this.userName, "Dataset created from SAC files in " + this.directory.getPath())};
        this.dataset = new MemoryDataSet("genid" + Math.round(Math.random() * 2.147483647E9), this.dsName, this.userName, audit);
        Element dsElement = dataSetToXML.createDocument(this.dataset, this.directory, SeismogramFileTypes.SAC);
        for (String key : this.paramRefs.keySet()) {
        }
        File[] files = this.directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            try {
                if (files[i].isDirectory()) continue;
                String filename = files[i].getName();
                System.out.println("Process " + filename);
                if (filename.endsWith(".gif") || filename.endsWith(".GIF") || filename.endsWith(".png") || filename.endsWith(".PNG") || filename.endsWith(".jpeg") || filename.endsWith(".JPEG") || filename.endsWith(".jpg") || filename.endsWith(".JPG")) {
                    String name = filename.substring(0, filename.lastIndexOf(46));
                    this.loadParameterRef(dsElement, filename, filename);
                    continue;
                }
                this.loadSacFile(dsElement, files[i]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Caught exception on " + files[i].getName() + ", continuing...");
            }
        }
        dataSetToXML.save(this.dataset, new File(System.getProperty("user.dir")), SeismogramFileTypes.SAC);
    }

    void loadParameterRef(Element dsElement, String paramName, String paramFile) {
        AuditInfo[] audit = new AuditInfo[]{new AuditInfo(this.userName, "Added parameter " + paramName + " for " + paramFile)};
        Element paramElement = dsElement.getOwnerDocument().createElement("parameter");
        dsElement.appendChild(paramElement);
        dataSetToXML.insertParameter(paramElement, paramName, "http://www.w3.org/TR/xlink/", "xml:xlink", paramName);
    }

    void loadSacFile(Element dsElement, File sacFile) throws IOException, FissuresException {
        String seisName;
        if (this.excludes.contains(sacFile.getName())) {
            return;
        }
        if (this.paramRefs.containsValue(sacFile.getName())) {
            return;
        }
        SacTimeSeries sac = new SacTimeSeries();
        sac.read(sacFile.getCanonicalPath());
        AuditInfo[] audit = new AuditInfo[]{new AuditInfo(this.userName + " via SacDirToDataSet", "seismogram loaded from " + sacFile.getCanonicalPath())};
        URL seisURL = new URL(this.dirURL, sacFile.getName());
        LocalSeismogramImpl seis = SacToFissures.getSeismogram(sac);
        CacheEvent event = SacToFissures.getEvent(sac);
        if (event != null && this.dataset.getParameter("edu.sc.seis.fissuresUtil.xml#EVENT") == null) {
            String eventName = event.get_attributes().name;
            String eName = eventName.replace(' ', '_');
            Element paramElement = dsElement.getOwnerDocument().createElement("parameter");
            dsElement.appendChild(paramElement);
            dataSetToXML.insert(paramElement, "edu.sc.seis.fissuresUtil.xml#EVENT", event);
            AuditInfo[] eventAudit = new AuditInfo[]{new AuditInfo(System.getProperty("user.name"), "event loaded from sac file.")};
            this.dataset.addParameter("edu.sc.seis.fissuresUtil.xml#EVENT", event, eventAudit);
        }
        ChannelImpl channel = SacToFissures.getChannel(sac);
        String channelParamName = "edu.sc.seis.fissuresUtil.xml#CHANNEL_" + ChannelIdUtil.toString((ChannelId)seis.channel_id);
        if (channel != null && this.dataset.getParameter(channelParamName) == null) {
            AuditInfo[] chanAudit = new AuditInfo[]{new AuditInfo(System.getProperty("user.name"), "channel loaded from sac file.")};
            this.dataset.addParameter(channelParamName, channel, chanAudit);
            Element paramElement = dsElement.getOwnerDocument().createElement("parameter");
            dsElement.appendChild(paramElement);
            dataSetToXML.insert(paramElement, channelParamName, channel);
        }
        if ((seisName = sacFile.getName()).endsWith(".SAC")) {
            seisName = seisName.substring(0, seisName.length() - 4);
        }
        MemoryDataSetSeismogram memDSS = new MemoryDataSetSeismogram(seis, this.dataset, seisName);
        AuditInfo[] seisAudit = new AuditInfo[]{new AuditInfo(System.getProperty("user.name"), "seismogram loaded from sac file.")};
        this.dataset.addDataSetSeismogram(memDSS, seisAudit);
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.err.println("Usage: java edu.sc.seis.fissuresUtil.sac.SacDirToDataSet -base url -dir directoryPath -name datasetname [-exclude file] [-paramRef name file]");
            return;
        }
        BasicConfigurator.configure((Appender)new NullAppender());
        String dirName = null;
        URL base = null;
        String baseStr = "";
        String dsName = "default dataset name";
        LinkedList<String> excludes = new LinkedList<String>();
        HashMap<String, String> params = new HashMap<String, String>();
        int i = 0;
        while (i < args.length) {
            System.out.println(i + " " + args[i]);
            if (args[i].equals("-dir")) {
                dirName = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equals("-name")) {
                String tmp = args[i + 1];
                if (tmp.endsWith("/") || tmp.endsWith("\\") || tmp.endsWith(":") || tmp.endsWith(".")) {
                    tmp = tmp.substring(0, tmp.length() - 1);
                }
                if ((tmp = tmp.replace(' ', '_')).length() > 0) {
                    dsName = tmp;
                }
                i += 2;
                continue;
            }
            if (args[i].equals("-base")) {
                baseStr = args[i + 1];
                System.out.println("The baseStr is " + baseStr);
                i += 2;
                continue;
            }
            if (args[i].equals("-exclude")) {
                excludes.add(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equals("-paramRef")) {
                params.put(args[i + 1], args[i + 2]);
                i += 3;
                continue;
            }
            System.out.println("Don't understand " + args[i++]);
        }
        try {
            base = new URL(baseStr);
            System.out.println("base is " + base.toString());
            File f = new File(dirName);
            if (dirName != null) {
                if (!f.exists()) {
                    f.mkdirs();
                }
                if (f.isDirectory()) {
                    SacDirToDataSet sdir = new SacDirToDataSet(base, f, dsName, excludes, params);
                    sdir.process();
                } else {
                    System.err.println("Not a directory: " + args[1]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

