/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130;

import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.SiteId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.LocationType;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.LocationUtil;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.SiteIdUtil;
import edu.iris.Fissures.network.SiteImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.database.seismogram.PopulationProperties;
import edu.sc.seis.fissuresUtil.rt130.DASChannelCreator;
import edu.sc.seis.fissuresUtil.rt130.PropParser;
import edu.sc.seis.fissuresUtil.rt130.RT130FormatError;
import edu.sc.seis.fissuresUtil.rt130.XYReader;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.PropertyConfigurator;

public class NCReader {
    public static final String ORIENTATION_RE = "(default|\\d/-?\\d+/-?\\d+:\\d/-?\\d+/-?\\d+:\\d/-?\\d+/-?\\d+)";
    public static final String INSTRUMENT_RE = "(\\w+/\\d+\\s+\\w+/\\w+\\s+(default|\\d/-?\\d+/-?\\d+:\\d/-?\\d+/-?\\d+:\\d/-?\\d+/-?\\d+))";
    public static final String LOC_RE = "(\\s+LOC: (-?\\d+.\\d+) (-?\\d+.\\d+) (\\d+))?";
    private Map locs;
    private NetworkAttr net;
    private List sites = new ArrayList();
    private List activeSites = new ArrayList();
    private List blockSites = new ArrayList();
    private MicroSecondDate blockStart;
    private UnmatchedGatherer unmatched = new UnmatchedGatherer();
    private String commentRE = "\\s*(#.*)?";
    private LineHandler[] handlers = new LineHandler[]{new StationHandler(), new BlankAndCommentHandler(), new StartBlockHandler(), new REHandler("name\\s+DAS/chan\\s+sensor/model\\s+chan/dip/azi"), new EndBlockHandler(), this.unmatched};
    private Calendar scratchCal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    public static final String NC_FILE_LOC = "NCFile";

    public NCReader(Properties props) throws IOException {
        this((NetworkAttr)PopulationProperties.getNetworkAttr(props), XYReader.create(props));
        PropParser pp = new PropParser(props);
        this.load(new FileInputStream(pp.getPath(NC_FILE_LOC)));
    }

    public NCReader(NetworkAttr net, Map initialLocations) {
        this.net = net;
        this.locs = initialLocations;
    }

    public void load(InputStream input) throws IOException {
        this.load(new InputStreamReader(input));
    }

    public void load(Reader source) throws IOException {
        this.load(new BufferedReader(source));
    }

    public void load(BufferedReader source) throws IOException {
        String line;
        int num = 0;
        block2: while ((line = source.readLine()) != null) {
            ++num;
            for (int i = 0; i < this.handlers.length; ++i) {
                try {
                    if (!this.handlers[i].handle(line)) continue;
                    continue block2;
                }
                catch (FormatException fe) {
                    fe.setLine(line);
                    fe.setLineNum(num);
                    throw fe;
                }
            }
        }
    }

    public List getSites() {
        return this.sites;
    }

    public void dumpSites() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy:DDD:HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        Pattern instrumentationParser = Pattern.compile(INSTRUMENT_RE);
        System.out.println("station_code das_id sensor latitude longitude elevation orientation start_time end_time moved");
        Iterator it = this.sites.iterator();
        MicroSecondDate now = new MicroSecondDate();
        while (it.hasNext()) {
            Site cur = (Site)it.next();
            MicroSecondDate end = new MicroSecondDate(cur.getEndTime());
            String endstr = "ongoing";
            if (!end.after((Date)now)) {
                endstr = df.format((Date)end);
            }
            Location loc = cur.getLocation();
            Matcher m = instrumentationParser.matcher(cur.getComment());
            if (!m.matches()) {
                throw new RT130FormatError(SiteIdUtil.toString((SiteId)cur.get_id()) + " has a malformed instrumentation specification '" + cur.getComment() + "'");
            }
            String orientations = m.group(2);
            System.out.println(cur.getStation().get_code() + " " + DASChannelCreator.getUnitId(cur) + " " + DASChannelCreator.getSensorId(cur) + " " + loc.latitude + " " + loc.longitude + " " + loc.elevation.value + " " + orientations + " " + df.format((Date)new MicroSecondDate(cur.getBeginTime())) + " " + endstr);
        }
    }

    public String getUnitId(MicroSecondDate startTime, String stationCode) {
        for (Site cur : this.sites) {
            if (!cur.getStation().get_code().equals(stationCode) || !new MicroSecondTimeRange(cur.getEffectiveTime()).contains(startTime)) continue;
            return DASChannelCreator.getUnitId(cur);
        }
        throw new IllegalArgumentException("No station of code '" + stationCode + "' operating at " + startTime);
    }

    public int getNumUnhandledLines() {
        return this.unmatched.unhandledLines.size();
    }

    public String getUnhandledLine(int index) {
        return (String)this.unmatched.unhandledLines.get(index);
    }

    public static void main(String[] args) throws IOException {
        Properties props = Initializer.loadProperties(args);
        PropertyConfigurator.configure((Properties)props);
        try {
            new NCReader(props).dumpSites();
        }
        catch (FormatException fe) {
            System.err.println(fe.getMessage());
            System.exit(1);
        }
    }

    public class FormatException
    extends RuntimeException {
        private String line;
        private int lineNum;
        private static final long serialVersionUID = 1L;

        public FormatException(String message) {
            super(message);
        }

        public void setLine(String line) {
            this.line = line;
        }

        public void setLineNum(int lineNum) {
            this.lineNum = lineNum;
        }

        public int getLineNum() {
            return this.lineNum;
        }

        @Override
        public String getMessage() {
            if (this.line != null) {
                return super.getMessage() + "\nLine " + this.lineNum + ": " + this.line;
            }
            return super.getMessage();
        }
    }

    public class StationHandler
    extends REHandler {
        public StationHandler() {
            super("(\\w+)\\s+(\\w+/\\d+\\s+\\w+/\\w+\\s+(default|\\d/-?\\d+/-?\\d+:\\d/-?\\d+/-?\\d+:\\d/-?\\d+/-?\\d+))(\\s+LOC: (-?\\d+.\\d+) (-?\\d+.\\d+) (\\d+))?");
        }

        @Override
        public void operate(Matcher m) {
            if (NCReader.this.blockStart == null) {
                throw new FormatException("Encountered a station line before hitting a 'START' line");
            }
            String code = m.group(1);
            StationId staId = new StationId(NCReader.this.net.get_id(), code, NCReader.this.blockStart.getFissuresTime());
            String instrumentInfo = m.group(2);
            if (!NCReader.this.locs.containsKey(code)) {
                throw new FormatException("There's an entry for station '" + code + "' in the nc file but not in the xy file");
            }
            StationImpl sta = new StationImpl(staId, code, (Location)NCReader.this.locs.get(code), NCReader.this.net.getOwner(), "", "", NCReader.this.net);
            SiteId siteId = new SiteId(NCReader.this.net.get_id(), code, "00", NCReader.this.blockStart.getFissuresTime());
            String lat = m.group(5);
            String lon = m.group(6);
            String elev = m.group(7);
            Location siteLoc = elev != null ? new Location(Float.parseFloat(lat), Float.parseFloat(lon), (Quantity)new QuantityImpl((double)Float.parseFloat(elev), (Unit)UnitImpl.METER), (Quantity)new QuantityImpl(0.0, (Unit)UnitImpl.METER), LocationType.GEOGRAPHIC) : sta.getLocation();
            SiteImpl site = new SiteImpl(siteId, siteLoc, (Station)sta, instrumentInfo);
            Iterator it = NCReader.this.activeSites.iterator();
            int siteCount = 0;
            while (it.hasNext()) {
                Site s = (Site)it.next();
                if (!s.getStation().get_code().equals(code)) continue;
                if (s.getComment().equals(site.getComment()) && LocationUtil.areEqual((Location)siteLoc, (Location)s.getLocation())) {
                    NCReader.this.blockSites.add(s);
                    return;
                }
                ++siteCount;
            }
            site.get_id().site_code = "0" + siteCount;
            for (Site cur : NCReader.this.sites) {
                if (!cur.getStation().get_code().equals(code)) continue;
                site.setStation(cur.getStation());
                break;
            }
            NCReader.this.sites.add(site);
            NCReader.this.activeSites.add(site);
            NCReader.this.blockSites.add(site);
        }
    }

    public class EndBlockHandler
    extends REHandler {
        public EndBlockHandler() {
            super("END");
        }

        @Override
        public void operate(Matcher m) {
            if (NCReader.this.blockStart == null) {
                throw new FormatException("Encountered an 'END' without a corresponding 'START'");
            }
            Iterator it = NCReader.this.activeSites.iterator();
            while (it.hasNext()) {
                Site cur = (Site)it.next();
                if (NCReader.this.blockSites.contains(cur)) continue;
                cur.getEffectiveTime().end_time = NCReader.this.blockStart.getFissuresTime();
                cur.getStation().getEffectiveTime().end_time = NCReader.this.blockStart.getFissuresTime();
                it.remove();
            }
            for (int i = 0; i < NCReader.this.blockSites.size(); ++i) {
                Site ithSite = (Site)NCReader.this.blockSites.get(i);
                for (int j = i + 1; j < NCReader.this.blockSites.size(); ++j) {
                    Site jthSite = (Site)NCReader.this.blockSites.get(j);
                    if (ithSite.getStation().get_code().equals(jthSite.getStation().get_code())) {
                        throw new FormatException("The station code '" + ithSite.getStation().get_code() + "' appears twice in this block");
                    }
                    if (!DASChannelCreator.getUnitId(jthSite).equals(DASChannelCreator.getUnitId(ithSite))) continue;
                    throw new FormatException("The DAS Id '" + DASChannelCreator.getUnitId(jthSite) + "' appears twice in this block");
                }
            }
            NCReader.this.blockStart = null;
            NCReader.this.blockSites.clear();
        }
    }

    public class StartBlockHandler
    extends REHandler {
        public StartBlockHandler() {
            super("START (\\d{4}):(\\d{3})(:(\\d{2}))?(:(\\d{2}))?(:(\\d{2}))?");
        }

        @Override
        public void operate(Matcher m) {
            if (NCReader.this.blockStart != null) {
                throw new FormatException("Encountered a 'START' before seeing an 'END' for the previous 'START'");
            }
            NCReader.this.scratchCal.clear();
            NCReader.this.scratchCal.set(1, Integer.parseInt(m.group(1)));
            NCReader.this.scratchCal.set(6, Integer.parseInt(m.group(2)));
            if (m.group(4) != null) {
                NCReader.this.scratchCal.set(11, Integer.parseInt(m.group(4)));
            }
            if (m.group(6) != null) {
                NCReader.this.scratchCal.set(12, Integer.parseInt(m.group(6)));
            }
            if (m.group(8) != null) {
                NCReader.this.scratchCal.set(13, Integer.parseInt(m.group(8)));
            }
            NCReader.this.blockStart = new MicroSecondDate(NCReader.this.scratchCal.getTime());
        }
    }

    public class BlankAndCommentHandler
    extends REHandler {
        public BlankAndCommentHandler() {
            super("");
        }
    }

    public class REHandler
    extends LineHandler {
        private Pattern pattern;

        public REHandler(String source) {
            this.pattern = Pattern.compile(source + NCReader.this.commentRE);
        }

        @Override
        public boolean handle(String line) {
            Matcher m = this.pattern.matcher(line);
            if (m.matches()) {
                this.operate(m);
                return true;
            }
            return false;
        }

        public void operate(Matcher m) {
        }
    }

    private static class UnmatchedGatherer
    extends LineHandler {
        List unhandledLines = new ArrayList();

        private UnmatchedGatherer() {
        }

        @Override
        public boolean handle(String line) {
            this.unhandledLines.add(line);
            System.out.println("MISSED '" + line + "'");
            return true;
        }
    }

    private static class LineHandler {
        private LineHandler() {
        }

        public boolean handle(String line) {
            return true;
        }
    }
}

