/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.rt130.RT130FormatException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileNameParser {
    private static Calendar beginParserCal = Calendar.getInstance();
    private static final Pattern YEAR_DAY_DIR;
    private static final Pattern SINGLE_TIME_FILE;

    public static TimeInterval getLengthOfData(String fileName) throws RT130FormatException {
        if (fileName.length() != 18) {
            throw new RT130FormatException("The file '" + fileName + "'is not 18 characters in length.");
        }
        String stringLengthOfData = fileName.substring(10, 18);
        long longLengthOfData = Long.parseLong(stringLengthOfData, 16);
        TimeInterval lengthOfData = new TimeInterval((double)longLengthOfData, UnitImpl.MILLISECOND);
        return lengthOfData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MicroSecondDate getBeginTime(String yearAndDay, String fileName) {
        Date d;
        Matcher yearDay = YEAR_DAY_DIR.matcher(yearAndDay);
        if (!yearDay.matches()) {
            throw new IllegalArgumentException("The yearAndDay argument must be a four digit year specifier followed by a three digit julian day, not '" + yearAndDay + "'");
        }
        Matcher time = SINGLE_TIME_FILE.matcher(fileName);
        if (!time.matches()) {
            throw new IllegalArgumentException("The fileName argument must be an 18 character RT130 filename, not '" + fileName + "'");
        }
        int year = Integer.valueOf(yearDay.group(1));
        int dayOfYear = Integer.valueOf(yearDay.group(2));
        int hours = Integer.valueOf(time.group(1));
        int minutes = Integer.valueOf(time.group(2));
        int seconds = Integer.valueOf(time.group(3));
        int millis = Integer.valueOf(time.group(4));
        Calendar calendar = beginParserCal;
        synchronized (calendar) {
            beginParserCal.set(1, year);
            beginParserCal.set(6, dayOfYear);
            beginParserCal.set(11, hours);
            beginParserCal.set(12, minutes);
            beginParserCal.set(13, seconds);
            beginParserCal.set(14, millis);
            d = beginParserCal.getTime();
        }
        return new MicroSecondDate(d);
    }

    public static boolean isYearAndDayDir(String filename) {
        return YEAR_DAY_DIR.matcher(filename).matches();
    }

    public static boolean isRT130File(String filename) {
        return SINGLE_TIME_FILE.matcher(filename).matches();
    }

    static {
        beginParserCal.setTimeZone(TimeZone.getTimeZone("GMT"));
        beginParserCal.set(14, 0);
        YEAR_DAY_DIR = Pattern.compile("(\\d{4})(\\d{3})");
        SINGLE_TIME_FILE = Pattern.compile("(\\d{2})(\\d{2})(\\d{2})(\\d{3})_\\w{8}");
    }
}

