/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.SiteId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.LocationType;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.TimeUtils;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.SiteIdUtil;
import edu.iris.Fissures.network.SiteImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.bag.OrientationUtil;
import edu.sc.seis.fissuresUtil.database.seismogram.PopulationProperties;
import edu.sc.seis.fissuresUtil.rt130.NCReader;
import edu.sc.seis.fissuresUtil.rt130.RT130FileReader;
import edu.sc.seis.fissuresUtil.rt130.RT130FormatError;
import edu.sc.seis.fissuresUtil.rt130.RT130FormatException;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DASChannelCreator {
    private RT130FileReader rtFileReader = new RT130FileReader();
    private static Pattern orientation = Pattern.compile("(default)|\\d/(-?\\d+)/(-?\\d+):\\d/(-?\\d+)/(-?\\d+):\\d/(-?\\d+)/(-?\\d+)");
    private static final Orientation UP = OrientationUtil.getUp();
    private static final Orientation NORTH = OrientationUtil.getNorth();
    private static final Orientation EAST = OrientationUtil.getEast();
    private Pattern instrumentationParser = Pattern.compile("(\\w+/\\d+\\s+\\w+/\\w+\\s+(default|\\d/-?\\d+/-?\\d+:\\d/-?\\d+/-?\\d+:\\d/-?\\d+/-?\\d+))");
    private NetworkAttr net;
    private Map unitIdToSites = new HashMap();
    private Map siteToChannels = new HashMap();
    private List allSites = new ArrayList();
    private static final String TAG = "CreatedBy/DASChannelCreator";

    public DASChannelCreator(Properties props) throws IOException {
        this((NetworkAttr)PopulationProperties.getNetworkAttr(props), new NCReader(props).getSites());
    }

    public DASChannelCreator(NetworkAttr net) {
        this(net, new ArrayList(0));
    }

    public DASChannelCreator(NetworkAttr net, List sites) {
        this.net = net;
        Iterator it = sites.iterator();
        while (it.hasNext()) {
            this.add((Site)it.next());
        }
    }

    private void add(Site s) {
        String unitId = DASChannelCreator.getUnitId(s);
        if (!this.unitIdToSites.containsKey(unitId)) {
            this.unitIdToSites.put(unitId, new ArrayList());
        }
        List sites = (List)this.unitIdToSites.get(unitId);
        sites.add(s);
        this.siteToChannels.put(s, new HashMap());
        this.allSites.add(s);
    }

    private Site find(String unitIdNumber, MicroSecondDate beginTime) {
        Object siteOrList = this.unitIdToSites.get(unitIdNumber);
        if (siteOrList instanceof Site) {
            return (Site)siteOrList;
        }
        List sites = (List)siteOrList;
        for (Site s : sites) {
            if (!new MicroSecondTimeRange(s.getEffectiveTime()).contains(beginTime)) continue;
            return s;
        }
        throw new RT130FormatError(unitIdNumber + " had defined sites for it and data at " + beginTime + " outside of the effective time of those sites");
    }

    public static String getUnitId(Site s) {
        return s.getComment().substring(0, s.getComment().indexOf(47));
    }

    public static String getSensorId(Site s) {
        String commentSansDasId = s.getComment().split("\\s+")[1];
        return commentSansDasId.substring(0, commentSansDasId.indexOf(47));
    }

    public Channel[] create(String unitIdNumber, String fileLoc, MicroSecondTimeRange fileTimeWindow) {
        return this.create(unitIdNumber, fileTimeWindow.getBeginTime(), new File(fileLoc).getParentFile().getName(), new LazySamplingFinder(fileLoc, fileTimeWindow));
    }

    public ChannelImpl[] create(String unitIdNumber, MicroSecondDate beginTime, String datastream, int sampleRate) {
        return this.create(unitIdNumber, beginTime, datastream, new SamplingFinder(sampleRate));
    }

    private ChannelImpl[] create(String unitIdNumber, MicroSecondDate beginTime, String datastream, SamplingFinder finder) {
        Site s;
        if (this.unitIdToSites.containsKey(unitIdNumber)) {
            s = this.find(unitIdNumber, beginTime);
        } else {
            s = this.createSite(unitIdNumber, beginTime);
            this.unitIdToSites.put(unitIdNumber, s);
            this.siteToChannels.put(s, new HashMap());
            this.allSites.add(s);
        }
        Map dataStreamsToChannels = (Map)this.siteToChannels.get(s);
        if (dataStreamsToChannels.containsKey(datastream)) {
            return (ChannelImpl[])dataStreamsToChannels.get(datastream);
        }
        ChannelImpl[] chans = this.createChannels(s, finder.find());
        dataStreamsToChannels.put(datastream, chans);
        return chans;
    }

    private Site createSite(String unitIdNumber, MicroSecondDate begin) {
        Time beginTime = begin.getFissuresTime();
        TimeRange effTime = new TimeRange(beginTime, TimeUtils.timeUnknown);
        SiteId siteId = new SiteId(this.net.get_id(), unitIdNumber, "00", beginTime);
        StationId staId = new StationId(this.net.get_id(), unitIdNumber, beginTime);
        Location loc = new Location(0.0f, 0.0f, (Quantity)new QuantityImpl(0.0, (Unit)UnitImpl.METER), (Quantity)new QuantityImpl(0.0, (Unit)UnitImpl.METER), LocationType.GEOGRAPHIC);
        StationImpl station = new StationImpl(staId, "", loc, effTime, "", "", TAG, this.net);
        return new SiteImpl(siteId, loc, effTime, (Station)station, unitIdNumber + "/123 " + TAG + " default");
    }

    private ChannelImpl[] createChannels(Site s, int sampleRate) {
        int i;
        Matcher m;
        String band = "B";
        if (sampleRate < 10) {
            band = "L";
        }
        if (!(m = this.instrumentationParser.matcher(s.getComment())).matches()) {
            throw new RT130FormatError(SiteIdUtil.toString((SiteId)s.get_id()) + " has a malformed instrumentation specification '" + s.getComment() + "'");
        }
        Orientation[] orientations = DASChannelCreator.parseOrientations(m.group(2));
        if (orientations.length < 3) {
            System.out.println("GOT " + orientations.length + " orientations from " + m.group(2) + " from " + s.getComment());
        }
        SamplingImpl sampling = new SamplingImpl(sampleRate, new TimeInterval(1.0, UnitImpl.SECOND));
        ChannelImpl[] newChannel = new ChannelImpl[orientations.length];
        String[] orientationCodes = new String[orientations.length];
        if (this.traditionallyAligned(orientations)) {
            for (i = 0; i < orientationCodes.length; ++i) {
                orientationCodes[i] = OrientationUtil.areEqual(UP, orientations[i]) ? "Z" : (OrientationUtil.areEqual(NORTH, orientations[i]) ? "N" : "E");
            }
        } else {
            for (i = 0; i < orientationCodes.length; ++i) {
                orientationCodes[i] = "" + (i + 1);
            }
        }
        for (i = 0; i < orientations.length; ++i) {
            ChannelId id = new ChannelId(this.net.get_id(), s.getStation().get_code(), s.get_code(), band + "H" + orientationCodes[i], s.getEffectiveTime().start_time);
            newChannel[i] = new ChannelImpl(id, "", orientations[i], (Sampling)sampling, s.getEffectiveTime(), s);
        }
        return newChannel;
    }

    private boolean traditionallyAligned(Orientation[] orientations) {
        return orientations.length == 3 && this.contains(orientations, UP) && this.contains(orientations, EAST) && this.contains(orientations, NORTH);
    }

    private boolean contains(Orientation[] orientations, Orientation desired) {
        for (int i = 0; i < orientations.length; ++i) {
            if (!OrientationUtil.areEqual(orientations[i], desired)) continue;
            return true;
        }
        return false;
    }

    public static Orientation[] parseOrientations(String orientationString) {
        Matcher m = orientation.matcher(orientationString);
        if (!m.matches()) {
            throw new IllegalArgumentException("The orientation string must be either 'default' or a channel orientation specification");
        }
        if (m.group(1) != null) {
            return new Orientation[]{UP, NORTH, EAST};
        }
        Orientation[] orientations = new Orientation[3];
        for (int i = 0; i < orientations.length; ++i) {
            orientations[i] = new Orientation((float)Integer.parseInt(m.group(3 + i * 2)), (float)Integer.parseInt(m.group(2 + i * 2)));
        }
        return orientations;
    }

    public class LazySamplingFinder
    extends SamplingFinder {
        private String file;
        private MicroSecondTimeRange fileTimeWindow;

        public LazySamplingFinder(String file, MicroSecondTimeRange fileTimeWindow) {
            this.file = file;
            this.fileTimeWindow = fileTimeWindow;
        }

        @Override
        public int find() {
            try {
                return ((DASChannelCreator)DASChannelCreator.this).rtFileReader.processRT130Data((String)this.file, (boolean)false, (MicroSecondTimeRange)this.fileTimeWindow)[0].sample_rate;
            }
            catch (RT130FormatException e) {
                throw new RT130FormatError(e);
            }
            catch (IOException e) {
                throw new RT130FormatError(e);
            }
        }
    }

    public class SamplingFinder {
        public int sampling;

        public SamplingFinder() {
        }

        public SamplingFinder(int val) {
            this.sampling = val;
        }

        public int find() {
            return this.sampling;
        }
    }
}

