/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.namingService;

import edu.sc.seis.fissuresUtil.cache.ServerNameDNS;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import org.omg.CORBA.Object;
import org.omg.CORBA_2_3.ORB;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameServiceCopy {
    private static FissuresNamingService copyFromNS;
    private static FissuresNamingService copyToNS;
    private static NamingContextExt copyToNameContext;
    private static String dnsToCopy;
    private static final Logger logger;

    private static void logErrExit(String msg) {
        System.err.println(msg);
        logger.error(msg);
        System.exit(1);
    }

    private static void copy(ServerNameDNS[] from, ServerNameDNS[] to) throws NotFound, CannotProceed, InvalidName {
        for (int i = 0; i < from.length; ++i) {
            Object fromObj;
            String name;
            String dns;
            block7: {
                dns = from[i].getServerDNS();
                if (!dns.equals(dnsToCopy)) continue;
                name = from[i].getServerName();
                logger.info(name + " is in " + dnsToCopy + ".  Checking it");
                try {
                    fromObj = from[i].getCorbaObject();
                    if (from[i].getCorbaObject()._non_existent()) {
                        logger.info("Couldn't ping " + dns + " " + name + ", skipping");
                    }
                    break block7;
                }
                catch (RuntimeException e) {
                    logger.warn("Exception thrown while getting " + name + " from from name service.  Not being rebound to to nameservice", (Throwable)e);
                }
                continue;
            }
            boolean rebind = true;
            for (int j = 0; j < to.length; ++j) {
                if (!to[j].getServerDNS().equals(dnsToCopy) || !to[j].getServerName().equals(name)) continue;
                logger.info("Copy to name service contains " + name + " as well");
                try {
                    Object toObj = to[j].getCorbaObject();
                    if (toObj._non_existent() || !fromObj.equals(toObj)) break;
                    logger.info("Not going to rebind.  Copy to name service copy of " + name + " is the same as the one in copy from name service");
                    rebind = false;
                }
                catch (RuntimeException e) {}
                break;
            }
            if (!rebind) continue;
            logger.info("Rebinding " + name);
            copyFromNS.rebind(dns, name, fromObj, copyToNameContext);
        }
    }

    private static void copyEventDC() throws NotFound, CannotProceed, InvalidName {
        ServerNameDNS[] copyFromPlotDC = copyFromNS.getAllEventDC();
        ServerNameDNS[] copyToPlotDC = copyToNS.getAllEventDC();
        logger.info("Got " + copyFromPlotDC.length + " event datacenters");
        NameServiceCopy.copy(copyFromPlotDC, copyToPlotDC);
    }

    private static void copyPlotDC() throws NotFound, CannotProceed, InvalidName {
        ServerNameDNS[] copyFromPlotDC = copyFromNS.getAllPlottableDC();
        ServerNameDNS[] copyToPlotDC = copyToNS.getAllPlottableDC();
        logger.info("Got " + copyFromPlotDC.length + " plot datacenters");
        NameServiceCopy.copy(copyFromPlotDC, copyToPlotDC);
    }

    private static void copyNetDC() throws NotFound, CannotProceed, InvalidName {
        ServerNameDNS[] copyFromNetDC = copyFromNS.getAllNetworkDC();
        ServerNameDNS[] copyToNetDC = copyToNS.getAllNetworkDC();
        logger.info("Got " + copyToNetDC.length + " net datacenters");
        NameServiceCopy.copy(copyFromNetDC, copyToNetDC);
    }

    private static void copySeisDC() throws NotFound, CannotProceed, InvalidName {
        ServerNameDNS[] copyFromSeisDC = copyFromNS.getAllSeismogramDC();
        ServerNameDNS[] copyToSeisDC = copyToNS.getAllSeismogramDC();
        logger.info("Got " + copyFromSeisDC.length + " seis datacenters");
        NameServiceCopy.copy(copyFromSeisDC, copyToSeisDC);
    }

    public static void main(String[] args) throws CannotProceed, InvalidName, NotFound {
        String copyToNSLoc;
        Initializer.init(args);
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-h") && !args[i].equals("--help")) continue;
            System.out.println("-props propfile  Connfiguration properties");
            System.out.println("-h --help        Print this help message");
            System.exit(0);
        }
        dnsToCopy = System.getProperty("nameServiceCopy.dns");
        if (dnsToCopy == null) {
            NameServiceCopy.logErrExit("System property nameServiceCopy.dns must be set");
        }
        if ((copyToNSLoc = System.getProperty("nameServiceCopy.copyTo")) == null) {
            NameServiceCopy.logErrExit("System property nameServiceCopy.copyTo must be set");
        }
        if ((copyFromNS = Initializer.getNS()).getNameService() == null) {
            NameServiceCopy.logErrExit("Copy from ns is null!");
        }
        copyFromNS.addOtherNameServiceCorbaLoc(copyToNSLoc);
        ORB orb = Initializer.getORB();
        copyToNS = new FissuresNamingService(orb);
        copyToNS.setNameServiceCorbaLoc(copyToNSLoc);
        Object ncObj = orb.string_to_object(copyToNSLoc);
        copyToNameContext = NamingContextExtHelper.narrow((Object)ncObj);
        String copyFromNSLoc = System.getProperty("edu.sc.seis.fissuresUtil.nameServiceCorbaLoc");
        logger.info("Copying all servers in " + dnsToCopy + " from a naming service at " + copyFromNSLoc + " to naming service at " + copyToNSLoc);
        NameServiceCopy.copySeisDC();
        NameServiceCopy.copyNetDC();
        NameServiceCopy.copyEventDC();
        NameServiceCopy.copyPlotDC();
        logger.info("Done");
    }

    static {
        logger = LoggerFactory.getLogger(NameServiceCopy.class);
    }
}

