/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.mockFissures.IfEvent;

import edu.iris.Fissures.IfEvent.EventAttr;
import edu.iris.Fissures.IfEvent.Magnitude;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.event.OriginImpl;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.mockFissures.IfEvent.MockEventAttr;
import edu.sc.seis.fissuresUtil.mockFissures.IfEvent.MockMagnitude;
import edu.sc.seis.fissuresUtil.mockFissures.IfEvent.MockOrigin;
import edu.sc.seis.fissuresUtil.mockFissures.IfParameterMgr.MockParameterRef;
import edu.sc.seis.fissuresUtil.mockFissures.MockLocation;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;

public class MockEventAccessOperations {
    public static synchronized CacheEvent[] createEvents() {
        return new CacheEvent[]{MockEventAccessOperations.createEvent(), MockEventAccessOperations.createFallEvent()};
    }

    public static CacheEvent createEvent() {
        return MockEventAccessOperations.createEvent(MockOrigin.create(), MockEventAttr.create());
    }

    public static CacheEvent createEvent(MicroSecondDate time, float lat, float lon) {
        return MockEventAccessOperations.createEvent(MockOrigin.create(time, lat, lon), MockEventAttr.create());
    }

    public static CacheEvent createFallEvent() {
        return MockEventAccessOperations.createEvent(MockOrigin.createWallFallOrigin(), MockEventAttr.createWallFallAttr());
    }

    public static CacheEvent createEvent(MicroSecondDate eventTime, int magnitudeAndDepth, int feRegion) {
        Magnitude[] mags = new Magnitude[]{new Magnitude("test", (float)magnitudeAndDepth, "another")};
        return MockEventAccessOperations.createEvent(MockOrigin.create(eventTime, mags), MockEventAttr.create(feRegion));
    }

    public static CacheEvent createEvent(OriginImpl origin, EventAttr attr) {
        OriginImpl[] origins = new OriginImpl[]{origin};
        return new CacheEvent(attr, (Origin[])origins, origins[0]);
    }

    public static CacheEvent[] createEventTimeRange() {
        Time t = new Time("20010101T000000.000Z", 0);
        MicroSecondTimeRange tr = new MicroSecondTimeRange(new MicroSecondDate(t), new TimeInterval(30.0, UnitImpl.DAY));
        return MockEventAccessOperations.createEvents(tr, 3, 6);
    }

    public static CacheEvent[] createEvents(MicroSecondTimeRange timeRange, int rows, int cols) {
        int numEvents = rows * cols;
        TimeInterval timeBetweenEvents = (TimeInterval)timeRange.getInterval().divideBy((double)numEvents);
        CacheEvent[] events = new CacheEvent[numEvents];
        Location[] locs = MockLocation.create(rows, cols);
        Magnitude[][] mags = MockMagnitude.getMagnitudes(4.0f, 10.0f, numEvents);
        for (int i = 0; i < numEvents; ++i) {
            MicroSecondDate eventBegin = timeRange.getBeginTime().add((TimeInterval)timeBetweenEvents.multiplyBy((double)i));
            OriginImpl o = new OriginImpl("Mock Event " + i, "Mockalog", "Charlie Groves", eventBegin.getFissuresTime(), locs[i], mags[i], MockParameterRef.createParams());
            EventAttr ea = MockEventAttr.create();
            events[i] = new CacheEvent(ea, o);
        }
        return events;
    }
}

