/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.hibernate;

import edu.iris.Fissures.Plottable;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.display.SimplePlotUtil;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlottableChunk {
    private static final int MILLIS_IN_DAY = 86400000;
    public static final TimeInterval ONE_DAY = new TimeInterval(1.0, UnitImpl.DAY);
    private long dbid;
    private String networkCode;
    private String stationCode;
    private String siteCode;
    private String channelCode;
    private byte[] yBytes;
    private transient Plottable data = null;
    private int pixelsPerDay;
    private int beginPixel;
    private int numDataPoints;
    private int jday;
    private int year;
    private static final Logger logger = LoggerFactory.getLogger(PlottableChunk.class);

    protected PlottableChunk() {
    }

    public PlottableChunk(Plottable data, int startPixel, PlottableChunk otherStuff) {
        this(data, startPixel, otherStuff.getJDay(), otherStuff.getYear(), otherStuff.getPixelsPerDay(), otherStuff.getNetworkCode(), otherStuff.getStationCode(), otherStuff.getSiteCode(), otherStuff.getChannelCode());
    }

    public PlottableChunk(Plottable data, int startPixel, MicroSecondDate startDate, int pixelsPerDay, String networkCode, String stationCode, String siteCode, String channelCode) {
        this(data, startPixel, PlottableChunk.getJDay(startDate), PlottableChunk.getYear(startDate), pixelsPerDay, networkCode, stationCode, siteCode, channelCode);
    }

    public PlottableChunk(Plottable data, int startPixel, int jday, int year, int pixelsPerDay, String networkCode, String stationCode, String siteCode, String channelCode) {
        this.data = data;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            DataOutputStream dos = new DataOutputStream(new GZIPOutputStream(out));
            for (int k = 0; k < data.y_coor.length; ++k) {
                dos.writeInt(data.y_coor[k]);
            }
            dos.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Should never happen with a ByteArrayOutputStream", e);
        }
        this.yBytes = out.toByteArray();
        if (startPixel >= pixelsPerDay) {
            int numDaysToAdd = startPixel / pixelsPerDay;
            MicroSecondDate date = PlottableChunk.getDate(jday, year);
            date = date.add(new TimeInterval((Quantity)new TimeInterval(1.0, UnitImpl.DAY).multiplyBy((double)numDaysToAdd)));
            jday = PlottableChunk.getJDay(date);
            year = PlottableChunk.getYear(date);
            startPixel %= pixelsPerDay;
        }
        this.beginPixel = startPixel;
        this.pixelsPerDay = pixelsPerDay;
        this.numDataPoints = data.y_coor.length;
        this.jday = jday;
        this.year = year;
        this.networkCode = networkCode;
        this.stationCode = stationCode;
        this.siteCode = siteCode;
        this.channelCode = channelCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PlottableChunk) {
            PlottableChunk oChunk = (PlottableChunk)o;
            if (this.networkCode.equals(oChunk.networkCode) && this.stationCode.equals(oChunk.stationCode) && this.siteCode.equals(oChunk.siteCode) && this.channelCode.equals(oChunk.channelCode) && this.pixelsPerDay == oChunk.pixelsPerDay && this.jday == oChunk.jday && this.year == oChunk.year && this.getNumDataPoints() == oChunk.getNumDataPoints()) {
                return true;
            }
        }
        return false;
    }

    public static Calendar makeCal() {
        return Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    }

    public static Calendar makeCalWithDate(int jday, int year) {
        Calendar cal = PlottableChunk.makeCal();
        cal.set(6, jday);
        cal.set(1, year);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static MicroSecondDate getDate(int jday, int year) {
        return new MicroSecondDate(PlottableChunk.makeCalWithDate(jday, year).getTimeInMillis() * 1000L);
    }

    public static MicroSecondDate getTime(int pixel, int jday, int year, int pixelsPerDay) {
        Calendar cal = PlottableChunk.makeCalWithDate(jday, year);
        double sampleMillis = SimplePlotUtil.linearInterp(0.0, 0.0, pixelsPerDay, 8.64E7, pixel);
        sampleMillis = Math.floor(sampleMillis);
        return new MicroSecondDate((cal.getTimeInMillis() + (long)sampleMillis) * 1000L);
    }

    public static int getJDay(MicroSecondDate time) {
        Calendar cal = PlottableChunk.makeCal();
        cal.setTime((Date)time);
        return cal.get(6);
    }

    public static int getYear(MicroSecondDate time) {
        Calendar cal = PlottableChunk.makeCal();
        cal.setTime((Date)time);
        return cal.get(1);
    }

    public static int getPixel(MicroSecondDate time, int pixelsPerDay) {
        MicroSecondDate day = new MicroSecondDate(PlottableChunk.stripToDay((Date)time));
        MicroSecondTimeRange tr = new MicroSecondTimeRange(day, ONE_DAY);
        double pixel = SimplePlotUtil.getPixel(pixelsPerDay, tr, time);
        return (int)Math.floor(pixel);
    }

    public static MicroSecondDate stripToDay(Date d) {
        Calendar cal = PlottableChunk.makeCal();
        cal.setTime(d);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new MicroSecondDate(cal.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plottable getData() {
        PlottableChunk plottableChunk = this;
        synchronized (plottableChunk) {
            if (this.data == null) {
                int[] yValues = this.getYData();
                int[] xValues = new int[yValues.length];
                for (int i = 0; i < xValues.length; ++i) {
                    xValues[i] = i / 2;
                }
                this.data = new Plottable(xValues, yValues);
            }
        }
        return this.data;
    }

    public int getPixelsPerDay() {
        return this.pixelsPerDay;
    }

    public int getBeginPixel() {
        return this.beginPixel;
    }

    public int getNumPixels() {
        return this.getNumDataPoints() / 2;
    }

    public MicroSecondDate getTime(int pixel) {
        return PlottableChunk.getTime(pixel, this.getJDay(), this.getYear(), this.getPixelsPerDay());
    }

    public MicroSecondDate getBeginTime() {
        return this.getTime(this.beginPixel);
    }

    public MicroSecondDate getEndTime() {
        return this.getTime(this.getBeginPixel() + this.getNumPixels());
    }

    public MicroSecondTimeRange getTimeRange() {
        return new MicroSecondTimeRange(this.getBeginTime(), this.getEndTime());
    }

    public int getJDay() {
        return this.jday;
    }

    public int getYear() {
        return this.year;
    }

    public int hashCode() {
        int hashCode = 81 + this.networkCode.hashCode();
        hashCode = 37 * hashCode + this.stationCode.hashCode();
        hashCode = 37 * hashCode + this.siteCode.hashCode();
        hashCode = 37 * hashCode + this.channelCode.hashCode();
        hashCode = 37 * hashCode + this.pixelsPerDay;
        hashCode = 37 * hashCode + this.jday;
        hashCode = 37 * hashCode + this.year;
        return 37 * hashCode + this.getNumDataPoints();
    }

    public String toString() {
        return this.getNumPixels() + " pixel chunk from " + this.networkCode + "." + this.stationCode + "." + this.siteCode + "." + this.channelCode + " at " + this.pixelsPerDay + " ppd from " + this.getTimeRange();
    }

    public List<PlottableChunk> breakIntoDays() {
        int numDays = (int)Math.ceil((double)(this.beginPixel + this.getNumPixels()) / (double)this.getPixelsPerDay());
        ArrayList<PlottableChunk> dayChunks = new ArrayList<PlottableChunk>();
        MicroSecondDate time = this.getBeginTime();
        for (int i = 0; i < numDays; ++i) {
            int firstDayPixels = this.pixelsPerDay - this.getBeginPixel();
            int startPixel = (i - 1) * this.pixelsPerDay + firstDayPixels;
            int stopPixel = i * this.pixelsPerDay + firstDayPixels;
            int pixelIntoNewDay = 0;
            if (i == 0) {
                startPixel = 0;
                stopPixel = firstDayPixels;
                pixelIntoNewDay = this.getBeginPixel();
            }
            if (i == numDays - 1) {
                stopPixel = this.getNumPixels();
            }
            int[] y = new int[(stopPixel - startPixel) * 2];
            System.arraycopy(this.getYData(), startPixel * 2, y, 0, y.length);
            Plottable p = new Plottable(null, y);
            dayChunks.add(new PlottableChunk(p, pixelIntoNewDay, PlottableChunk.getJDay(time), PlottableChunk.getYear(time), this.getPixelsPerDay(), this.getNetworkCode(), this.getStationCode(), this.getSiteCode(), this.getChannelCode()));
            time = time.add(ONE_DAY);
        }
        return dayChunks;
    }

    protected void setData(Plottable data) {
        this.data = data;
    }

    protected void setPixelsPerDay(int pixelsPerDay) {
        this.pixelsPerDay = pixelsPerDay;
    }

    protected void setBeginPixel(int beginPixel) {
        this.beginPixel = beginPixel;
    }

    protected void setJday(int jday) {
        this.jday = jday;
    }

    protected void setYear(int year) {
        this.year = year;
    }

    public long getDbid() {
        return this.dbid;
    }

    protected void setDbid(long dbid) {
        this.dbid = dbid;
    }

    protected Timestamp getBeginTimestamp() {
        return this.getBeginTime().getTimestamp();
    }

    protected void setBeginTimestamp(Timestamp begin) {
        MicroSecondDate msd = new MicroSecondDate(begin);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime((Date)msd);
        this.year = cal.get(1);
        this.jday = cal.get(6);
    }

    protected Timestamp getEndTimestamp() {
        return this.getEndTime().getTimestamp();
    }

    protected void setEndTimestamp(Timestamp begin) {
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public void setNetworkCode(String networkCode) {
        this.networkCode = networkCode;
    }

    public String getStationCode() {
        return this.stationCode;
    }

    public void setStationCode(String stationCode) {
        this.stationCode = stationCode;
    }

    public String getSiteCode() {
        return this.siteCode;
    }

    public void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    public String getChannelCode() {
        return this.channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public byte[] getYBytes() {
        return this.yBytes;
    }

    protected void setYBytes(byte[] bytes) {
        this.yBytes = bytes;
    }

    public int[] getYData() {
        return this.toIntArray(this.getYBytes());
    }

    private int[] toIntArray(byte[] bytes) {
        try {
            DataInputStream dis = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(bytes)));
            int[] decomp = new int[this.getNumDataPoints()];
            for (int i = 0; i < decomp.length; ++i) {
                decomp[i] = dis.readInt();
            }
            return decomp;
        }
        catch (IOException e) {
            throw new RuntimeException("Should never happen", e);
        }
    }

    public int getNumDataPoints() {
        return this.numDataPoints;
    }

    protected void setNumDataPoints(int numDataPoints) {
        this.numDataPoints = numDataPoints;
    }
}

