/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.hibernate;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.cache.CacheNetworkAccess;
import edu.sc.seis.fissuresUtil.cache.LazyNetworkAccess;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkDC;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.hibernate.AbstractHibernateDB;
import edu.sc.seis.fissuresUtil.hibernate.ChannelGroup;
import edu.sc.seis.fissuresUtil.hibernate.ChannelSensitivity;
import edu.sc.seis.fissuresUtil.hibernate.InstrumentationBlob;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkDB
extends AbstractHibernateDB {
    private static NetworkDB singleton;
    static String getStationByCodes;
    static String getAllStationsByCode;
    static String getStationByIdString;
    static String getStationForNetwork;
    static String getChannelForNetwork;
    static String getStationForNetworkStation;
    static String getChannelForStation;
    static String getChannelGroupForStation;
    static String getChannelForStationAtTime;
    static String chanCodeHQL;
    static String getChannelByCode;
    static String getChannelById;
    static String getAllStationsString;
    static String getAllNetsString;
    static String getNetworkByCodeString;
    private static final Logger logger;

    protected NetworkDB() {
    }

    public int put(NetworkAttrImpl net) {
        Session session = NetworkDB.getSession();
        if (net.getDbid() != 0) {
            session.saveOrUpdate((Object)net);
            return net.getDbid();
        }
        Iterator<NetworkAttrImpl> fromDB = this.getNetworkByCode(net.get_code()).iterator();
        if (fromDB.hasNext()) {
            if (NetworkIdUtil.isTemporary((String)net.get_code())) {
                while (fromDB.hasNext()) {
                    NetworkAttrImpl indb = fromDB.next();
                    if (!net.get_code().equals(indb.get_code()) || !NetworkIdUtil.getTwoCharYear((NetworkId)net.get_id()).equals(NetworkIdUtil.getTwoCharYear((NetworkId)indb.get_id()))) continue;
                    net.associateInDB(indb);
                    NetworkDB.getSession().evict((Object)indb);
                    NetworkDB.getSession().saveOrUpdate((Object)net);
                    return net.getDbid();
                }
            } else {
                NetworkAttrImpl indb = fromDB.next();
                net.associateInDB(indb);
                NetworkDB.getSession().evict((Object)indb);
                NetworkDB.getSession().saveOrUpdate((Object)net);
                return net.getDbid();
            }
        }
        return (Integer)session.save((Object)net);
    }

    public int put(StationImpl sta) {
        if (((NetworkAttrImpl)sta.getNetworkAttr()).getDbid() == 0) {
            try {
                sta.setNetworkAttr((NetworkAttr)this.getNetworkById(sta.getNetworkAttr().get_id()));
            }
            catch (NotFound ee) {
                this.put((NetworkAttrImpl)sta.getNetworkAttr());
            }
        }
        this.internUnit((Station)sta);
        if (sta.getDbid() != 0) {
            NetworkDB.getSession().saveOrUpdate((Object)sta);
            return sta.getDbid();
        }
        try {
            StationImpl indb = this.getStationById(sta.get_id());
            sta.associateInDB(indb);
            NetworkDB.getSession().evict((Object)indb);
            NetworkDB.getSession().evict((Object)indb.getNetworkAttr());
            NetworkDB.getSession().saveOrUpdate((Object)sta);
            return sta.getDbid();
        }
        catch (NotFound e) {
            Integer dbid = (Integer)NetworkDB.getSession().save((Object)sta);
            return dbid;
        }
    }

    public int put(ChannelImpl chan) {
        this.internUnit(chan);
        if (((StationImpl)chan.getSite().getStation()).getDbid() == 0) {
            try {
                chan.getSite().setStation((Station)this.getStationById(chan.getSite().getStation().get_id()));
            }
            catch (NotFound e) {
                int staDbid = this.put((StationImpl)chan.getSite().getStation());
            }
        }
        try {
            ChannelImpl indb = this.getChannel(chan.get_id());
            chan.associateInDB(indb);
            NetworkDB.getSession().evict((Object)indb);
            NetworkDB.getSession().evict((Object)indb.getSite().getStation());
            NetworkDB.getSession().evict((Object)indb.getSite().getStation().getNetworkAttr());
            NetworkDB.getSession().saveOrUpdate((Object)chan);
            return chan.getDbid();
        }
        catch (NotFound nf) {
            Integer dbid = (Integer)NetworkDB.getSession().save((Object)chan);
            return dbid;
        }
    }

    public int put(ChannelGroup cg) {
        ChannelGroup indb = this.getChannelGroup(cg.getChannel1(), cg.getChannel2(), cg.getChannel3());
        ChannelImpl[] chans = cg.getChannels();
        for (int i = 0; i < chans.length; ++i) {
            if (chans[i].getDbid() != 0) continue;
            try {
                chans[i] = this.getChannel(chans[i].get_id());
                continue;
            }
            catch (NotFound e) {
                this.put(chans[i]);
            }
        }
        if (indb != null) {
            cg.setDbid(indb.getDbid());
            NetworkDB.getSession().evict((Object)indb);
            NetworkDB.getSession().saveOrUpdate((Object)cg);
            return cg.getDbid();
        }
        int dbid = (Integer)NetworkDB.getSession().save((Object)cg);
        return dbid;
    }

    public List<ChannelGroup> getChannelGroup(ChannelImpl chan) {
        Query query = NetworkDB.getSession().createQuery("from " + ChannelGroup.class.getName() + " where channel1 = :chan or channel2 = :chan or channel3 = :chan");
        query.setEntity("chan", (Object)chan);
        return query.list();
    }

    public ChannelGroup getChannelGroup(ChannelImpl chanA, ChannelImpl chanB, ChannelImpl chanC) {
        Query query = NetworkDB.getSession().createQuery("from " + ChannelGroup.class.getName() + " where " + "    ( channel1 = :chanA and channel2 = :chanB and channel3 = :chanC )" + " or ( channel1 = :chanB and channel2 = :chanA and channel3 = :chanC )" + " or ( channel1 = :chanC and channel2 = :chanA and channel3 = :chanB )" + " or ( channel1 = :chanA and channel2 = :chanC and channel3 = :chanB )" + " or ( channel1 = :chanB and channel2 = :chanC and channel3 = :chanA )" + " or ( channel1 = :chanC and channel2 = :chanB and channel3 = :chanA )");
        query.setEntity("chanA", (Object)chanA);
        query.setEntity("chanB", (Object)chanB);
        query.setEntity("chanC", (Object)chanC);
        query.setMaxResults(1);
        List l = query.list();
        if (l.size() != 0) {
            return (ChannelGroup)l.get(0);
        }
        return null;
    }

    public List<StationImpl> getStationByCodes(String netCode, String staCode) {
        Query query = NetworkDB.getSession().createQuery(getStationByCodes);
        query.setString("netCode", netCode);
        query.setString("staCode", staCode);
        return query.list();
    }

    public List<StationImpl> getAllStationsByCode(String staCode) {
        Query query = NetworkDB.getSession().createQuery(getAllStationsByCode);
        query.setString("staCode", staCode);
        return query.list();
    }

    public StationImpl getStationById(StationId staId) throws NotFound {
        Query query = NetworkDB.getSession().createQuery(getStationByIdString);
        query.setString("netCode", staId.network_id.network_code);
        query.setString("staCode", staId.station_code);
        query.setTimestamp("staBegin", (Date)new MicroSecondDate(staId.begin_time).getTimestamp());
        query.setMaxResults(1);
        List l = query.list();
        if (l.size() != 0) {
            return (StationImpl)l.get(0);
        }
        throw new NotFound();
    }

    public List<NetworkAttrImpl> getNetworkByCode(String netCode) {
        Query query = NetworkDB.getSession().createQuery(getNetworkByCodeString);
        query.setString("netCode", netCode);
        return query.list();
    }

    public NetworkAttrImpl getNetworkById(NetworkId netId) throws NotFound {
        List<NetworkAttrImpl> result = this.getNetworkByCode(netId.network_code);
        if (NetworkIdUtil.isTemporary((NetworkId)netId)) {
            for (NetworkAttrImpl n : result) {
                if (!NetworkIdUtil.areEqual((NetworkId)netId, (NetworkId)n.get_id())) continue;
                return n;
            }
            throw new NotFound();
        }
        if (result.size() > 0) {
            return result.get(0);
        }
        throw new NotFound();
    }

    public NetworkAttrImpl getNetwork(int dbid) throws NotFound {
        NetworkAttrImpl out = (NetworkAttrImpl)NetworkDB.getSession().get(NetworkAttrImpl.class, (Serializable)new Integer(dbid));
        if (out == null) {
            throw new NotFound();
        }
        return out;
    }

    public List<NetworkAttrImpl> getAllNetworks() {
        Query query = NetworkDB.getSession().createQuery(getAllNetsString);
        return query.list();
    }

    public StationImpl getStation(int dbid) throws NotFound {
        StationImpl out = (StationImpl)NetworkDB.getSession().get(StationImpl.class, (Serializable)new Integer(dbid));
        if (out == null) {
            throw new NotFound();
        }
        return out;
    }

    public StationImpl[] getAllStations() {
        Query query = NetworkDB.getSession().createQuery(getAllStationsString);
        List result = query.list();
        return result.toArray(new StationImpl[0]);
    }

    public List<StationImpl> getStationForNet(NetworkAttrImpl attr) {
        Query query = NetworkDB.getSession().createQuery(getStationForNetwork);
        query.setEntity("netAttr", (Object)attr);
        return query.list();
    }

    public List<StationImpl> getStationForNet(NetworkAttrImpl attr, String staCode) {
        Query query = NetworkDB.getSession().createQuery(getStationForNetworkStation);
        query.setEntity("netAttr", (Object)attr);
        query.setString("staCode", staCode);
        return query.list();
    }

    public List<ChannelImpl> getChannelsForNet(NetworkAttrImpl attr) {
        Query query = NetworkDB.getSession().createQuery(getChannelForNetwork);
        query.setEntity("netAttr", (Object)attr);
        return query.list();
    }

    public ChannelImpl getChannel(int dbid) throws NotFound {
        ChannelImpl out = (ChannelImpl)NetworkDB.getSession().get(ChannelImpl.class, (Serializable)new Integer(dbid));
        if (out == null) {
            throw new NotFound();
        }
        return out;
    }

    public List<CacheNetworkAccess> getAllNets(ProxyNetworkDC networkDC) {
        Query query = NetworkDB.getSession().createQuery(getAllNetsString);
        List result = query.list();
        ArrayList<CacheNetworkAccess> out = new ArrayList<CacheNetworkAccess>();
        for (NetworkAttrImpl attr : result) {
            LazyNetworkAccess cnet = new LazyNetworkAccess(attr, networkDC);
            out.add(cnet);
        }
        return out;
    }

    public List<ChannelImpl> getAllChannels() {
        return NetworkDB.getSession().createQuery("from " + ChannelImpl.class.getName()).list();
    }

    public List<ChannelImpl> getChannelsForStation(StationImpl station) {
        Query query = NetworkDB.getSession().createQuery(getChannelForStation);
        query.setEntity("station", (Object)station);
        return query.list();
    }

    public List<ChannelGroup> getChannelGroupsForStation(StationImpl station) {
        Query query = NetworkDB.getSession().createQuery(getChannelGroupForStation);
        query.setEntity("station", (Object)station);
        return query.list();
    }

    public List<ChannelImpl> getChannelsForStation(StationImpl station, MicroSecondDate when) {
        Query query = NetworkDB.getSession().createQuery(getChannelForStationAtTime);
        query.setEntity("station", (Object)station);
        query.setTimestamp("when", (Date)when.getTimestamp());
        return query.list();
    }

    public ChannelImpl getChannel(String net, String sta, String site, String chan, MicroSecondDate when) throws NotFound {
        return this.getChannel(net, sta, site, chan, when, getChannelByCode);
    }

    public List<ChannelImpl> getChannelsByCode(NetworkId net, String sta, String site, String chan) {
        String queryString = "From " + ChannelImpl.class.getName() + " WHERE " + chanCodeHQL + " AND site.station.networkAttr.beginTime.time = :when";
        Query query = NetworkDB.getSession().createQuery(queryString);
        query.setString("netCode", net.network_code);
        query.setString("stationCode", sta);
        query.setString("siteCode", site);
        query.setString("channelCode", chan);
        query.setTimestamp("when", (Date)new MicroSecondDate(net.begin_time).getTimestamp());
        return query.list();
    }

    public ChannelImpl getChannel(ChannelId id) throws NotFound {
        return this.getChannel(id.network_id.network_code, id.station_code, id.site_code, id.channel_code, new MicroSecondDate(id.begin_time), getChannelById);
    }

    protected ChannelImpl getChannel(String net, String sta, String site, String chan, MicroSecondDate when, String queryString) throws NotFound {
        Query query = NetworkDB.getSession().createQuery(queryString);
        query.setString("netCode", net);
        query.setString("stationCode", sta);
        query.setString("siteCode", site);
        query.setString("channelCode", chan);
        query.setTimestamp("when", (Date)when.getTimestamp());
        query.setMaxResults(1);
        List result = query.list();
        if (result.size() == 0) {
            throw new NotFound();
        }
        return (ChannelImpl)result.get(0);
    }

    public InstrumentationBlob getInstrumentationBlob(ChannelImpl chan) throws ChannelNotFound {
        Query query = NetworkDB.getSession().createQuery("from " + InstrumentationBlob.class.getName() + " where channel = :chan");
        query.setEntity("chan", (Object)chan);
        Iterator it = query.iterate();
        if (it.hasNext()) {
            InstrumentationBlob ib = (InstrumentationBlob)it.next();
            return ib;
        }
        return null;
    }

    public Instrumentation getInstrumentation(ChannelImpl chan) throws ChannelNotFound {
        InstrumentationBlob ib = this.getInstrumentationBlob(chan);
        if (ib != null) {
            Instrumentation inst = ib.getInstrumentation();
            if (inst == null) {
                throw new ChannelNotFound();
            }
            return inst;
        }
        return null;
    }

    public ChannelSensitivity getSensitivity(ChannelImpl chan) {
        Query query = NetworkDB.getSession().createQuery("from " + ChannelSensitivity.class.getName() + " where channel = :chan");
        query.setEntity("chan", (Object)chan);
        Iterator it = query.iterate();
        if (it.hasNext()) {
            ChannelSensitivity sense = (ChannelSensitivity)it.next();
            return sense;
        }
        return null;
    }

    public void putSensitivity(ChannelSensitivity sensitivity) {
        ChannelSensitivity inDb = this.getSensitivity(sensitivity.getChannel());
        if (inDb != null) {
            sensitivity.setDbid(inDb.getDbid());
            NetworkDB.getSession().evict((Object)inDb);
        }
        sensitivity.setInputUnits(NetworkDB.intern(sensitivity.getInputUnits()));
        NetworkDB.getSession().saveOrUpdate((Object)sensitivity);
    }

    public void putInstrumentation(ChannelImpl chan, Instrumentation inst) {
        logger.debug("Put instrumentation: " + ChannelIdUtil.toStringNoDates((Channel)chan));
        InstrumentationBlob ib = null;
        try {
            ib = this.getInstrumentationBlob(chan);
        }
        catch (ChannelNotFound e) {
            // empty catch block
        }
        if (ib == null) {
            ib = new InstrumentationBlob(chan, inst);
        } else {
            int dbid = ib.getDbid();
            NetworkDB.getSession().evict((Object)ib);
            ib = new InstrumentationBlob(chan, inst);
            ib.setDbid(dbid);
        }
        NetworkDB.getSession().saveOrUpdate((Object)ib);
    }

    public void internUnit(Station sta) {
        NetworkDB.internUnit(sta.getLocation());
    }

    public void internUnit(ChannelImpl chan) {
        NetworkDB.internUnit(chan.getSite().getLocation());
        this.internUnit(chan.getSite().getStation());
        NetworkDB.internUnit(chan.getSamplingInfo().interval);
    }

    public static NetworkDB getSingleton() {
        if (singleton == null) {
            singleton = new NetworkDB();
        }
        return singleton;
    }

    static {
        getStationByCodes = "SELECT s From " + StationImpl.class.getName() + " s WHERE s.networkAttr.id.network_code = :netCode AND s.id.station_code = :staCode";
        getAllStationsByCode = "SELECT s From " + StationImpl.class.getName() + " s WHERE s.id.station_code = :staCode";
        getStationByIdString = getStationByCodes + " AND sta_begin_time = :staBegin";
        getStationForNetwork = "From " + StationImpl.class.getName() + " s WHERE s.networkAttr = :netAttr";
        getChannelForNetwork = "From " + ChannelImpl.class.getName() + " WHERE site.station.networkAttr = :netAttr";
        getStationForNetworkStation = getStationForNetwork + " and s.id.station_code = :staCode";
        getChannelForStation = "From " + ChannelImpl.class.getName() + " c WHERE c.site.station = :station";
        getChannelGroupForStation = "From " + ChannelGroup.class.getName() + " c WHERE c.channel1.site.station = :station";
        getChannelForStationAtTime = getChannelForStation + " and :when between chan_begin_time and chan_end_time  order by chan_begin_time desc";
        chanCodeHQL = " id.channel_code = :channelCode AND id.site_code = :siteCode AND id.station_code = :stationCode AND site.station.networkAttr.id.network_code = :netCode ";
        getChannelByCode = "From " + ChannelImpl.class.getName() + " WHERE " + chanCodeHQL + " AND :when between chan_begin_time and chan_end_time order by chan_begin_time desc";
        getChannelById = "From " + ChannelImpl.class.getName() + " WHERE " + chanCodeHQL + " AND chan_begin_time =  :when";
        getAllStationsString = "From edu.iris.Fissures.network.StationImpl s";
        getAllNetsString = "From edu.iris.Fissures.network.NetworkAttrImpl n";
        getNetworkByCodeString = getAllNetsString + " WHERE network_code = :netCode";
        logger = LoggerFactory.getLogger(NetworkDB.class);
    }
}

