/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.hibernate;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.StationIdUtil;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkConsistencyCheck {
    private static final Logger logger = LoggerFactory.getLogger(NetworkConsistencyCheck.class);

    public static boolean isConsistent(NetworkAttrImpl net, StationImpl sta) {
        MicroSecondTimeRange staRange = new MicroSecondTimeRange(sta.getEffectiveTime());
        MicroSecondTimeRange netRange = new MicroSecondTimeRange(net.getEffectiveTime());
        if (netRange.getBeginTime().after((Date)staRange.getBeginTime())) {
            logger.warn("Network begins after station: " + NetworkIdUtil.toString((NetworkAttr)net) + "  " + StationIdUtil.toString((Station)sta));
            return false;
        }
        return true;
    }

    public static boolean isConsistent(List<? extends StationImpl> staList) {
        if (staList.size() < 2) {
            return true;
        }
        List<? extends StationImpl> subStaList = staList.subList(1, staList.size());
        StationImpl first = staList.get(0);
        for (StationImpl stationImpl : subStaList) {
            if (NetworkConsistencyCheck.isConsistent(first, stationImpl)) continue;
            return false;
        }
        return NetworkConsistencyCheck.isConsistent(subStaList);
    }

    public static boolean isConsistent(StationImpl staA, StationImpl staB) {
        MicroSecondTimeRange staBRange;
        if (!staA.getNetworkAttrImpl().get_code().equals(staB.getNetworkAttrImpl().get_code()) || !staA.get_code().equals(staB.get_code())) {
            return true;
        }
        MicroSecondTimeRange staARange = new MicroSecondTimeRange(staA.getEffectiveTime());
        if (staARange.intersects(staBRange = new MicroSecondTimeRange(staB.getEffectiveTime()))) {
            logger.warn("Station overlaps other station: " + StationIdUtil.toString((Station)staA) + "-" + staA.getEndTime().date_time + "   " + StationIdUtil.toString((Station)staB) + "-" + staB.getEndTime().date_time);
            return false;
        }
        return true;
    }

    public static boolean isConsistent(StationImpl sta, ChannelImpl chan) {
        MicroSecondTimeRange staRange = new MicroSecondTimeRange(sta.getEffectiveTime());
        MicroSecondTimeRange chanRange = new MicroSecondTimeRange(chan.getEffectiveTime());
        if (staRange.getBeginTime().after((Date)chanRange.getBeginTime())) {
            logger.warn("Station begins after channel: " + ChannelIdUtil.toStringNoDates((ChannelId)chan.getId()) + " " + chanRange + "    " + StationIdUtil.toString((Station)sta) + " " + staRange);
            return false;
        }
        return true;
    }
}

