/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.hibernate;

import edu.sc.seis.fissuresUtil.database.ConnMgr;
import edu.sc.seis.fissuresUtil.database.ConnectionCreator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import net.sf.ehcache.CacheManager;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.MySQL5Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.Oracle10gDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateUtil {
    private static String configFile = "edu/sc/seis/fissuresUtil/hibernate/hibernate.cfg.xml";
    private static SessionFactory sessionFactory;
    private static Configuration configuration;
    private static final Logger logger;
    public static final URL DEFAULT_EHCACHE_CONFIG;

    public static synchronized SessionFactory getSessionFactory() {
        if (sessionFactory == null) {
            logger.debug("Sessionfactory is null, creating...");
            sessionFactory = HibernateUtil.getConfiguration().buildSessionFactory();
        }
        return sessionFactory;
    }

    public static synchronized Configuration getConfiguration() {
        if (configuration == null) {
            logger.debug("Hibernate configuration is null, loading config from " + configFile);
            configuration = new Configuration().configure(configFile);
        }
        return configuration;
    }

    public static synchronized void setConfigFile(String s) {
        logger.warn("Reseting hibernate configuration: " + s);
        configFile = s;
        sessionFactory = null;
        configuration = null;
    }

    public static void setUpFromConnMgr(Properties props, URL ehcacheConfig) {
        if (!props.containsKey("ehcache.disk.store.dir")) {
            String dirname = "hibernate_ehcache";
            try {
                File f = File.createTempFile(dirname, ".cache");
                f.delete();
                dirname = f.mkdir() ? f.getCanonicalPath() : dirname + "_" + Math.random();
            }
            catch (IOException e) {
                dirname = dirname + "_" + Math.random();
            }
            props.put("ehcache.disk.store.dir", dirname);
        }
        HibernateUtil.setUpEHCache(ehcacheConfig);
        HibernateUtil.setUpFromConnMgr(props);
    }

    static void setUpEHCache(URL ehcacheConfig) {
        if (ehcacheConfig == null) {
            throw new IllegalArgumentException("ehcacheConfig cannot be null");
        }
        try {
            CacheManager singletonManager = CacheManager.create((InputStream)ehcacheConfig.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Trouble finding EhCache config from " + ehcacheConfig.toString(), e);
        }
    }

    public static void setUpFromConnMgr(Properties props) {
        String dialect;
        if (ConnMgr.getDB_TYPE().equals("HSQL")) {
            logger.info("using hsql dialect");
            dialect = HSQLDialect.class.getName();
        } else if (ConnMgr.getDB_TYPE().equals("POSTGRES")) {
            logger.info("using postgres dialect");
            dialect = PostgreSQLDialect.class.getName();
        } else if (ConnMgr.getDB_TYPE().equals("MYSQL")) {
            logger.info("using mysql dialect");
            dialect = MySQLDialect.class.getName();
        } else if (ConnMgr.getDB_TYPE().equals("ORACLE")) {
            logger.info("using oracle dialect");
            dialect = Oracle10gDialect.class.getName();
        } else {
            throw new RuntimeException("Unknown database type: '" + ConnMgr.getDB_TYPE() + "'");
        }
        HibernateUtil.setUp(dialect, ConnMgr.getDriver(), ConnMgr.getURL(), ConnMgr.getUser(), ConnMgr.getPass(), props);
        HibernateUtil.getConfiguration().addProperties(ConnMgr.getDBProps());
    }

    public static void setUpFromConnectionCreator(ConnectionCreator c, URL ehcacheConfig) {
        String dialect;
        HibernateUtil.setUpEHCache(ehcacheConfig);
        if (c.getType().equals("HSQL")) {
            logger.info("using hsql dialect");
            dialect = HSQLDialect.class.getName();
        } else if (c.getType().equals("POSTGRES")) {
            logger.info("using postgres dialect");
            dialect = PostgreSQLDialect.class.getName();
        } else {
            throw new RuntimeException("Unknown database type: '" + c.getType() + "'");
        }
        HibernateUtil.setUp(dialect, c.getDriverClass().getName(), c.getUrl(), c.getUsername(), c.getPassword(), c.getExtraProps());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUp(String dialect, String driverClass, String dbURL, String username, String password, Properties props) {
        Class<HibernateUtil> clazz = HibernateUtil.class;
        synchronized (HibernateUtil.class) {
            HibernateUtil.getConfiguration().setProperty("hibernate.dialect", dialect);
            HibernateUtil.getConfiguration().setProperty("hibernate.connection.driver_class", driverClass).setProperty("hibernate.connection.url", dbURL).setProperty("hibernate.connection.username", username).setProperty("hibernate.connection.password", password).addProperties(props);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    public static String getDialectForURL(String url) {
        if (url.startsWith("jdbc:hsql")) {
            return HSQLDialect.class.getName();
        }
        if (url.startsWith("jdbc:postgresql")) {
            return PostgreSQLDialect.class.getName();
        }
        if (url.startsWith("jdbc:mysql")) {
            return MySQL5Dialect.class.getName();
        }
        if (url.startsWith("jdbc:oracle")) {
            return Oracle10gDialect.class.getName();
        }
        throw new RuntimeException("Unable to determine database dialect from URL: " + url);
    }

    static {
        logger = LoggerFactory.getLogger(HibernateUtil.class);
        DEFAULT_EHCACHE_CONFIG = HibernateUtil.class.getClassLoader().getResource("edu/sc/seis/fissuresUtil/hibernate/ehcache.xml");
    }
}

