/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.hibernate;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.SiteIdUtil;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.bag.Rotate;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelGroup {
    protected int dbid;
    private ChannelImpl[] channels;
    private static final Logger logger = LoggerFactory.getLogger(ChannelGroup.class);

    public ChannelGroup(ChannelImpl[] channels) {
        assert (channels.length == 3);
        this.channels = channels;
    }

    protected ChannelGroup() {
    }

    protected void setDbid(int i) {
        this.dbid = i;
    }

    public int getDbid() {
        return this.dbid;
    }

    public ChannelImpl[] getChannels() {
        return this.channels;
    }

    public boolean contains(Channel c) {
        return this.getIndex(c) != -1;
    }

    public ChannelImpl getVertical() {
        for (int i = 0; i < this.channels.length; ++i) {
            if (this.channels[i].getOrientation().dip == -90.0f) {
                return this.channels[i];
            }
            if (this.channels[i].getOrientation().dip != 90.0f) continue;
            return this.channels[i];
        }
        return null;
    }

    public ChannelImpl[] getHorizontal() {
        int[] indices = this.getHorizontalIndices();
        ChannelImpl[] out = new ChannelImpl[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            out[i] = this.channels[indices[i]];
        }
        return out;
    }

    private int[] getHorizontalIndices() {
        int first = -1;
        for (int i = 0; i < this.channels.length; ++i) {
            if (this.channels[i].getOrientation().dip != 0.0f) continue;
            if (first == -1) {
                first = i;
                continue;
            }
            return new int[]{first, i};
        }
        if (first == -1) {
            return new int[0];
        }
        return new int[]{first};
    }

    public ChannelImpl[] getHorizontalXY() {
        ChannelImpl[] out = this.getHorizontal();
        if (out.length != 2) {
            out = new ChannelImpl[]{};
        } else if (!(Math.abs((360.0f + out[0].getOrientation().azimuth - out[1].getOrientation().azimuth) % 360.0f - 90.0f) < 2.0f)) {
            if (Math.abs((360.0f + out[1].getOrientation().azimuth - out[0].getOrientation().azimuth) % 360.0f - 90.0f) < 2.0f) {
                ChannelImpl tmp = out[0];
                out[0] = out[1];
                out[1] = tmp;
            } else {
                out = new ChannelImpl[]{};
            }
        }
        return out;
    }

    public ChannelImpl getChannel(ChannelId chanId, EventAccessOperations event) {
        for (int i = 0; i < this.channels.length; ++i) {
            if (!ChannelIdUtil.areEqual((ChannelId)chanId, (ChannelId)this.channels[i].get_id())) continue;
            return this.channels[i];
        }
        if (SiteIdUtil.areSameSite((ChannelId)chanId, (ChannelId)this.channels[0].get_id()) && chanId.channel_code.substring(0, 2).equals(this.channels[0].get_code().substring(0, 2))) {
            if (chanId.channel_code.endsWith("R")) {
                return this.getRadial(event);
            }
            if (chanId.channel_code.endsWith("T")) {
                return this.getTransverse(event);
            }
        }
        return null;
    }

    public void makeTransverseAndRadial(int transverseIndex, int radialIndex, EventAccessOperations event) {
        this.channels[radialIndex] = this.getRadial(event);
        this.channels[transverseIndex] = this.getTransverse(event);
    }

    public ChannelImpl getRadial(EventAccessOperations event) {
        return this.getRadial(EventUtil.extractOrigin(event).getLocation());
    }

    public ChannelImpl getRadial(Location eventLoc) {
        return new ChannelImpl(Rotate.replaceChannelOrientation(this.channels[0].get_id(), "R"), this.channels[0].getName() + "Radial", new Orientation((float)Rotate.getRadialAzimuth(this.channels[0].getSite().getLocation(), eventLoc), 0.0f), this.channels[0].getSamplingInfo(), this.channels[0].getEffectiveTime(), this.channels[0].getSite());
    }

    public ChannelImpl getTransverse(EventAccessOperations event) {
        return this.getTransverse(EventUtil.extractOrigin(event).getLocation());
    }

    public ChannelImpl getTransverse(Location eventLoc) {
        return new ChannelImpl(Rotate.replaceChannelOrientation(this.channels[0].get_id(), "T"), this.channels[0].getName() + "Transverse", new Orientation((float)Rotate.getTransverseAzimuth(this.channels[0].getSite().getLocation(), eventLoc), 0.0f), this.channels[0].getSamplingInfo(), this.channels[0].getEffectiveTime(), this.channels[0].getSite());
    }

    private int getIndex(Channel chan) {
        int i;
        for (i = 0; i < this.channels.length; ++i) {
            if (!this.channels[i].equals(chan)) continue;
            return i;
        }
        for (i = 0; i < this.channels.length; ++i) {
            if (!ChannelIdUtil.areEqual((ChannelId)this.channels[i].get_id(), (ChannelId)chan.get_id())) continue;
            return i;
        }
        return -1;
    }

    public ChannelImpl getChannel1() {
        return this.getChannels()[0];
    }

    public ChannelImpl getChannel2() {
        return this.getChannels()[1];
    }

    public ChannelImpl getChannel3() {
        return this.getChannels()[2];
    }

    public StationImpl getStation() {
        return this.getChannel1().getStationImpl();
    }

    public NetworkAttrImpl getNetworkAttr() {
        return this.getStation().getNetworkAttrImpl();
    }

    public boolean areEqual(ChannelGroup other) {
        ChannelImpl[] otherChans = other.getChannels();
        for (int i = 0; i < otherChans.length; ++i) {
            if (!ChannelIdUtil.areEqual((ChannelImpl)this.getChannel1(), (ChannelImpl)otherChans[i])) continue;
            for (int j = 0; j < otherChans.length; ++j) {
                if (j == i || !ChannelIdUtil.areEqual((ChannelImpl)this.getChannel2(), (ChannelImpl)otherChans[j])) continue;
                for (int k = 0; k < otherChans.length; ++k) {
                    if (k == i || k == i || !ChannelIdUtil.areEqual((ChannelImpl)this.getChannel3(), (ChannelImpl)otherChans[k])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void setChannel(int index, ChannelImpl chan) {
        if (this.channels == null) {
            this.channels = new ChannelImpl[3];
        }
        this.channels[index] = chan;
    }

    protected void setChannel1(ChannelImpl chan) {
        this.setChannel(0, chan);
    }

    protected void setChannel2(ChannelImpl chan) {
        this.setChannel(1, chan);
    }

    protected void setChannel3(ChannelImpl chan) {
        this.setChannel(2, chan);
    }
}

