/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.gmt;

import edu.sc.seis.fissuresUtil.bag.StreamPump;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericCommandExecute {
    private static Logger logger = LoggerFactory.getLogger(GenericCommandExecute.class);

    public static int execute(String command) throws InterruptedException, IOException {
        return GenericCommandExecute.execute(command, (Reader)new StringReader(""), System.out, System.err);
    }

    public static int execute(String command, Reader stdin, OutputStream stdout, OutputStream stderr) throws InterruptedException, IOException {
        return GenericCommandExecute.execute(command, stdin, new OutputStreamWriter(stdout), new OutputStreamWriter(stderr));
    }

    public static int execute(String command, Reader stdin, Writer stdout, Writer stderr) throws InterruptedException, IOException {
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(command);
        InputStreamReader reader = new InputStreamReader(proc.getInputStream());
        OutputStreamWriter inWriter = new OutputStreamWriter(proc.getOutputStream());
        InputStreamReader errReader = new InputStreamReader(proc.getErrorStream());
        StreamPump pump = new StreamPump(reader, stdout, false);
        pump.setName("stdout");
        pump.start();
        StreamPump errPump = new StreamPump(errReader, stderr, false);
        errPump.setName("stderr");
        errPump.start();
        StreamPump stdInPump = new StreamPump(stdin, inWriter, true);
        stdInPump.setName("stdin");
        stdInPump.start();
        int exitVal = proc.waitFor();
        try {
            pump.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            errPump.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            stdInPump.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!pump.hasCompleted() || !errPump.hasCompleted()) {
            throw new IllegalStateException("Pumps must complete: stdout:" + pump.hasCompleted() + "  stderr:" + errPump.hasCompleted() + "  exitValue:" + exitVal);
        }
        return exitVal;
    }

    public static void main(String[] args) {
        try {
            if (args.length > 0) {
                GenericCommandExecute.execute(args[0]);
            } else {
                GenericCommandExecute.execute("ls /bin");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

