/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.flow.tester.model;

import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeUtils;
import edu.sc.seis.fissuresUtil.flow.extractor.model.TimeExtractor;
import edu.sc.seis.fissuresUtil.flow.tester.Fail;
import edu.sc.seis.fissuresUtil.flow.tester.NoTestSubject;
import edu.sc.seis.fissuresUtil.flow.tester.Pass;
import edu.sc.seis.fissuresUtil.flow.tester.TestResult;
import edu.sc.seis.fissuresUtil.flow.tester.Tester;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;

public class TimeTester
implements Tester {
    private MicroSecondTimeRange range;
    private TimeExtractor extractor = new TimeExtractor();

    public TimeTester() {
        this(new MicroSecondTimeRange(new MicroSecondDate(0L), new MicroSecondDate(TimeUtils.future)));
    }

    public TimeTester(MicroSecondTimeRange range) {
        this.range = range;
    }

    public MicroSecondTimeRange getRange() {
        return this.range;
    }

    @Override
    public TestResult test(Object o) {
        Time t = this.extractor.extract(o);
        if (t == null) {
            return new NoTestSubject("No time found in " + o);
        }
        return this.test(t);
    }

    public TestResult test(Time t) {
        MicroSecondDate d = new MicroSecondDate(t);
        if (this.range.contains(new MicroSecondDate(t))) {
            return new Pass(d + " inside " + this.range);
        }
        return new Fail(d + " outside " + this.range);
    }
}

