/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.exceptionHandler;

import edu.sc.seis.fissuresUtil.exceptionHandler.MissingPropertyException;
import edu.sc.seis.fissuresUtil.exceptionHandler.Section;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultMailer {
    private Properties props;
    private static final Logger logger = LoggerFactory.getLogger(ResultMailer.class);
    public static final String SMTP = "mail.smtp.host";
    public static final String TO = "mail.to";
    public static final String FROM = "mail.from";
    public static final String SUBJECT = "mail.subject";

    public ResultMailer(Properties props) throws MissingPropertyException {
        this.props = props;
        this.checkProperties();
        logger.info("Exception mailer going to " + props.getProperty(TO) + " from " + props.getProperty(FROM) + " through " + props.getProperty(SMTP) + " created");
    }

    private void checkProperties() throws MissingPropertyException {
        this.checkProperty(SMTP);
        this.checkProperty(SUBJECT);
        this.checkProperty(TO);
        this.checkProperty(FROM);
    }

    private void checkProperty(String property) throws MissingPropertyException {
        if (this.props.getProperty(property) == null) {
            throw new MissingPropertyException("A system properties required by this class isn't set! " + property + " must be set");
        }
    }

    public void mail(String message, String bodyText, List sections) throws Exception {
        Session session = Session.getDefaultInstance((Properties)this.props, null);
        MimeMessage msg = new MimeMessage(session);
        InternetAddress addressFrom = new InternetAddress(this.props.getProperty(FROM));
        msg.setFrom((Address)addressFrom);
        InternetAddress addressTo = new InternetAddress(this.props.getProperty(TO));
        msg.setRecipient(Message.RecipientType.TO, (Address)addressTo);
        String subject = this.props.getProperty(SUBJECT) + " " + message;
        msg.setSubject(subject);
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setText(message + "\n" + bodyText);
        multipart.addBodyPart((BodyPart)bodyPart);
        Iterator it = sections.iterator();
        while (it.hasNext()) {
            multipart.addBodyPart(this.createAttachement((Section)it.next()));
        }
        msg.setContent((Multipart)multipart);
        Transport.send((Message)msg);
    }

    private BodyPart createAttachement(Section section) throws IOException, MessagingException {
        SectionDataSource source = new SectionDataSource(section);
        MimeBodyPart bp = new MimeBodyPart();
        bp.setDataHandler(new DataHandler((DataSource)source));
        bp.setFileName(section.getName() + ".txt");
        return bp;
    }

    class SectionDataSource
    implements DataSource {
        Section s;

        SectionDataSource(Section s) {
            this.s = s;
        }

        public String getContentType() {
            return "text/plain";
        }

        public InputStream getInputStream() throws IOException {
            return new StringBufferInputStream(this.s.getContents());
        }

        public String getName() {
            return this.s.getName();
        }

        public OutputStream getOutputStream() throws IOException {
            throw new RuntimeException("getOutputStream() not impl");
        }
    }
}

