/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.exceptionHandler;

import edu.sc.seis.fissuresUtil.exceptionHandler.ExceptionReporter;
import edu.sc.seis.fissuresUtil.exceptionHandler.ExceptionReporterUtils;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.exceptionHandler.MissingPropertyException;
import edu.sc.seis.fissuresUtil.exceptionHandler.ResultMailer;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailExceptionReporter
extends ResultMailer
implements ExceptionReporter {
    public static final String LIMIT = "mail.limit";
    private int numSent = 0;
    private int limit = Integer.MAX_VALUE;
    private static final Logger logger = LoggerFactory.getLogger(MailExceptionReporter.class);

    public MailExceptionReporter(Properties props) throws MissingPropertyException {
        super(props);
        if (props.containsKey(LIMIT)) {
            this.limit = Integer.parseInt(props.getProperty(LIMIT));
        }
    }

    @Override
    public void report(String message, Throwable e, List sections) throws Exception {
        if (this.numSent < this.limit) {
            ++this.numSent;
            this.mail(message, ExceptionReporterUtils.getTrace(e), sections);
        } else {
            logger.debug("Not sending an email since " + this.numSent + " have been sent and " + this.limit + " is the max number to send");
        }
    }

    public static void addMailExceptionReporter(Properties mailProps) {
        if (mailProps.containsKey("mail.smtp.host")) {
            try {
                GlobalExceptionHandler.add(new MailExceptionReporter(mailProps));
            }
            catch (MissingPropertyException e) {
                logger.debug("Not able to add a mail reporter.  This is only a problem if you specified one", (Throwable)e);
            }
        } else {
            logger.debug("Not trying to add a mail reporter since mail.smtp.host isn't set");
        }
    }
}

