/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.registrar;

import edu.iris.Fissures.model.UnitRangeImpl;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.registrar.AmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.AmpConfigData;
import edu.sc.seis.fissuresUtil.display.registrar.AmpEvent;
import edu.sc.seis.fissuresUtil.display.registrar.AmpListener;
import edu.sc.seis.fissuresUtil.display.registrar.BasicAmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.BasicAmpEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeEvent;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class IndividualizedAmpConfig
implements AmpConfig,
AmpListener {
    private AmpConfig wrapped;
    private Set listeners = new HashSet();

    public IndividualizedAmpConfig(AmpConfig wrapped) {
        this.wrapped = wrapped;
        wrapped.addListener(this);
    }

    public IndividualizedAmpConfig(AmpConfig wrapped, DataSetSeismogram[] seismos) {
        this.wrapped = wrapped;
        wrapped.addListener(this);
        this.add(seismos);
    }

    @Override
    public synchronized AmpEvent calculate() {
        ((BasicAmpConfig)this.wrapped).calculate();
        AmpConfigData[] ad = this.getAmpData();
        UnitRangeImpl[] amps = new UnitRangeImpl[ad.length];
        for (int i = 0; i < ad.length; ++i) {
            amps[i] = ad[i].getRange();
        }
        return new BasicAmpEvent(AmpConfigData.getSeismograms(ad), amps, DisplayUtils.ONE_RANGE);
    }

    @Override
    public void clear() {
        this.wrapped.clear();
    }

    @Override
    public void reset(DataSetSeismogram[] seismos) {
        this.wrapped.reset();
    }

    @Override
    public boolean contains(DataSetSeismogram seismo) {
        return this.wrapped.contains(seismo);
    }

    @Override
    public void add(DataSetSeismogram[] seismos) {
        this.wrapped.add(seismos);
    }

    @Override
    public void reset() {
        this.wrapped.reset();
    }

    @Override
    public void removeListener(AmpListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void updateTime(TimeEvent event) {
        this.wrapped.updateTime(event);
        this.fireAmpEvent();
    }

    @Override
    public void addListener(AmpListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void shaleAmp(double shift, double scale, DataSetSeismogram[] seismos) {
        this.wrapped.shaleAmp(shift, scale, seismos);
    }

    @Override
    public void remove(DataSetSeismogram[] seismos) {
        this.wrapped.remove(seismos);
    }

    @Override
    public void shaleAmp(double shift, double scale) {
        this.wrapped.shaleAmp(shift, scale);
    }

    @Override
    public UnitRangeImpl getAmp() {
        return this.wrapped.getAmp();
    }

    @Override
    public UnitRangeImpl getAmp(DataSetSeismogram seis) {
        return this.wrapped.getAmp(seis);
    }

    @Override
    public AmpConfigData getAmpData(DataSetSeismogram seis) {
        return this.wrapped.getAmpData(seis);
    }

    @Override
    public AmpConfigData[] getAmpData() {
        return this.wrapped.getAmpData();
    }

    @Override
    public void fireAmpEvent() {
        AmpEvent current = this.calculate();
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((AmpListener)it.next()).updateAmp(current);
        }
    }

    @Override
    public DataSetSeismogram[] getSeismograms() {
        return this.wrapped.getSeismograms();
    }

    @Override
    public void updateAmp(AmpEvent e) {
        this.fireAmpEvent();
    }
}

