/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.borders;

import edu.iris.Fissures.model.UnitRangeImpl;
import edu.sc.seis.fissuresUtil.display.RecordSectionDisplay;
import edu.sc.seis.fissuresUtil.display.borders.Border;
import edu.sc.seis.fissuresUtil.display.borders.NoTickBorder;
import edu.sc.seis.fissuresUtil.display.registrar.LayoutData;
import edu.sc.seis.fissuresUtil.display.registrar.LayoutEvent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Iterator;

public class TriangleBorder
extends NoTickBorder {
    private Color[] colors;
    public static final int TRIANGLE_WIDTH = 15;
    RecordSectionDisplay rsd;

    public TriangleBorder(RecordSectionDisplay rsd, int side, int order, Color[] colors) {
        super(side, order);
        this.labelTickLength = this.direction == 1 ? 1 : 25;
        this.fixSize();
        this.rsd = rsd;
        this.colors = colors;
    }

    @Override
    protected Border.BorderFormat createNoTickFormat() {
        return new TriangleFormat();
    }

    public static void drawTriangle(Graphics2D g2d, Color c) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        TriangleBorder.drawTriangle(g2d, c, 7, 7);
    }

    public static void drawTriangle(Graphics2D g2d, Color c, int centerX, int centerY) {
        g2d.setColor(c);
        int[][] triangle = TriangleBorder.makeTriangle(centerX, centerY);
        g2d.fillPolygon(triangle[0], triangle[1], 3);
        g2d.setColor(new Color(64, 44, 127));
        g2d.drawPolygon(triangle[0], triangle[1], 3);
    }

    private static int[][] makeTriangle(int centerX, int centerY) {
        int halfWidth = 7;
        int[] x = new int[]{centerX - halfWidth, centerX, centerX + halfWidth};
        int[] y = new int[]{centerY + halfWidth, centerY - halfWidth, centerY + halfWidth};
        return new int[][]{x, y};
    }

    private class TriangleFormat
    extends Border.BorderFormat {
        public TriangleFormat() {
            super(TriangleBorder.this, 0.0, 0);
        }

        @Override
        public String getMaxString() {
            return null;
        }

        @Override
        public String getLabel(double value) {
            return null;
        }

        @Override
        public void draw(UnitRangeImpl range, Graphics2D g2d) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            double size = this.getLimitingSize();
            LayoutEvent ev = TriangleBorder.this.rsd.getLayoutConfig().getLayout();
            Iterator it = ev.iterator();
            int i = 0;
            float[] firstPoint = this.getFirstPoint();
            while (it.hasNext()) {
                LayoutData cur = (LayoutData)it.next();
                float centerPoint = (float)((cur.getStart() + (cur.getEnd() - cur.getStart()) / 2.0) * size);
                float[] point = this.getNextPoint(centerPoint, firstPoint);
                if (TriangleBorder.this.side == 0) {
                    point[0] = point[0] - 10.0f;
                } else if (TriangleBorder.this.side == 1) {
                    point[0] = point[0] + 10.0f;
                } else if (TriangleBorder.this.side == 3) {
                    point[1] = point[1] + 25.0f;
                }
                TriangleBorder.drawTriangle(g2d, TriangleBorder.this.colors[i++ % TriangleBorder.this.colors.length], (int)point[0], (int)point[1] - 15);
            }
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            super.draw(range, g2d);
        }
    }
}

