/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;

class MyMouseListener
extends MouseAdapter {
    private JTextArea area;
    JPopupMenu popMenu;

    public MyMouseListener(JTextArea area) {
        this.area = area;
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.popMenu(me);
        } else if (this.popMenu != null) {
            this.popMenu.setVisible(false);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.popMenu(me);
        } else if (this.popMenu != null) {
            this.popMenu.setVisible(false);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.popMenu(me);
        } else if (this.popMenu != null) {
            this.popMenu.setVisible(false);
        }
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    private void popMenu(MouseEvent me) {
        this.popMenu = new JPopupMenu("clipboard");
        this.popMenu.add(new copyAction("copy"));
        this.popMenu.add(new cutAction("cut"));
        this.popMenu.add(new pasteAction("paste"));
        this.popMenu.show(me.getComponent(), me.getX(), me.getY());
    }

    private class pasteAction
    extends AbstractAction {
        public pasteAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Clipboard systemboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = systemboard.getContents(null);
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String data = new String();
                try {
                    data = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                }
                catch (Exception e) {
                    GlobalExceptionHandler.handle("Problem transfering data.", e);
                }
                int pos = MyMouseListener.this.area.getCaretPosition();
                MyMouseListener.this.area.insert(data, pos);
            }
        }
    }

    private class cutAction
    extends AbstractAction {
        public cutAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Clipboard systemboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection strSelection = new StringSelection(MyMouseListener.this.area.getSelectedText());
            int start = MyMouseListener.this.area.getSelectionStart();
            int end = MyMouseListener.this.area.getSelectionEnd();
            MyMouseListener.this.area.replaceRange("", start, end);
            systemboard.setContents(strSelection, strSelection);
        }
    }

    private class copyAction
    extends AbstractAction {
        public copyAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Clipboard systemboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection strSelection = new StringSelection(MyMouseListener.this.area.getSelectedText());
            systemboard.setContents(strSelection, strSelection);
        }
    }
}

