/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplayProvider;
import edu.sc.seis.fissuresUtil.display.SimplePlotUtil;
import edu.sc.seis.fissuresUtil.display.VerticalSeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.borders.AmpBorder;
import edu.sc.seis.fissuresUtil.display.borders.TimeBorder;
import edu.sc.seis.fissuresUtil.display.drawable.CurrentTimeFlag;
import edu.sc.seis.fissuresUtil.display.drawable.DisplayRemover;
import edu.sc.seis.fissuresUtil.display.drawable.Drawable;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableIterator;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableSeismogram;
import edu.sc.seis.fissuresUtil.display.drawable.Flag;
import edu.sc.seis.fissuresUtil.display.drawable.NamedDrawable;
import edu.sc.seis.fissuresUtil.display.drawable.Selection;
import edu.sc.seis.fissuresUtil.display.drawable.SoundPlay;
import edu.sc.seis.fissuresUtil.display.drawable.TimeAmpLabel;
import edu.sc.seis.fissuresUtil.display.registrar.AmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.AmpEvent;
import edu.sc.seis.fissuresUtil.display.registrar.AmpListener;
import edu.sc.seis.fissuresUtil.display.registrar.BasicTimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.IndividualizedAmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.RMeanAmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeListener;
import edu.sc.seis.fissuresUtil.freq.NamedFilter;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.StdAuxillaryDataNames;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.border.LineBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class BasicSeismogramDisplay
extends SeismogramDisplay
implements TimeListener,
AmpListener {
    private static List EMPTY_LIST = new ArrayList();
    public static final float PDF_SCALE = 8.0f;
    public static final int PREFERRED_HEIGHT = 150;
    public static final int PREFERRED_WIDTH = 250;
    private VerticalSeismogramDisplay parent;
    private LinkedList seismograms = new LinkedList();
    private LinkedList drawables = new LinkedList();
    private TimeConfig tc;
    private AmpConfig ac;
    private TimeEvent currentTimeEvent;
    private AmpEvent currentAmpEvent;
    private DataSetSeismogram[] seismogramArray;
    private CurrentTimeFlag currentTimeFlag = new CurrentTimeFlag();
    private Color color = Color.BLACK;
    private static Logger logger = LoggerFactory.getLogger((String)BasicSeismogramDisplay.class.getName());

    public BasicSeismogramDisplay() {
        this(new BasicTimeConfig(), new RMeanAmpConfig());
    }

    public BasicSeismogramDisplay(TimeConfig tc) {
        this(tc, new RMeanAmpConfig());
    }

    public BasicSeismogramDisplay(AmpConfig ac) {
        this(new BasicTimeConfig(), ac);
    }

    public BasicSeismogramDisplay(TimeConfig tc, AmpConfig ac) {
        this(tc, ac, null);
    }

    public BasicSeismogramDisplay(TimeConfig tc, AmpConfig ac, Color outlineColor) {
        if (outlineColor != null) {
            this.color = outlineColor;
            this.setBorder(new LineBorder(this.color));
        } else {
            this.setBorder(BorderFactory.createEtchedBorder());
        }
        this.add(new AmpBorder(this), 3);
        this.add(new TimeBorder(this), 1);
        this.add(new DisplayRemover(this));
        this.setTimeConfig(tc);
        this.setAmpConfig(ac);
    }

    @Override
    public SeismogramDisplayProvider createCenter() {
        PlotPainter pp = new PlotPainter();
        pp.addMouseListener(BasicSeismogramDisplay.getMouseForwarder());
        pp.addMouseMotionListener(BasicSeismogramDisplay.getMouseMotionForwarder());
        pp.setPreferredSize(new Dimension(250, 150));
        return pp;
    }

    @Override
    public void add(DataSetSeismogram[] seismos) {
        this.add(seismos, null);
    }

    public void add(DataSetSeismogram[] seismos, Color seisColor) {
        logger.debug("add seismo " + seismos.length + " name0=" + seismos[0].getName());
        for (int i = 0; i < seismos.length; ++i) {
            if (seismos[i] == null) continue;
            this.seismograms.add(seismos[i]);
            this.drawables.add(new DrawableSeismogram((SeismogramDisplay)this, seismos[i], seisColor));
            this.addDrawablesFromAuxData(seismos[i]);
        }
        Iterator e = activeFilters.iterator();
        while (e.hasNext()) {
            DisplayUtils.applyFilter((NamedFilter)e.next(), new DrawableIterator(DrawableSeismogram.class, this.drawables));
        }
        this.seismogramArray = null;
    }

    @Override
    public void remove(Drawable drawable) {
        this.drawables.remove(drawable);
    }

    @Override
    public void add(Drawable drawable) {
        if (!this.drawables.contains(drawable)) {
            this.drawables.add(drawable);
            if (this.hasConfiguredColors(drawable.getClass())) {
                drawable.setColor(this.getNextColor(drawable.getClass()));
            }
            this.repaint();
        }
    }

    @Override
    public DrawableIterator getDrawables(MouseEvent e) {
        return new DrawableIterator(Drawable.class, EMPTY_LIST);
    }

    @Override
    public DataSetSeismogram[] getSeismograms() {
        if (this.seismogramArray == null) {
            this.seismogramArray = this.seismograms.toArray(new DataSetSeismogram[this.seismograms.size()]);
        }
        return this.seismogramArray;
    }

    public List getSeismogramList() {
        return this.seismograms;
    }

    @Override
    public void reset() {
        this.tc.reset();
        this.ac.reset();
    }

    @Override
    public void reset(DataSetSeismogram[] seisToReset) {
        this.tc.reset(seisToReset);
        this.ac.reset(seisToReset);
    }

    public static MicroSecondDate getTime(int x, Insets insets, Dimension dim, MicroSecondTimeRange timeRange) {
        int insetsX = insets.right + insets.left;
        double xPercent = (double)(x - insets.left) / (dim.getWidth() - (double)insetsX);
        long beginTime = timeRange.getBeginTime().getMicroSecondTime();
        double interval = timeRange.getInterval().getValue();
        return new MicroSecondDate((long)((double)beginTime + interval * xPercent));
    }

    public VerticalSeismogramDisplay getParentDisplay() {
        return this.parent;
    }

    public void setParentDisplay(VerticalSeismogramDisplay disp) {
        this.parent = disp;
    }

    @Override
    public void updateAmp(AmpEvent event) {
        this.currentAmpEvent = event;
        this.repaint();
    }

    @Override
    public void setAmpConfig(AmpConfig ac) {
        if (this.ac != null) {
            this.ac.removeListener(this);
            this.tc.removeListener(this.ac);
            this.ac.remove(this.getSeismograms());
        }
        this.ac = ac;
        ac.addListener(this);
        this.tc.addListener(ac);
        ac.add(this.getSeismograms());
    }

    @Override
    public void setGlobalizedAmpConfig(AmpConfig ac) {
        this.setAmpConfig(ac);
    }

    @Override
    public void setIndividualizedAmpConfig(AmpConfig ac) {
        this.setAmpConfig(new IndividualizedAmpConfig(ac));
    }

    @Override
    public AmpConfig getAmpConfig() {
        return this.ac;
    }

    @Override
    public void updateTime(TimeEvent event) {
        this.currentTimeEvent = event;
        this.repaint();
    }

    @Override
    public void setTimeConfig(TimeConfig tc) {
        if (this.tc != null) {
            this.tc.removeListener(this);
            this.tc.removeListener(this.ac);
            this.tc.add(this.getSeismograms());
        }
        this.tc = tc;
        tc.addListener(this);
        tc.addListener(this.ac);
        tc.add(this.getSeismograms());
    }

    @Override
    public TimeConfig getTimeConfig() {
        return this.tc;
    }

    public MicroSecondTimeRange getTime() {
        return this.currentTimeEvent.getTime();
    }

    public MicroSecondDate getTime(int pixel) {
        return SimplePlotUtil.getValue(this.getWidth() - this.getInsets().left - this.getInsets().right, this.getTime().getBeginTime(), this.getTime().getEndTime(), pixel - this.getInsets().left);
    }

    public int getPixel(MicroSecondDate date) {
        return SimplePlotUtil.getPixel(this.getWidth() - this.getInsets().left - this.getInsets().right, this.getTime().getBeginTime(), this.getTime().getEndTime(), date);
    }

    @Override
    public DrawableIterator iterator(Class drawableClass) {
        return new DrawableIterator(drawableClass, this.drawables);
    }

    public TimeAmpLabel getTimeAmpLabel() {
        DrawableIterator pi = new DrawableIterator(TimeAmpLabel.class, this.drawables);
        return (TimeAmpLabel)pi.next();
    }

    public void clearSelections() {
        Iterator it = this.drawables.iterator();
        while (it.hasNext()) {
            Drawable current = (Drawable)it.next();
            if (!(current instanceof Selection)) continue;
            it.remove();
        }
        this.repaint();
    }

    public void addSelection(Selection newSelection) {
        if (!this.drawables.contains(newSelection)) {
            this.drawables.add(newSelection);
            this.repaint();
        }
    }

    @Override
    public void remove(Selection old) {
        if (this.drawables.remove(old)) {
            this.repaint();
        }
    }

    @Override
    public void print() {
        this.parent.print();
    }

    @Override
    public boolean contains(DataSetSeismogram seismo) {
        return this.seismograms.contains(seismo);
    }

    @Override
    public void clear() {
        this.remove();
    }

    @Override
    public void remove(DataSetSeismogram[] seismos) {
        for (int i = 0; i < seismos.length; ++i) {
            if (!this.seismograms.contains(seismos[i])) continue;
            this.seismograms.remove(seismos[i]);
            Iterator it = this.drawables.iterator();
            while (it.hasNext()) {
                Drawable current = (Drawable)it.next();
                if (!(current instanceof DrawableSeismogram) || ((DrawableSeismogram)current).getSeismogram() != seismos[i]) continue;
                it.remove();
                this.repaint();
            }
        }
        if (this.seismograms.size() == 0) {
            this.clear();
        }
        this.tc.remove(seismos);
        this.ac.remove(seismos);
    }

    public void remove() {
        this.parent.removeDisplay(this);
        this.destroy();
    }

    void destroy() {
        this.clearSelections();
        this.tc.removeListener(this);
        this.ac.removeListener(this);
        this.tc.remove(this.getSeismograms());
        this.ac.remove(this.getSeismograms());
    }

    public void drawSeismograms(Graphics2D g2, Dimension size) {
        g2.setColor(Color.WHITE);
        g2.fill(new Rectangle2D.Float(0.0f, 0.0f, size.width, size.height));
        g2.setFont(DisplayUtils.DEFAULT_FONT);
        FontMetrics fm = g2.getFontMetrics();
        Rectangle2D stringBounds = fm.getStringBounds("test", g2);
        Rectangle2D.Float topLeftFilled = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, (float)stringBounds.getHeight());
        for (int i = 0; i < this.drawables.size(); ++i) {
            Drawable current = (Drawable)this.drawables.get(i);
            Dimension drawSize = size;
            if (current instanceof DrawableSeismogram && this.isPDF()) {
                g2.scale(0.125, 0.125);
                drawSize = new Dimension(Math.round((float)size.width * 8.0f), Math.round((float)size.height * 8.0f));
            }
            current.draw(g2, drawSize, this.currentTimeEvent, this.currentAmpEvent);
            if (current instanceof DrawableSeismogram && this.isPDF()) {
                g2.scale(8.0, 8.0);
            }
            if (current instanceof TimeAmpLabel && !PRINTING) {
                TimeAmpLabel taPlotter = (TimeAmpLabel)current;
                g2.setFont(DisplayUtils.MONOSPACED_FONT);
                FontMetrics monoMetrics = g2.getFontMetrics();
                stringBounds = monoMetrics.getStringBounds(taPlotter.getText(), g2);
                taPlotter.drawName(g2, (int)((double)size.width - stringBounds.getWidth()), size.height - 3);
                g2.setFont(DisplayUtils.DEFAULT_FONT);
                continue;
            }
            if (!this.drawNamesForNamedDrawables || !(current instanceof NamedDrawable)) continue;
            Rectangle2D drawnSize = ((NamedDrawable)current).drawName(g2, 5, (int)((RectangularShape)topLeftFilled).getHeight());
            ((Rectangle2D)topLeftFilled).setRect(0.0, 0.0, drawnSize.getWidth(), ((RectangularShape)topLeftFilled).getHeight() + drawnSize.getHeight());
        }
        if (BasicSeismogramDisplay.getCurrentTimeFlag()) {
            this.currentTimeFlag.draw(g2, size, this.currentTimeEvent, this.currentAmpEvent);
        }
    }

    public void addSoundPlay() {
    }

    public void removeSoundPlay() {
        Iterator it = this.drawables.iterator();
        while (it.hasNext()) {
            Drawable current = (Drawable)it.next();
            if (!(current instanceof SoundPlay)) continue;
            it.remove();
        }
    }

    public void addDrawablesFromAuxData(DataSetSeismogram seis) {
        for (Object cur : seis.getAuxillaryDataKeys()) {
            if (!cur.toString().startsWith(StdAuxillaryDataNames.PICK_FLAG)) continue;
            logger.debug("aux data pick_flag: " + cur.toString());
            Element auxDatEl = (Element)seis.getAuxillaryData(cur);
            logger.debug(auxDatEl.getTagName());
            Flag flag = Flag.getFlagFromElement(auxDatEl);
            flag.setColor(Color.YELLOW);
            this.add(flag);
        }
    }

    public int countDrawables() {
        return this.drawables.size();
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setOutlineColor(Color c) {
        this.color = c;
        this.getCenter().setBorder(BorderFactory.createLineBorder(this.color));
        super.setOutlineColor(c);
    }

    private class PlotPainter
    extends SeismogramDisplayProvider {
        private PlotPainter() {
        }

        @Override
        public SeismogramDisplay provide() {
            return BasicSeismogramDisplay.this;
        }

        @Override
        public void paintComponent(Graphics g) {
            BasicSeismogramDisplay.this.drawSeismograms((Graphics2D)g, this.getSize());
        }
    }
}

