/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.util;

import edu.sc.seis.fissuresUtil.database.DBUtil;
import edu.sc.seis.fissuresUtil.database.JDBCTable;
import edu.sc.seis.fissuresUtil.database.util.SQLLoader;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableSetup {
    private static Set createdTables = new HashSet();
    public static final String TABLE_NAME = "tablename";
    private static final Logger logger = LoggerFactory.getLogger(TableSetup.class);

    public static void setup(JDBCTable table, String propFile) throws SQLException {
        TableSetup.setup(table.getTableName(), table.getConnection(), table, propFile);
    }

    public static void setup(String tableName, Connection conn, Object tableObj, String propFile) throws SQLException {
        TableSetup.setup(tableName, conn, tableObj, propFile, (Context)new VelocityContext());
    }

    public static void setup(String tableName, Connection conn, Object tableObj, String propFile, String[] subtableNames) throws SQLException {
        TableSetup.setup(tableName, conn, tableObj, propFile, (Context)new VelocityContext(), subtableNames);
    }

    public static void setup(String tableName, Connection conn, Object tableObj, String propFile, Context ctx) throws SQLException {
        TableSetup.setup(tableName, conn, tableObj, propFile, ctx, new String[0]);
    }

    public static void setup(String tableName, Connection conn, Object tableObj, String propFile, Context ctx, String[] subtableNames) throws SQLException {
        ctx.put(TABLE_NAME, (Object)tableName);
        SQLLoader sql = new SQLLoader(propFile, ctx);
        TableSetup.customSetup(tableName, conn, tableObj, sql, subtableNames);
    }

    public static void customSetup(String tablename, Connection conn, Object tableObj, SQLLoader statements) throws SQLException {
        TableSetup.customSetup(tablename, conn, tableObj, statements, new String[0]);
    }

    public static void customSetup(String tablename, Connection conn, Object tableObj, SQLLoader statements, String[] subtableNames) throws SQLException {
        if (!statements.getContext().containsKey((Object)TABLE_NAME)) {
            statements.getContext().put(TABLE_NAME, (Object)tablename);
        }
        TableSetup.createTable(tablename, conn, statements);
        for (int i = 0; i < subtableNames.length; ++i) {
            TableSetup.createTable(subtableNames[i], conn, statements);
        }
        TableSetup.createViews(tablename, conn, statements);
        TableSetup.prepareStatements(tablename, conn, tableObj, statements);
    }

    private static void createViews(String tablename, Connection conn, SQLLoader statements) throws SQLException {
        String views = statements.get(tablename + ".views");
        if (views != null) {
            StringTokenizer tok = new StringTokenizer(views, ",");
            while (tok.hasMoreElements()) {
                String viewName = tok.nextToken();
                TableSetup.createTableOrView(viewName, conn, statements);
            }
        }
    }

    private static void createTable(String tablename, Connection conn, SQLLoader statements) throws SQLException {
        TableSetup.createTableOrView(tablename, conn, statements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createTableOrView(String tablename, Connection conn, SQLLoader statements) throws SQLException {
        Set set = createdTables;
        synchronized (set) {
            if (createdTables.contains(tablename)) {
                return;
            }
            if (!DBUtil.tableExists(tablename, conn)) {
                String creationStmt = statements.get(tablename + ".create");
                if (creationStmt == null) {
                    throw new IllegalArgumentException("creation Statement, cannot be null: " + tablename + ".create");
                }
                try {
                    conn.createStatement().executeUpdate(creationStmt);
                    createdTables.add(tablename);
                }
                catch (SQLException e) {
                    logger.error("problem with table creation (" + tablename + ") statement: " + creationStmt, (Throwable)e);
                    SQLException sqle = new SQLException(e.getMessage() + " " + creationStmt);
                    sqle.setStackTrace(e.getStackTrace());
                    throw sqle;
                }
                TableSetup.createIndices(tablename, conn, statements);
            }
        }
    }

    public static void clearCreatedTableList() {
        createdTables.clear();
    }

    private static void createIndices(String tablename, Connection conn, SQLLoader statements) throws SQLException {
        String stmt = "";
        try {
            String[] propNames = statements.getNamesForPrefix(tablename + ".index");
            for (int i = 0; i < propNames.length; ++i) {
                stmt = statements.get(propNames[i]);
                conn.createStatement().executeUpdate(stmt);
            }
        }
        catch (SQLException e) {
            logger.error("problem statement: " + stmt);
            SQLException sqle = new SQLException(e.getMessage() + " " + stmt);
            sqle.setStackTrace(e.getStackTrace());
            throw sqle;
        }
    }

    private static void prepareStatements(String tableName, Connection conn, Object tableObj, SQLLoader statements) throws SQLException {
        Field[] fields = tableObj.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String key = tableName + "." + field.getName();
            if (!statements.has(key)) continue;
            String sql = statements.get(key);
            field.setAccessible(true);
            try {
                field.set(tableObj, conn.prepareStatement(sql));
                continue;
            }
            catch (IllegalArgumentException e) {
                GlobalExceptionHandler.handle("Thought this couldn't happen since I checked the object type.", e);
                continue;
            }
            catch (IllegalAccessException e) {
                GlobalExceptionHandler.handle("Thought this couldn't happen since I called setAccessible.  Looks like I was wrong", e);
            }
        }
    }
}

