/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.chooser;

import com.isti.util.IstiVersion;
import com.isti.util.updatechecker.LocationUpdate;
import com.isti.util.updatechecker.UpdateAction;
import com.isti.util.updatechecker.UpdateInformation;
import com.isti.util.updatechecker.XMLUpdateCheckerClient;
import com.isti.util.updatechecker.XMLUpdateCheckerServer;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.cache.AbstractJob;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCheckerJob
extends AbstractJob {
    protected final TimeInterval SIX_HOUR = new TimeInterval(6.0, UnitImpl.HOUR);
    protected final TimeInterval FORTNIGHT = new TimeInterval(14.0, UnitImpl.DAY);
    protected final TimeInterval MONTH = new TimeInterval(30.0, UnitImpl.DAY);
    protected String prefsName;
    protected String version;
    protected String programName;
    protected boolean forceCheck;
    protected boolean showNoUpdate = false;
    protected boolean isGui;
    static boolean checkedYet = false;
    protected String updateURL;
    protected Preferences prefs;
    protected boolean usePrefs = true;
    static final String NEXT_CHECK_DATE = "nextCheckDate";
    private static final Logger logger = LoggerFactory.getLogger(UpdateCheckerJob.class);

    public UpdateCheckerJob(String displayName, String programName, String version, String updateURL, boolean gui, boolean forceCheck) {
        super(displayName);
        this.programName = programName;
        this.updateURL = updateURL;
        this.isGui = gui;
        this.forceCheck = forceCheck;
        this.version = version;
        this.prefsName = programName + "_" + NEXT_CHECK_DATE;
    }

    public void setUsePreferencesForStorage(boolean usePrefs) {
        this.usePrefs = usePrefs;
    }

    @Override
    public void runJob() {
        block8: {
            if (!this.forceCheck && checkedYet) {
                this.setFinished();
                return;
            }
            checkedYet = true;
            boolean checkNeeded = true;
            java.util.logging.Logger prefsLogger = java.util.logging.Logger.getLogger("java.util.prefs");
            prefsLogger.setLevel(Level.OFF);
            MicroSecondDate now = ClockUtil.now();
            MicroSecondDate date = this.getNextCheck();
            if (date.after((Date)now) && !this.forceCheck) {
                logger.debug("no updated wanted until " + date);
                this.setFinished(true);
                return;
            }
            this.setStatus("Connect to server");
            Properties httpHeaders = new Properties();
            httpHeaders.put("User-Agent", this.programName + "-" + this.version);
            XMLUpdateCheckerClient updateChecker = new XMLUpdateCheckerClient(new IstiVersion(this.version), new XMLUpdateCheckerServer(this.updateURL, httpHeaders));
            this.setStatus("Check for update");
            if (updateChecker.isUpdateAvailable()) {
                UpdateInformation[] updates = updateChecker.getUpdates();
                logger.info("our version is " + this.version + ", update version is " + updates[updates.length - 1].getVersion());
                UpdateAction[] actions = updates[updates.length - 1].getUpdateActions();
                LocationUpdate locationUpdate = (LocationUpdate)actions[0];
                try {
                    if (this.isGui) {
                        this.handleUpdateGUI(locationUpdate);
                        break block8;
                    }
                    this.handleUpdateNonGUI(locationUpdate);
                }
                catch (BackingStoreException e) {
                    GlobalExceptionHandler.handle("trouble flushing preferences for updatechecker", e);
                }
            } else if (this.showNoUpdate) {
                JOptionPane.showMessageDialog(null, "No update is available", "Update Check", 1);
                logger.info("No update is available");
            }
        }
        this.setFinished();
    }

    protected void handleUpdateGUI(LocationUpdate locationUpdate) throws BackingStoreException {
        Object[] options = new String[]{"Go To Update Page", "Remind in a fortnight", "Remind in a month"};
        int n = JOptionPane.showOptionDialog(null, "An updated version of " + this.programName + " is available!\nPlease go to\n" + locationUpdate.getLocation() + "\nto get the latest version.", "An updated version of " + this.programName + " is available!", 0, 3, null, options, options[0]);
        logger.debug("return val is " + n);
        TimeInterval nextInterval = this.SIX_HOUR;
        if (n == 0) {
            logger.debug("Opening browser");
            this.setStatus("Opening browser");
            locationUpdate.run();
        } else if (n == 1) {
            nextInterval = this.FORTNIGHT;
        } else if (n == 2) {
            nextInterval = this.MONTH;
        }
        MicroSecondDate nextCheck = ClockUtil.now().add(nextInterval);
        this.setNextCheck(nextCheck);
        logger.debug("no update check wanted for " + nextInterval + ", next at " + nextCheck);
    }

    protected void handleUpdateNonGUI(LocationUpdate locationUpdate) throws BackingStoreException {
        System.err.println("*******************************************************");
        System.err.println();
        System.err.println("An updated version of " + this.programName + " is available!");
        System.err.println("Please go to " + locationUpdate.getLocation() + " to get the latest version.");
        System.err.println();
        System.err.println("*******************************************************");
        this.setNextCheck(ClockUtil.now().add(this.SIX_HOUR));
    }

    protected MicroSecondDate getNextCheck() {
        if (this.usePrefs) {
            MicroSecondDate now = ClockUtil.now();
            String nextCheckDate = this.getPrefs().get(this.prefsName, now.subtract((TimeInterval)this.SIX_HOUR).getFissuresTime().date_time);
            return new MicroSecondDate(new Time(nextCheckDate, -1));
        }
        return ClockUtil.now().subtract(this.SIX_HOUR);
    }

    protected void setNextCheck(MicroSecondDate date) throws BackingStoreException {
        if (this.usePrefs) {
            this.getPrefs().put(this.prefsName, date.getFissuresTime().date_time);
            this.getPrefs().flush();
        }
    }

    protected Preferences getPrefs() {
        if (this.prefs == null) {
            this.prefs = Preferences.userNodeForPackage(this.getClass()).node("UpdateCheckerTask");
        }
        return this.prefs;
    }
}

