/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.chooser;

import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.Station;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooser;
import edu.sc.seis.fissuresUtil.chooser.StationAcceptor;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StationLoader
extends Thread {
    private NetworkAccess[] nets;
    private ChannelChooser chooser;
    private LinkedList acceptors = new LinkedList();
    private static Logger logger = LoggerFactory.getLogger(StationLoader.class);

    public StationLoader(ChannelChooser chooser, NetworkAccess[] n) {
        this.chooser = chooser;
        this.nets = n;
    }

    public void addStationAcceptor(StationAcceptor acceptor) {
        this.acceptors.add(acceptor);
    }

    @Override
    public void run() {
        ArrayList<Station> stations = new ArrayList<Station>();
        this.chooser.setProgressOwner(this);
        this.chooser.setProgressMax(this, 100);
        try {
            int netProgressInc = 50 / this.nets.length;
            int progressValue = 10;
            this.chooser.setProgressValue(this, progressValue);
            for (int i = 0; i < this.nets.length; ++i) {
                int j;
                Station[] newStations = this.nets[i].retrieve_stations();
                for (j = 0; j < newStations.length; ++j) {
                    stations.add(newStations[j]);
                }
                logger.debug("got " + newStations.length + " stations from " + this.nets[i].get_attributes().get_code());
                this.chooser.setProgressValue(this, progressValue + netProgressInc / 2);
                for (j = 0; j < newStations.length; ++j) {
                    if (newStations[j].getName() == null || newStations[j].getName().length() < 3) {
                        newStations[j].setName(newStations[j].get_code());
                    }
                    this.chooser.setProgressValue(this, progressValue + netProgressInc / 2 - (newStations.length - j) / newStations.length);
                }
                this.chooser.setProgressValue(this, 100);
            }
        }
        catch (Throwable e) {
            GlobalExceptionHandler.handle("Unable to get stations.", e);
        }
        this.stationAdd(stations.toArray(new Station[stations.size()]));
    }

    protected boolean acceptStation(Station sta) {
        return true;
    }

    void stationAdd(Station[] s) {
        this.chooser.addStationsFromThread(s);
    }
}

