/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class WorkerThreadPool {
    private int totalNumCreated = 0;
    private int poolSize;
    private int maxQueueSize = 1000;
    private ThreadGroup tg;
    private LinkedList<Runnable> queue = new LinkedList();
    private Set<BackgroundWorker> idle = Collections.synchronizedSet(new HashSet());
    private static WorkerThreadPool defaultPool;
    public static final int DEFAULT_MAX_QUEUE_SIZE = 1000;

    public WorkerThreadPool(String name, int numThreads) {
        this(name, numThreads, 5);
    }

    public WorkerThreadPool(String name, int numThreads, int priority) {
        this.poolSize = numThreads;
        this.tg = new ThreadGroup(name);
        this.tg.setMaxPriority(priority);
        this.tg.setDaemon(true);
        this.fillPool();
    }

    public void setMaxQueueSize(int i) {
        if (i < 1) {
            throw new IllegalArgumentException("queue must be at least size 1 > " + i);
        }
        this.maxQueueSize = i;
    }

    public synchronized void invokeLater(Runnable runnable) {
        while (this.queue.size() > this.maxQueueSize) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.queue.contains(runnable)) {
            this.queue.addFirst(runnable);
        }
        this.fillPool();
        this.notifyAll();
    }

    private void fillPool() {
        int numNewThreads = this.poolSize - this.tg.activeCount();
        for (int i = 0; i < numNewThreads; ++i) {
            BackgroundWorker bw = new BackgroundWorker(this.tg, this.tg.getName() + " " + this.totalNumCreated++, this.tg.getMaxPriority());
            this.idle.add(bw);
            bw.start();
        }
    }

    public static synchronized WorkerThreadPool getDefaultPool() {
        if (defaultPool == null) {
            defaultPool = new WorkerThreadPool("default workers", 2);
        }
        return defaultPool;
    }

    private synchronized Runnable getFromQueue() throws InterruptedException {
        while (this.queue.isEmpty()) {
            this.wait();
        }
        this.idle.remove(Thread.currentThread());
        Runnable r = this.queue.removeLast();
        this.notifyAll();
        return r;
    }

    public synchronized int getNumWaiting() {
        return this.queue.size();
    }

    public int getNumIdle() {
        return this.idle.size();
    }

    public synchronized boolean isEmployed() {
        return this.getNumWaiting() != 0 || this.getNumIdle() < this.poolSize;
    }

    private class BackgroundWorker
    extends Thread {
        protected BackgroundWorker(ThreadGroup group, String name, int priority) {
            super(group, name);
            this.setPriority(priority);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    WorkerThreadPool.this.getFromQueue().run();
                    continue;
                }
                catch (Throwable e) {
                    GlobalExceptionHandler.handle(e);
                    continue;
                }
                finally {
                    WorkerThreadPool.this.idle.add(this);
                    continue;
                }
                break;
            }
        }
    }
}

