/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.DataCenterCallBack;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Time;
import edu.sc.seis.fissuresUtil.cache.AbstractProxySeismogramDC;
import edu.sc.seis.fissuresUtil.cache.ClassicRetryStrategy;
import edu.sc.seis.fissuresUtil.cache.NSSeismogramDC;
import edu.sc.seis.fissuresUtil.cache.ProxySeismogramDC;
import edu.sc.seis.fissuresUtil.cache.RetryStrategy;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.omg.CORBA.SystemException;

public class RetrySeismogramDC
extends AbstractProxySeismogramDC {
    private static transient boolean insideReset = false;
    private static int numSeisDCsAdded = 0;
    private static Set<SoftReference<ProxySeismogramDC>> allKnownDCs = new HashSet<SoftReference<ProxySeismogramDC>>();
    private RetryStrategy strat;

    public RetrySeismogramDC(NSSeismogramDC dc, int retry) {
        this(dc, new ClassicRetryStrategy(retry));
    }

    public RetrySeismogramDC(NSSeismogramDC dc, RetryStrategy strat) {
        super(dc);
        this.strat = strat;
        RetrySeismogramDC.addKnownSeisDC(this);
    }

    public RequestFilter[] available_data(RequestFilter[] a_filterseq) {
        SystemException latest;
        int count = 0;
        try {
            return this.getWrappedDC().available_data(a_filterseq);
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.strat.shouldRetry(latest, this, count++)) {
            try {
                RequestFilter[] result = this.getWrappedDC().available_data(a_filterseq);
                this.strat.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    public void cancel_request(String a_request) throws FissuresException {
        SystemException latest;
        int count = 0;
        try {
            this.getWrappedDC().cancel_request(a_request);
            return;
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.strat.shouldRetry(latest, this, count++)) {
            try {
                this.getWrappedDC().cancel_request(a_request);
                this.strat.serverRecovered(this);
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    public String queue_seismograms(RequestFilter[] a_filterseq) throws FissuresException {
        SystemException latest;
        int count = 0;
        try {
            return this.getWrappedDC().queue_seismograms(a_filterseq);
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.strat.shouldRetry(latest, this, count++)) {
            try {
                String result = this.getWrappedDC().queue_seismograms(a_filterseq);
                this.strat.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    public String request_seismograms(RequestFilter[] a_filterseq, DataCenterCallBack a_client, boolean long_lived, Time expiration_time) throws FissuresException {
        SystemException latest;
        int count = 0;
        try {
            return this.getWrappedDC().request_seismograms(a_filterseq, a_client, long_lived, expiration_time);
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.strat.shouldRetry(latest, this, count++)) {
            try {
                String result = this.getWrappedDC().request_seismograms(a_filterseq, a_client, long_lived, expiration_time);
                this.strat.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    public String request_status(String a_request) throws FissuresException {
        SystemException latest;
        int count = 0;
        try {
            return this.getWrappedDC().request_status(a_request);
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.strat.shouldRetry(latest, this, count++)) {
            try {
                String result = this.getWrappedDC().request_status(a_request);
                this.strat.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    public LocalSeismogram[] retrieve_queue(String a_request) throws FissuresException {
        SystemException latest;
        int count = 0;
        try {
            return this.getWrappedDC().retrieve_queue(a_request);
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.strat.shouldRetry(latest, this, count++)) {
            try {
                LocalSeismogram[] result = this.getWrappedDC().retrieve_queue(a_request);
                this.strat.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    public LocalSeismogram[] retrieve_seismograms(RequestFilter[] a_filterseq) throws FissuresException {
        SystemException latest;
        int count = 0;
        try {
            return this.getWrappedDC().retrieve_seismograms(a_filterseq);
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.strat.shouldRetry(latest, this, count++)) {
            try {
                LocalSeismogram[] result = this.getWrappedDC().retrieve_seismograms(a_filterseq);
                this.strat.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Class<RetrySeismogramDC> clazz = RetrySeismogramDC.class;
        synchronized (RetrySeismogramDC.class) {
            super.reset();
            if (!insideReset) {
                insideReset = true;
                HashSet<SoftReference<ProxySeismogramDC>> allKnowDCsCopy = new HashSet<SoftReference<ProxySeismogramDC>>();
                allKnowDCsCopy.addAll(allKnownDCs);
                Iterator it = allKnowDCsCopy.iterator();
                while (it.hasNext()) {
                    SoftReference dcref = (SoftReference)it.next();
                    ProxySeismogramDC dc = (ProxySeismogramDC)dcref.get();
                    if (dc != null) {
                        dc.reset();
                        continue;
                    }
                    it.remove();
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                insideReset = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void addKnownSeisDC(ProxySeismogramDC cache) {
        Class<RetrySeismogramDC> clazz = RetrySeismogramDC.class;
        synchronized (RetrySeismogramDC.class) {
            allKnownDCs.add(new SoftReference<ProxySeismogramDC>(cache));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (++numSeisDCsAdded % 1000 != 0) return;
            clazz = RetrySeismogramDC.class;
            synchronized (RetrySeismogramDC.class) {
                Iterator<SoftReference<ProxySeismogramDC>> it = allKnownDCs.iterator();
                while (it.hasNext()) {
                    SoftReference<ProxySeismogramDC> net = it.next();
                    if (net.get() != null) continue;
                    it.remove();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    public String toString() {
        return "Retry " + this.getWrappedDC().toString();
    }
}

