/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.IfNetwork.NetworkDCOperations;
import edu.iris.Fissures.IfNetwork.NetworkExplorer;
import edu.iris.Fissures.IfNetwork.NetworkFinder;
import edu.sc.seis.fissuresUtil.cache.AbstractProxyNetworkDC;
import edu.sc.seis.fissuresUtil.cache.ClassicRetryStrategy;
import edu.sc.seis.fissuresUtil.cache.RetryStrategy;
import org.omg.CORBA.SystemException;

public class RetryNetworkDC
extends AbstractProxyNetworkDC {
    private RetryStrategy handler;
    private int retry;

    public RetryNetworkDC(NetworkDCOperations netDC, int retry) {
        this(netDC, new ClassicRetryStrategy(retry));
    }

    public RetryNetworkDC(NetworkDCOperations netDC, RetryStrategy handler) {
        super(netDC);
        this.handler = handler;
    }

    public int getNumRetry() {
        return this.retry;
    }

    @Override
    public NetworkExplorer a_explorer() {
        SystemException latest;
        int count = 0;
        try {
            return this.netDC.a_explorer();
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.handler.shouldRetry(latest, this, count++)) {
            try {
                NetworkExplorer result = this.netDC.a_explorer();
                this.handler.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    public NetworkFinder a_finder() {
        SystemException latest;
        int count = 0;
        try {
            return this.netDC.a_finder();
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.handler.shouldRetry(latest, this, count++)) {
            try {
                NetworkFinder result = this.netDC.a_finder();
                this.handler.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }
}

