/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.DataCenter;
import edu.iris.Fissures.IfSeismogramDC.DataCenterCallBack;
import edu.iris.Fissures.IfSeismogramDC.DataCenterOperations;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Time;
import edu.sc.seis.fissuresUtil.cache.ProxySeismogramDC;
import edu.sc.seis.fissuresUtil.cache.ServerNameDNS;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSeismogramDC
implements ServerNameDNS,
ProxySeismogramDC {
    protected String serverDNS;
    protected String serverName;
    private ThreadLocal<DataCenter> dc = new ThreadLocal();
    protected FissuresNamingService nameService;
    private static final Logger logger = LoggerFactory.getLogger(NSSeismogramDC.class);

    public NSSeismogramDC(String serverDNS, String serverName, FissuresNamingService fissuresNamingService) {
        this.serverDNS = serverDNS;
        this.serverName = serverName;
        this.nameService = fissuresNamingService;
    }

    @Override
    public DataCenterOperations getWrappedDC() {
        return this.getDataCenter();
    }

    @Override
    public DataCenterOperations getWrappedDC(Class wrappedClass) {
        if (wrappedClass.equals(this.getClass())) {
            return this;
        }
        if (wrappedClass.equals(DataCenter.class)) {
            return this.getDataCenter();
        }
        throw new IllegalArgumentException("NSSeismogramDCs only contain DataCenters, so it can't contain a ProxyDC of class " + wrappedClass);
    }

    @Override
    public String getServerDNS() {
        return this.serverDNS;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public String getFullName() {
        return this.getServerDNS() + "/" + this.getServerName();
    }

    @Override
    public String getServerType() {
        return "SeismogramDC";
    }

    @Override
    public synchronized void reset() {
        if (this.dc.get() != null) {
            this.dc.get()._release();
        }
        this.dc.set(null);
    }

    @Override
    public Object getCorbaObject() {
        return this.getDataCenter();
    }

    public synchronized DataCenter getDataCenter() {
        if (this.dc.get() == null) {
            try {
                try {
                    this.dc.set(this.nameService.getSeismogramDC(this.serverDNS, this.serverName));
                }
                catch (Throwable t) {
                    this.nameService.reset();
                    this.dc.set(this.nameService.getSeismogramDC(this.serverDNS, this.serverName));
                }
            }
            catch (NotFound e) {
                this.repackageException((UserException)((java.lang.Object)e));
            }
            catch (CannotProceed e) {
                this.repackageException((UserException)((java.lang.Object)e));
            }
            catch (InvalidName e) {
                this.repackageException((UserException)((java.lang.Object)e));
            }
        }
        return this.dc.get();
    }

    protected void repackageException(UserException e) {
        String msg = "Unable to resolve " + this.getServerPath() + " " + e.toString();
        TRANSIENT t = new TRANSIENT(msg, 0, CompletionStatus.COMPLETED_NO);
        t.initCause((Throwable)e);
        throw t;
    }

    public String queue_seismograms(RequestFilter[] a_filterseq) throws FissuresException {
        try {
            return this.getDataCenter().queue_seismograms(a_filterseq);
        }
        catch (Throwable e) {
            this.reset();
            try {
                return this.getDataCenter().queue_seismograms(a_filterseq);
            }
            catch (RuntimeException ee) {
                this.reset();
                throw ee;
            }
        }
    }

    public LocalSeismogram[] retrieve_queue(String a_request) throws FissuresException {
        try {
            return this.getDataCenter().retrieve_queue(a_request);
        }
        catch (Throwable e) {
            this.reset();
            try {
                return this.getDataCenter().retrieve_queue(a_request);
            }
            catch (RuntimeException ee) {
                this.reset();
                throw ee;
            }
        }
    }

    public RequestFilter[] available_data(RequestFilter[] a_filterseq) {
        try {
            return this.getDataCenter().available_data(a_filterseq);
        }
        catch (Throwable e) {
            this.reset();
            try {
                return this.getDataCenter().available_data(a_filterseq);
            }
            catch (RuntimeException ee) {
                this.reset();
                throw ee;
            }
        }
    }

    public void cancel_request(String a_request) throws FissuresException {
        try {
            this.getDataCenter().cancel_request(a_request);
        }
        catch (Throwable e) {
            this.reset();
            try {
                this.getDataCenter().cancel_request(a_request);
            }
            catch (RuntimeException ee) {
                this.reset();
                throw ee;
            }
        }
    }

    public String request_seismograms(RequestFilter[] a_filterseq, DataCenterCallBack a_client, boolean long_lived, Time expiration_time) throws FissuresException {
        try {
            return this.getDataCenter().request_seismograms(a_filterseq, a_client, long_lived, expiration_time);
        }
        catch (Throwable e) {
            this.reset();
            try {
                return this.getDataCenter().request_seismograms(a_filterseq, a_client, long_lived, expiration_time);
            }
            catch (RuntimeException ee) {
                this.reset();
                throw ee;
            }
        }
    }

    public String request_status(String a_request) throws FissuresException {
        try {
            return this.getDataCenter().request_status(a_request);
        }
        catch (Throwable e) {
            this.reset();
            try {
                return this.getDataCenter().request_status(a_request);
            }
            catch (RuntimeException ee) {
                this.reset();
                throw ee;
            }
        }
    }

    public LocalSeismogram[] retrieve_seismograms(RequestFilter[] a_filterseq) throws FissuresException {
        try {
            return this.getDataCenter().retrieve_seismograms(a_filterseq);
        }
        catch (FissuresException e) {
            e.the_error.error_description = "[" + this.getServerDNS() + "/" + this.getServerName() + "]" + e.the_error.error_description;
            throw e;
        }
        catch (Throwable e) {
            this.reset();
            try {
                return this.getDataCenter().retrieve_seismograms(a_filterseq);
            }
            catch (RuntimeException ee) {
                this.reset();
                throw ee;
            }
        }
    }

    public String toString() {
        return "NSSeismogramDC " + this.getServerPath();
    }

    private String getServerPath() {
        return this.serverDNS + "/" + this.serverName;
    }
}

