/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.Dimension;
import edu.iris.Fissures.IfEvent.EventAccess;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfPlottable.PlottableDC;
import edu.iris.Fissures.IfPlottable.PlottableDCOperations;
import edu.iris.Fissures.IfPlottable.PlottableNotAvailable;
import edu.iris.Fissures.IfPlottable.UnsupportedDimension;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.NotImplemented;
import edu.iris.Fissures.Plottable;
import edu.sc.seis.fissuresUtil.cache.ProxyPlottableDC;
import edu.sc.seis.fissuresUtil.cache.ServerNameDNS;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSPlottableDC
implements ServerNameDNS,
ProxyPlottableDC {
    protected ThreadLocal<PlottableDC> plottableDC = new ThreadLocal();
    protected String serverDNS;
    protected String serverName;
    protected FissuresNamingService namingService;
    private static Logger logger = LoggerFactory.getLogger(NSPlottableDC.class);

    public NSPlottableDC(String serverDNS, String serverName, FissuresNamingService fissuresNamingService) {
        this.serverDNS = serverDNS;
        this.serverName = serverName;
        this.namingService = fissuresNamingService;
    }

    @Override
    public String getServerDNS() {
        return this.serverDNS;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public String getFullName() {
        return this.getServerDNS() + "/" + this.getServerName();
    }

    @Override
    public String getServerType() {
        return "PlottableDC";
    }

    @Override
    public synchronized void reset() {
        if (this.plottableDC.get() != null) {
            this.plottableDC.get()._release();
        }
        this.plottableDC.set(null);
    }

    public Object getRealCorbaObject() {
        return this.getCorbaObject();
    }

    @Override
    public synchronized PlottableDC getCorbaObject() {
        return this.getPlottableDC();
    }

    public synchronized PlottableDC getPlottableDC() {
        if (this.plottableDC.get() == null) {
            try {
                try {
                    this.plottableDC.set(this.namingService.getPlottableDC(this.serverDNS, this.serverName));
                }
                catch (Throwable t) {
                    this.namingService.reset();
                    this.plottableDC.set(this.namingService.getPlottableDC(this.serverDNS, this.serverName));
                }
            }
            catch (NotFound e) {
                throw new TRANSIENT("Unable to resolve " + this.serverName + " " + this.serverDNS + " " + e.toString(), 0, CompletionStatus.COMPLETED_NO);
            }
            catch (CannotProceed e) {
                throw new TRANSIENT("Unable to resolve " + this.serverName + " " + this.serverDNS + " " + e.toString(), 0, CompletionStatus.COMPLETED_NO);
            }
            catch (InvalidName e) {
                throw new TRANSIENT("Unable to resolve " + this.serverName + " " + this.serverDNS + " " + e.toString(), 0, CompletionStatus.COMPLETED_NO);
            }
        }
        return this.plottableDC.get();
    }

    public Dimension[] get_whole_day_sizes() {
        try {
            return this.getPlottableDC().get_whole_day_sizes();
        }
        catch (Throwable e) {
            logger.warn("Exception in get_whole_day_sizes(), regetting from nameservice to try again.", e);
            this.reset();
            return this.getPlottableDC().get_whole_day_sizes();
        }
    }

    public Dimension[] get_event_sizes() {
        try {
            return this.getPlottableDC().get_event_sizes();
        }
        catch (Throwable e) {
            logger.warn("Exception in get_event_sizes(), regetting from nameservice to try again.", e);
            this.reset();
            return this.getPlottableDC().get_event_sizes();
        }
    }

    public Plottable[] get_for_day(ChannelId chan, int year, int jday, Dimension dim) throws PlottableNotAvailable, UnsupportedDimension {
        try {
            return this.getPlottableDC().get_for_day(chan, year, jday, dim);
        }
        catch (Throwable e) {
            logger.warn("Exception in get_for_day(), regetting from nameservice to try again.", e);
            this.reset();
            return this.getPlottableDC().get_for_day(chan, year, jday, dim);
        }
    }

    public boolean custom_sizes() {
        try {
            return this.getPlottableDC().custom_sizes();
        }
        catch (Throwable e) {
            logger.warn("Exception in custom_sizes(), regetting from nameservice to try again.", e);
            this.reset();
            return this.getPlottableDC().custom_sizes();
        }
    }

    public Plottable[] get_for_event(EventAccess event, ChannelId chan, Dimension dim) throws PlottableNotAvailable, UnsupportedDimension {
        try {
            return this.getPlottableDC().get_for_event(event, chan, dim);
        }
        catch (Throwable e) {
            logger.warn("Exception in get_for_event(), regetting from nameservice to try again.", e);
            this.reset();
            return this.getPlottableDC().get_for_event(event, chan, dim);
        }
    }

    public Plottable[] get_plottable(RequestFilter rf, Dimension dim) throws PlottableNotAvailable, UnsupportedDimension, NotImplemented {
        try {
            return this.getPlottableDC().get_plottable(rf, dim);
        }
        catch (Throwable e) {
            logger.warn("Exception in get_plottable(), regetting from nameservice to try again.", e);
            this.reset();
            return this.getPlottableDC().get_plottable(rf, dim);
        }
    }

    @Override
    public PlottableDCOperations getWrappedDC() {
        return this.getPlottableDC();
    }

    @Override
    public PlottableDCOperations getWrappedDC(Class wrappedClass) {
        if (wrappedClass.equals(PlottableDC.class)) {
            return this.getCorbaObject();
        }
        throw new IllegalArgumentException("NSPlottableDCs only contain PlottableDCs, so it can't contain a ProxyDC of class " + wrappedClass);
    }
}

