/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.IfEvent.EventChannelFinder;
import edu.iris.Fissures.IfEvent.EventDC;
import edu.iris.Fissures.IfEvent.EventDCOperations;
import edu.iris.Fissures.IfEvent.EventFinder;
import edu.sc.seis.fissuresUtil.cache.ProxyEventDC;
import edu.sc.seis.fissuresUtil.cache.ServerNameDNS;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class NSEventDC
extends ProxyEventDC
implements ServerNameDNS {
    protected String serverDNS;
    protected String serverName;
    protected FissuresNamingService namingService;
    protected ThreadLocal threadEventDC = new ThreadLocal();

    public NSEventDC(String serverDNS, String serverName, FissuresNamingService fissuresNamingService) {
        this.serverDNS = serverDNS;
        this.serverName = serverName;
        this.namingService = fissuresNamingService;
    }

    @Override
    public String getServerDNS() {
        return this.serverDNS;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public synchronized void reset() {
        if (this.threadEventDC.get() != null) {
            ((Object)this.threadEventDC.get())._release();
        }
        this.threadEventDC.set(null);
    }

    @Override
    public EventDCOperations getEventDC() {
        return (EventDC)this.getCorbaObject();
    }

    @Override
    public void setEventDC(EventDCOperations eventDC) {
        this.threadEventDC.set(eventDC);
    }

    @Override
    public synchronized Object getCorbaObject() {
        if (this.threadEventDC.get() == null) {
            try {
                try {
                    this.loadEventDC();
                }
                catch (Throwable t) {
                    this.namingService.reset();
                    this.loadEventDC();
                }
            }
            catch (NotFound e) {
                this.repackageException((UserException)((java.lang.Object)e));
            }
            catch (CannotProceed e) {
                this.repackageException((UserException)((java.lang.Object)e));
            }
            catch (InvalidName e) {
                this.repackageException((UserException)((java.lang.Object)e));
            }
        }
        return (Object)this.threadEventDC.get();
    }

    private void loadEventDC() throws NotFound, CannotProceed, InvalidName {
        this.setEventDC((EventDCOperations)this.namingService.getEventDC(this.serverDNS, this.serverName));
    }

    protected void repackageException(UserException e) {
        String msg = "Unable to resolve " + this.serverName + " " + this.serverDNS + " " + e.toString();
        TRANSIENT t = new TRANSIENT(msg, 0, CompletionStatus.COMPLETED_NO);
        t.initCause((Throwable)e);
        throw t;
    }

    public EventChannelFinder a_channel_finder() {
        try {
            return this.getEventDC().a_channel_finder();
        }
        catch (Throwable e) {
            this.reset();
            try {
                return this.getEventDC().a_channel_finder();
            }
            catch (RuntimeException ee) {
                this.reset();
                throw ee;
            }
        }
    }

    public EventFinder a_finder() {
        try {
            return this.getEventDC().a_finder();
        }
        catch (Throwable e) {
            this.reset();
            try {
                return this.getEventDC().a_finder();
            }
            catch (RuntimeException ee) {
                this.reset();
                throw ee;
            }
        }
    }
}

