/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.network.StationIdUtil;
import edu.sc.seis.fissuresUtil.cache.CacheNetworkAccess;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class FilterNetworkAccess
extends CacheNetworkAccess {
    private Pattern[] patterns;

    public FilterNetworkAccess(NetworkAccess na, Pattern[] patterns) {
        super(na);
        this.patterns = patterns;
    }

    public static String getStationString(StationId s) {
        return StationIdUtil.toStringNoDates((StationId)s);
    }

    @Override
    public Station[] retrieve_stations() {
        Station[] stations = super.retrieve_stations();
        ArrayList<Station> acceptableStations = new ArrayList<Station>();
        block0: for (int i = 0; i < stations.length; ++i) {
            String netAndStaCode = FilterNetworkAccess.getStationString(stations[i].get_id());
            for (int j = 0; j < this.patterns.length; ++j) {
                if (!this.patterns[j].matcher(netAndStaCode).matches()) continue;
                acceptableStations.add(stations[i]);
                continue block0;
            }
        }
        return acceptableStations.toArray(new Station[0]);
    }
}

