/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.Sensitivity;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.ChannelSeismogram;
import edu.sc.seis.fissuresUtil.bag.FlippedChannel;
import edu.sc.seis.fissuresUtil.bag.NegativeSensitivity;
import edu.sc.seis.fissuresUtil.bag.OrientationUtil;

public class PolarityCheck {
    public static boolean check(ChannelImpl chan, LocalSeismogramImpl seis, Sensitivity sensitivity) throws FissuresException {
        return FlippedChannel.check((Channel)chan) && NegativeSensitivity.check(sensitivity);
    }

    public static ChannelSeismogram correct(ChannelImpl chan, LocalSeismogramImpl seis, Sensitivity sensitivity) throws FissuresException {
        if (NegativeSensitivity.check(sensitivity) && FlippedChannel.check((Channel)chan)) {
            return new ChannelSeismogram(OrientationUtil.flip((Channel)chan), (LocalSeismogram)seis, new Sensitivity(-1.0f * sensitivity.sensitivity_factor, sensitivity.frequency));
        }
        if (NegativeSensitivity.check(sensitivity)) {
            return NegativeSensitivity.correct(chan, seis, sensitivity);
        }
        if (FlippedChannel.check((Channel)chan)) {
            return FlippedChannel.correct(chan, seis, sensitivity);
        }
        return new ChannelSeismogram(chan, (LocalSeismogram)seis, sensitivity);
    }
}

