/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.OrientationRange;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.TauP.SphericalCoords;
import java.util.ArrayList;
import java.util.List;

public class OrientationUtil {
    public static List<ChannelImpl> inOrientation(OrientationRange orient, List<ChannelImpl> chans) {
        double degDist = QuantityImpl.createQuantityImpl((Quantity)orient.angular_distance).convertTo((UnitImpl)UnitImpl.DEGREE).value;
        ArrayList<ChannelImpl> results = new ArrayList<ChannelImpl>();
        for (ChannelImpl chan : chans) {
            Orientation chanOrient = chan.getOrientation();
            double dist = OrientationUtil.angleBetween(orient.center, chanOrient);
            if (!(dist <= degDist)) continue;
            results.add(chan);
        }
        return results;
    }

    public static boolean areEqual(Orientation one, Orientation two) {
        return one.azimuth == two.azimuth && one.dip == two.dip;
    }

    public static boolean areOrthogonal(Orientation one, Orientation two) {
        return OrientationUtil.areOrthogonal(one, two, 1.0E-4);
    }

    public static boolean areOrthogonal(Orientation one, Orientation two, double tol) {
        double dist = OrientationUtil.angleBetween(one, two);
        return Math.abs(dist - 90.0) < tol;
    }

    public static double angleBetween(Orientation one, Orientation two) {
        return SphericalCoords.distance((double)one.dip, (double)one.azimuth, (double)two.dip, (double)two.azimuth);
    }

    public static Orientation getUp() {
        return new Orientation(0.0f, -90.0f);
    }

    public static Orientation getNorth() {
        return new Orientation(0.0f, 0.0f);
    }

    public static Orientation getEast() {
        return new Orientation(90.0f, 0.0f);
    }

    public static Orientation flip(Orientation orient) {
        return new Orientation(-1.0f * orient.dip, (orient.azimuth + 180.0f) % 360.0f);
    }

    public static ChannelImpl flip(Channel chan) {
        return new ChannelImpl(chan.get_id(), chan.getName(), OrientationUtil.flip(chan.getOrientation()), chan.getSamplingInfo(), chan.getEffectiveTime(), chan.getSite());
    }

    public static String toString(Orientation orientation) {
        return "az=" + orientation.azimuth + ", dip=" + orientation.dip;
    }
}

